package com.biz.crm.tpm.business.activity.plan.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 活动方案明细产品表(ActivityPlanItemProduct)
 *
 * @author wanghaojia
 * @since 2022-11-01 14:39:19
 */
@ApiModel(value = "ActivityPlanItemProduct", description = "活动方案明细产品表")
@TableName("tpm_activity_plan_item_product")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_item_product")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_item_product", comment = "活动方案明细产品表")
@Table(
        name = "tpm_activity_plan_item_product",
        indexes = {
                @Index(name = "tpm_activity_plan_item_product_inx1", columnList = "plan_item_code,", unique = false),
                @Index(name = "tpm_activity_plan_item_product_inx2", columnList = "plan_code,", unique = false)
        }
)
public class ActivityPlanItemProduct extends UuidEntity {

    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    @Column(name = "plan_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动方案编码'")
    private String planCode;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    @Column(name = "plan_item_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动方案明细编码'")
    private String planItemCode;
  /**
     * 活动方案明细编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;
  /**
     * 活动方案明细编码
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 128, columnDefinition = "varchar(128) COMMENT '产品名称'")
    private String productName;

}

