package com.biz.crm.tpm.business.activity.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author : dengwei
 * @Date :2023/10/3  15:37
 * @Description: 活动方案关联细案
 */
@ApiModel(value = "ActivityPlanItemRelateDetailItem", description = "活动方案关联细案")
@TableName("tpm_activity_plan_item_relate_detail_item")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_item_relate_detail_item")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_item_relate_detail_item", comment = "活动方案关联细案")
@Table(
        name = "tpm_activity_plan_item_relate_detail_item",
        indexes = {
                @Index(name = "tpm_activity_plan_item_relate_detail_item_inx1", columnList = "plan_item_code,", unique = false),
                @Index(name = "tpm_activity_plan_item_relate_detail_item_inx2", columnList = "plan_code,", unique = false)
        }
)
public class ActivityPlanItemRelateDetailItem extends TenantFlagOpEntity {

    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    @Column(name = "plan_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动方案编码'")
    private String planCode;

    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    @Column(name = "plan_item_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动方案明细编码'")
    private String planItemCode;

    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    @Column(name = "template_config_code", length = 32, columnDefinition = "varchar(32) COMMENT '方案模板编码'")
    private String templateConfigCode;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动类型编码'")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动类型名称'")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式编码'")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式名称'")
    private String activityFormName;
    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;
    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区编码 '")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区编码 '")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属销售大区编码 '")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售组织(组)编码'")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '所属销售组织(组)编码'")
    private String salesOrgCode;


    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售组织(组)名称'")
    private String salesOrgName;

    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_begin_date", columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndDate;

    /**
     * 订单开始时间
     */
    @ApiModelProperty("订单开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "order_begin_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date orderBeginDate;
    /**
     * 订单结束时间
     */
    @ApiModelProperty("订单结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "order_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date orderEndDate;

    /**
     * 总部预算编码
     */
    @ApiModelProperty("总部预算编码")
    @Column(name = "head_month_budget_code", length = 32, columnDefinition = "varchar(32) COMMENT '总部预算编码'")
    private String headMonthBudgetCode;

    /**
     * 总部预算项目名称
     */
    @ApiModelProperty("总部预算项目名称")
    @Column(name = "head_budget_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '总部预算项目名称'")
    private String headBudgetItemName;

    /**
     * 大区预算编码
     */
    @ApiModelProperty("预算编码/大区预算编码")
    @Column(name = "month_budget_code", length = 32, columnDefinition = "varchar(32) COMMENT '大区预算编码'")
    private String monthBudgetCode;
    /**
     * 大区预算项目名称
     */
    @ApiModelProperty("大区预算项目名称")
    @Column(name = "budget_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '大区预算项目名称'")
    private String budgetItemName;

    @ApiModelProperty(value = "* 随车搭赠组合")
    @Column(name = "car_gift_group", length = 32, columnDefinition = "VARCHAR(32) COMMENT '随车搭赠组合'")
    private String carGiftGroup;
    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    @Column(name = "activity_org_code", length = 32, columnDefinition = "varchar(32) COMMENT '区域编码'")
    private String activityOrgCode;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    @Column(name = "activity_org_name", length = 255, columnDefinition = "varchar(255) COMMENT '区域名称'")
    private String activityOrgName;
    /**
     * 一级管理渠道编码
     */
    @ApiModelProperty("一级管理渠道编码")
    @Column(name = "first_channel_code", length = 128, columnDefinition = "varchar(128) COMMENT '一级管理渠道编码'")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    @Column(name = "first_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '一级管理渠道名称'")
    private String firstChannelName;
    /**
     * 二级管理渠道编码
     */
    @ApiModelProperty("二级管理渠道编码")
    @Column(name = "second_channel_code", length = 128, columnDefinition = "varchar(128) COMMENT '二级管理渠道编码'")
    private String secondChannelCode;
    /**
     * 二级管理渠道名称
     */
    @ApiModelProperty("二级管理渠道名称")
    @Column(name = "second_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '二级管理渠道名称'")
    private String secondChannelName;
    @ApiModelProperty("分销渠道编码")
    @Column(name = "distribution_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道编码'")
    private String distributionChannelCode;

    @ApiModelProperty("分销渠道名称")
    @Column(name = "distribution_channel_name", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道名称'")
    private String distributionChannelName;
    @CrmExcelColumn(value = "客户组编码")
    @Column(name = "customer_group_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户组编码'")
    private String customerGroupCode;

    @CrmExcelColumn(value = "客户组名称")
    @Column(name = "customer_group_name", length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerGroupName;
    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户ERP编码")
    @Column(name = "customer_erp_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户ERP编码'")
    private String customerErpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;

    /**
     * 促销对象
     */
    @ApiModelProperty("促销对象")
    @Column(name = "promotion_object", length = 32, columnDefinition = "varchar(32) COMMENT '促销对象'")
    private String promotionObject;

    /**
     * 促销类型
     */
    @ApiModelProperty("促销类型")
    @Column(name = "promotion_type", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '促销类型'")
    private String promotionType;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", length = 32, columnDefinition = "varchar(32) COMMENT '品牌编码'")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", length = 255, columnDefinition = "varchar(255) COMMENT '品牌名称'")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    @Column(name = "product_category_code", length = 32, columnDefinition = "varchar(32) COMMENT '品类编码'")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @Column(name = "product_category_name", length = 255, columnDefinition = "varchar(255) COMMENT '品类名称'")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @Column(name = "product_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '品项编码'")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @Column(name = "product_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '品项名称'")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    /**
     * 单位编码
     */
    @ApiModelProperty("单位编码")
    @Column(name = "product_unit", length = 32, columnDefinition = "varchar(32) COMMENT '单位编码'")
    private String productUnit;

    /**
     * 产品价格
     */
    @ApiModelProperty("产品价格")
    @Column(name = "product_price", length = 32, columnDefinition = "decimal(24,6) COMMENT '原品价格'")
    private BigDecimal productPrice;

    /**
     * 赠品编码
     */
    @ApiModelProperty("赠品编码")
    @Column(name = "gift_code", length = 32, columnDefinition = "varchar(32) COMMENT '单位编码'")
    private String giftCode;
    /**
     * 赠品名称
     */
    @ApiModelProperty("赠品名称")
    @Column(name = "gift_name", length = 255, columnDefinition = "varchar(255) COMMENT '赠品名称'")
    private String giftName;

    /**
     * 原品数量
     */
    @ApiModelProperty("原品数量")
    @Column(name = "product_quantity", length = 32, columnDefinition = "int(11) COMMENT '原品数量'")
    private Integer productQuantity;

    /**
     * 赠品数量
     */
    @ApiModelProperty("赠品数量")
    @Column(name = "gift_quantity", length = 32, columnDefinition = "int(11) COMMENT '赠品数量'")
    private Integer giftQuantity;

    /**
     * 活动描述
     */
    @ApiModelProperty("活动描述")
    @Column(name = "activity_desc", length = 255, columnDefinition = "varchar(1024) COMMENT '活动描述'")
    private String activityDesc;

    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    @Column(name = "total_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用合计'")
    private BigDecimal totalFeeAmount;

    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    @Column(name = "head_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '总部承担金额'")
    private BigDecimal headFeeAmount;

    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    @Column(name = "department_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '大区承担金额'")
    private BigDecimal departmentFeeAmount;

    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    @Column(name = "customer_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '客户承担金额'")
    private BigDecimal customerFeeAmount;

    /**
     * 预估销售额
     */
    @ApiModelProperty("预估销售额")
    @Column(name = "sales_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '预估销售额'")
    private BigDecimal salesAmount;

    /**
     * 预估费率
     */
    @ApiModelProperty("预估费率")
    @Column(name = "fee_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '预估费率'")
    private BigDecimal feeRate;

    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    @Column(name = "audit_condition_code", length = 32, columnDefinition = "varchar(32) COMMENT '核销条件编码'")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    @Column(name = "audit_condition_name", length = 255, columnDefinition = "varchar(255) COMMENT '核销条件名称'")
    private String auditConditionName;

    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    @Column(name = "audit_type", length = 30, columnDefinition = "varchar(30) COMMENT '核销类型'")
    private String auditType;

    /**
     * 赠品单位
     */
    @ApiModelProperty("赠品单位")
    @Column(name = "gift_unit", length = 32, columnDefinition = "varchar(32) COMMENT '赠品单位'")
    private String giftUnit;

    /**
     * 总部预算项目编码
     */
    @ApiModelProperty("总部预算项目编码")
    @Column(name = "head_budget_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '总部预算项目编码'")
    private String headBudgetItemCode;

    /**
     * 大区预算项目编码
     */
    @ApiModelProperty("大区预算项目编码")
    @Column(name = "budget_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '大区预算项目编码'")
    private String budgetItemCode;
}
