package com.biz.crm.tpm.business.activity.plan.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 活动方案部门表(ActivityPlanOrg)
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:57
 */
@ApiModel(value = "ActivityPlanOrg", description = "活动方案部门表")
@TableName("tpm_activity_plan_org")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_org")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_org", comment = "活动方案表")
@Table(
        name = "tpm_activity_plan_org",
        indexes = {
                @Index(name = "tpm_activity_plan_org_inx1", columnList = "plan_code,org_code", unique = true),
                @Index(name = "tpm_activity_plan_org_inx2", columnList = "plan_id", unique = false),
        }
)
public class ActivityPlanOrg extends TenantFlagOpEntity {

    /**
     * 方案编码
     */
    @ApiModelProperty("方案编码")
    @Column(name = "plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案编码'")
    private String planCode;

    /**
     * 方案Id
     */
    @ApiModelProperty("方案Id")
    @Column(name = "plan_id", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案Id'")
    private String planId;

    /**
     * 组织编码
     */
    @ApiModelProperty("组织编码")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '组织编码'")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    @Column(name = "org_name", nullable = true, length = 256, columnDefinition = "varchar(256) COMMENT '组织名称'")
    private String orgName;

}

