package com.biz.crm.tpm.business.activity.plan.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 活动方案-策略表(ActivityPlanStrategy)
 *
 * @author wanghaojia
 * @since 2022-11-01 14:39:19
 */
@ApiModel(value = "ActivityPlanStrategy", description = "活动方案-策略表")
@TableName("tpm_activity_plan_strategy")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_strategy")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_strategy", comment = "活动方案-策略表")
@Table(
        name = "tpm_activity_plan_strategy",
        indexes = {
                @Index(name = "tpm_activity_plan_strategy_inx1", columnList = "plan_code,", unique = false),
        }
)
public class ActivityPlanStrategy extends TenantFlagOpEntity {

    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    @Column(name = "plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动方案编码'")
    private String planCode;

    /**
     * 营销策略编码
     */
    @ApiModelProperty("营销策略编码")
    @Column(name = "strategy_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '营销策略编码'")
    private String strategyCode;
    /**
     * 营销策略编码
     */
    @ApiModelProperty("营销策略明细编码")
    @Column(name = "strategy_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '营销策略明细编码'")
    private String strategyItemCode;
    /**
     * 营销策略名称
     */
    @ApiModelProperty("营销策略名称")
    @Column(name = "strategy_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '营销策略名称'")
    private String strategyName;
    /**
     * 营销策略名称
     */
    @ApiModelProperty("营销策略类型")
    @Column(name = "strategy_type", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '营销策略类型'")
    private String strategyType;

    /**
     * 费用金额（元）
     */
    @ApiModelProperty("费用金额（元）")
    @Column(name = "fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '费用金额（元）'")
    private BigDecimal feeAmount;


    @ApiModelProperty("已申请金额")
    @Column(name = "used_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '已申请金额（万元）'")
    private BigDecimal usedAmount;


    @ApiModelProperty("剩余可用策略金额")
    @Column(name = "usable_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '剩余可用策略金额（万元）'")
    private BigDecimal usableAmount;


    @ApiModelProperty("本次使用策略金额")
    @Column(name = "use_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本次使用策略金额'")
    private BigDecimal useAmount;

    @ApiModelProperty("关联策略总金额（元）")
    @Column(name = "strategy_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '关联策略总金额（元）'")
    private BigDecimal strategyFeeAmount;


    @ApiModelProperty("关联策略已申请总金额（元）")
    @Column(name = "strategy_used_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '关联策略已申请总金额（元）'")
    private BigDecimal strategyUsedAmount;


    @ApiModelProperty("关联策略剩余可申请总金额（元）")
    @Column(name = "strategy_usable_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '关联策略剩余可申请总金额（元）'")
    private BigDecimal strategyUsableAmount;

}

