package com.biz.crm.tpm.business.activity.plan.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 活动方案表-模板配置(ActivityPlan)
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:57
 */
@ApiModel(value = "ActivityPlanTemplate", description = "活动方案表-模板配置")
@TableName("tpm_activity_plan_template")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_template")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_template", comment = "活动方案表-模板配置")
@Table(
        name = "tpm_activity_plan_template",
        indexes = {
                @Index(name = "tpm_ap_template_inx1", columnList = "plan_code"),
        }
)
public class ActivityPlanTemplate extends TenantFlagOpEntity {

    /**
     * 方案编码
     */
    @ApiModelProperty("方案编码")
    @Column(name = "plan_code", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '方案编码'")
    private String planCode;

    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    @Column(name = "template_config_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案模板编码'")
    private String templateConfigCode;

    /**
     * 方案模板名称
     */
    @ApiModelProperty("方案模板名称")
    @Column(name = "template_config_name", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案模板名称'")
    private String templateConfigName;

    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    @Column(name = "audit_type", length = 32, columnDefinition = "varchar(32) COMMENT '核销类型'")
    private String auditType;

    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    @Column(name = "audit_condition_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '核销条件编码'")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    @Column(name = "audit_condition_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '核销条件名称'")
    private String auditConditionName;

}

