package com.biz.crm.tpm.business.activity.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @CLASS_DESCRIBE: 修正折扣率_量子
 * @AUTHOR: create by zkey on 2023-11-08
 */
@ApiModel(value = "CorrectionDiscountRateQuantum", description = "修正折扣率_量子-跑帆软")
@TableName("tpm_correction_discount_rate_quantum")
@Getter
@Setter
@Entity(name = "tpm_correction_discount_rate_quantum")
@org.hibernate.annotations.Table(appliesTo = "tpm_correction_discount_rate_quantum", comment = "修正折扣率_量子-跑帆软")
@Table(
        name = "tpm_correction_discount_rate_quantum",
        indexes = {
                @Index(name = "tpm_correction_discount_rate_quantum_inx1", columnList = "year_month_str"),
                @Index(name = "tpm_correction_discount_rate_quantum_inx2", columnList = "region_code"),
                @Index(name = "tpm_correction_discount_rate_quantum_inx3", columnList = "system_code"),
        }
)
public class CorrectionDiscountRateQuantum extends TenantOpEntity {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format]'")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit]'")
    private String businessUnitCode;
    @ApiModelProperty(value = "year_month_str", name = "年月", notes = "年月")
    @Column(name = "year_month_str", length = 10, columnDefinition = "VARCHAR(10) COMMENT '年月'")
    private String yearMonthStr;

    @ApiModelProperty(value = "last_month", name = "上月", notes = "上月")
    @Column(name = "last_month", length = 10, columnDefinition = "VARCHAR(10) COMMENT '上月'")
    private String lastMonth;

    @ApiModelProperty(value = "last_last_month", name = "上上月", notes = "上上月")
    @Column(name = "last_last_month", length = 10, columnDefinition = "VARCHAR(10) COMMENT '上上月'")
    private String lastLastMonth;

    @ApiModelProperty("区域编码")
    @Column(name = "region_code", columnDefinition = "varchar(255) COMMENT '区域编码'")
    private String regionCode;

    @ApiModelProperty("区域名称")
    @Column(name = "region_name", columnDefinition = "varchar(255) COMMENT '区域名称'")
    private String regionName;

    @ApiModelProperty("系统/零售商编码")
    @Column(name = "system_code", length = 32, columnDefinition = "varchar(32) COMMENT '系统/零售商编码'")
    private String systemCode;

    @ApiModelProperty("系统/零售商名称")
    @Column(name = "system_name", length = 200, columnDefinition = "varchar(200) COMMENT '系统/零售商名称'")
    private String systemName;

    @ApiModelProperty("量子")
    @Column(name = "quantum", columnDefinition = "varchar(255) COMMENT '量子'")
    private String quantum;

    @ApiModelProperty("折后销售额")
    @Column(name = "discount_after_sales_amount", columnDefinition = "decimal(30,6) COMMENT '折后销售额'")
    private BigDecimal discountAfterSalesAmount;

    @ApiModelProperty("事中申请金额")
    @Column(name = "event_centre_amount", columnDefinition = "decimal(30,6) COMMENT '事中申请金额'")
    private BigDecimal eventCentreAmount;

    @ApiModelProperty("事后费用处理")
    @Column(name = "event_after_amount", columnDefinition = "decimal(30,6) COMMENT '事后费用处理'")
    private BigDecimal eventAfterAmount;

    @ApiModelProperty("红票")
    @Column(name = "red_ticket", columnDefinition = "decimal(30,6) COMMENT '红票'")
    private BigDecimal redTicket;

    @ApiModelProperty("费用池剩余")
    @Column(name = "cost_pool_residue", columnDefinition = "decimal(30,6) COMMENT '费用池剩余'")
    private BigDecimal costPoolResidue;

    @ApiModelProperty("费用合计")
    @Column(name = "cost_total", columnDefinition = "decimal(30,6) COMMENT '费用合计'")
    private BigDecimal costTotal;

    @ApiModelProperty("折前销售额")
    @Column(name = "discount_before_sales_amount", columnDefinition = "decimal(30,6) COMMENT '折前销售额'")
    private BigDecimal discountBeforeSalesAmount;

    @ApiModelProperty("修正折前折扣率")
    @Column(name = "correction_discount_before_rate", columnDefinition = "decimal(30,6) COMMENT '修正折前折扣率'")
    private BigDecimal correctionDiscountBeforeRate;

    @ApiModelProperty("修正折后折扣率")
    @Column(name = "correction_discount_after_rate", columnDefinition = "decimal(30,6) COMMENT '修正折后折扣率'")
    private BigDecimal correctionDiscountAfterRate;

    @ApiModelProperty("预算折后折扣率")
    @Column(name = "budget_discount_after_rate", columnDefinition = "decimal(30,6) COMMENT '预算折后折扣率'")
    private BigDecimal budgetDiscountAfterRate;

    @ApiModelProperty("VS预算折后折扣率偏差")
    @Column(name = "vs_offset", columnDefinition = "decimal(30,6) COMMENT 'VS预算折后折扣率偏差'")
    private BigDecimal vsOffset;
}
