package com.biz.crm.tpm.business.activity.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @CLASS_DESCRIBE: 营销费用使用进度-跑帆软
 * @AUTHOR: create by zkey on 2023-11-04
 */
@ApiModel(value = "MarketingFeeUseProgress", description = "营销费用使用进度-跑帆软")
@TableName("tpm_marketing_fee_use_progress")
@Getter
@Setter
@Entity(name = "tpm_marketing_fee_use_progress")
@org.hibernate.annotations.Table(appliesTo = "tpm_marketing_fee_use_progress", comment = "营销费用使用进度-跑帆软")
@Table(
        name = "tpm_marketing_fee_use_progress",
        indexes = {
                @Index(name = "tpm_marketing_fee_use_progress_inx1", columnList = "year_month_str,region,system_code"),
        }
)
public class MarketingFeeUseProgress extends TenantOpEntity {

        @ApiModelProperty(value = "year_month_str", name = "年月", notes = "年月")
        @Column(name = "year_month_str", length = 10, columnDefinition = "VARCHAR(10) COMMENT '年月'")
        private String yearMonthStr;

        @ApiModelProperty("区域")
        @Column(name = "region", length = 255, columnDefinition = "varchar(255) COMMENT '区域'")
        private String region;

        @ApiModelProperty("系统/零售商编码")
        @Column(name = "system_code", length = 32, columnDefinition = "varchar(32) COMMENT '系统/零售商编码'")
        private String systemCode;

        @ApiModelProperty("系统/零售商名称")
        @Column(name = "system_name", length = 200, columnDefinition = "varchar(200) COMMENT '系统/零售商名称'")
        private String systemName;

        @ApiModelProperty("销量达成率")
        @Column(name = "sales_achievement_rate", columnDefinition = "decimal(20,4) COMMENT '销量达成率'")
        private BigDecimal salesAchievementRate;

        @ApiModelProperty("POS费用率")
        @Column(name = "pos_fee_rate", columnDefinition = "decimal(20,4) COMMENT 'POS费用率'")
        private BigDecimal posFeeRate;

        @ApiModelProperty("整体营销费用率")
        @Column(name = "overall_marketing_fee_rate", columnDefinition = "decimal(20,4) COMMENT '整体营销费用率'")
        private BigDecimal overallMarketingFeeRate;

        @ApiModelProperty("总部预留")
        @Column(name = "head_reserve", columnDefinition = "decimal(30,6) COMMENT '总部预留'")
        private BigDecimal headReserve;

        @ApiModelProperty("超额利润转投")
        @Column(name = "excess_profit_conversion", columnDefinition = "decimal(30,6) COMMENT '超额利润转投'")
        private BigDecimal excessProfitConversion;

        @ApiModelProperty("区域授权费用")
        @Column(name = "region_auth_fee", columnDefinition = "decimal(30,6) COMMENT '区域授权费用'")
        private BigDecimal regionAuthFee;

        @ApiModelProperty("VS同期")
        @Column(name = "vs_tq", columnDefinition = "decimal(30,6) COMMENT 'VS同期'")
        private BigDecimal vsTq;

        @ApiModelProperty("折后实际销额")
        @Column(name = "discount_sales_amount", columnDefinition = "decimal(30,6) COMMENT '折后实际销额'")
        private BigDecimal discountSalesAmount;

        @ApiModelProperty("销售任务折后金额")
        @Column(name = "sales_discount_amount", columnDefinition = "decimal(30,6) COMMENT '销售任务折后金额'")
        private BigDecimal salesDiscountAmount;

        @ApiModelProperty("销量达成进度")
        @Column(name = "sales_achievement_progress", columnDefinition = "decimal(30,6) COMMENT '销量达成进度'")
        private BigDecimal salesAchievementProgress;

        @ApiModelProperty("年度预算金额")
        @Column(name = "year_budget_amount", columnDefinition = "decimal(30,6) COMMENT '年度预算金额'")
        private BigDecimal yearBudgetAmount;

        @ApiModelProperty("费用使用进度")
        @Column(name = "fee_use_progress", columnDefinition = "decimal(30,6) COMMENT '费用使用进度'")
        private BigDecimal feeUseProgress;
}
