package com.biz.crm.tpm.business.activity.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @CLASS_DESCRIBE: 营销费用使用进度-跑帆软(中间表)
 * @AUTHOR: create by zkey on 2023-11-04
 */
@ApiModel(value = "MarketingFeeUseProgressMiddle", description = "营销费用使用进度-跑帆软(中间表)")
@TableName("tpm_marketing_fee_use_progress_middle")
@Getter
@Setter
@Entity(name = "tpm_marketing_fee_use_progress_middle")
@org.hibernate.annotations.Table(appliesTo = "tpm_marketing_fee_use_progress_middle", comment = "营销费用使用进度-跑帆软(中间表)")
@Table(
        name = "tpm_marketing_fee_use_progress_middle",
        indexes = {
                @Index(name = "tpm_marketing_fee_use_progress_middle", columnList = "year_month_str,region,system_code"),
        }
)
public class MarketingFeeUseProgressMiddle extends UuidEntity {

    @ApiModelProperty("活动方案编码")
    @Column(name = "plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动方案编码'")
    private String planCode;

    @ApiModelProperty(value = "year_month_str", name = "年月", notes = "年月")
    @Column(name = "year_month_str", length = 10, columnDefinition = "VARCHAR(10) COMMENT '年月'")
    private String yearMonthStr;

    @ApiModelProperty("区域")
    @Column(name = "region", columnDefinition = "varchar(255) COMMENT '区域'")
    private String region;

    @ApiModelProperty("系统/零售商编码")
    @Column(name = "system_code", length = 32, columnDefinition = "varchar(32) COMMENT '系统/零售商编码'")
    private String systemCode;

    @ApiModelProperty("系统/零售商名称")
    @Column(name = "system_name", length = 200, columnDefinition = "varchar(200) COMMENT '系统/零售商名称'")
    private String systemName;

    @ApiModelProperty("总部预留")
    @Column(name = "head_reserve", columnDefinition = "decimal(30,6) COMMENT '总部预留'")
    private BigDecimal headReserve;

    @ApiModelProperty("超额利润转投")
    @Column(name = "excess_profit_conversion", columnDefinition = "decimal(30,6) COMMENT '超额利润转投'")
    private BigDecimal excessProfitConversion;

    @ApiModelProperty("区域授权费用")
    @Column(name = "region_auth_fee", columnDefinition = "decimal(30,6) COMMENT '区域授权费用'")
    private BigDecimal regionAuthFee;
}
