package com.biz.crm.tpm.business.activity.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 免费货物接口回调
 * @author wanghaojia
 * @date 2023/3/2 20:18
 */
@TableName("tpm_plan_free_goods_mapping")
@Getter
@Setter
@Entity(name = "tpm_plan_free_goods_mapping")
@Table(name = "tpm_plan_free_goods_mapping",
        indexes = {
                @Index(name = "plan_free_goods_mapping_inx0", columnList = "plan_code", unique = false),
                @Index(name = "plan_free_goods_mapping_inx1", columnList = "plan_item_code,", unique = false),
                @Index(name = "plan_free_goods_mapping_inx2", columnList = "message_id,", unique = false)
        })
@org.hibernate.annotations.Table(appliesTo = "tpm_plan_free_goods_mapping", comment = "TPM-免费货物接口回调")
public class PlanFreeGoodsMapping extends UuidEntity {

    /**
     * 方案编码
     */
    @Column(name = "plan_code", nullable = false, length = 32, columnDefinition = "varchar(32) COMMENT '方案编码'")
    private String planCode;
    /**
     * 方案明细编码
     */
    @Column(name = "plan_item_code", nullable = false, length = 32, columnDefinition = "varchar(32) COMMENT '方案明细编码'")
    private String planItemCode;

    /**
     * 传给SAP的消息id
     */
    @Column(name = "message_id", nullable = false, length = 32, columnDefinition = "varchar(32) COMMENT '传给SAP的消息id'")
    private String messageId;

    /**
     * 传给SAP的流水号
     */
    @Column(name = "cond_no", nullable = false, length = 32, columnDefinition = "varchar(32) COMMENT '传给SAP的流水号'")
    private String condNo;

    /**
     * SAP返回的记录号
     */
    @Column(name = "cond_no_new", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT 'SAP返回的记录号'")
    private String condNoNew;

}
