package com.biz.crm.tpm.business.activity.plan.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 活动方案表-模板配置(ActivityPlan)
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:57
 */
@ApiModel(value = "SfaActivityPlanItem", description = "SFA推送过来的活动方案明细")
@TableName("sfa_activity_plan_item")
@Getter
@Setter
@Entity(name = "sfa_activity_plan_item")
@org.hibernate.annotations.Table(appliesTo = "sfa_activity_plan_item", comment = "活动方案表-模板配置")
@Table(
        name = "sfa_activity_plan_item",
        indexes = {
                @Index(name = "sfa_activity_plan_item_inx1", columnList = "sfa_plan_code"),
        }
)
public class SfaActivityPlanItem extends TenantFlagOpEntity {

    /**
     * SFA活动号
     */
    @ApiModelProperty(value = "SFA活动号")
    @Column(name = "sfa_plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT 'SFA活动号'")
    private String sfaPlanCode;

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty("业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业务单元'")
    private String businessUnitCode;
    /**
     * 方案类型
     */
    @ApiModelProperty("方案类型")
    @Column(name = "plan_type", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案类型'")
    private String planType;
    /**
     * 方案名称
     */
    @ApiModelProperty("方案名称")
    @Column(name = "plan_name", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案名称'")
    private String planName;
    /**
     * 方案分类
     */
    @ApiModelProperty("方案分类")
    @Column(name = "plan_classify", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案分类'")
    private String planClassify;
    /**
     * 部门编码
     */
    @ApiModelProperty("部门编码")
    @Column(name = "department_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '部门编码'")
    private String departmentCode;

    /**
     * 部门名称
     */
    @ApiModelProperty("部门名称")
    @Column(name = "department_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '部门名称'")
    private String departmentName;
    /**
     * 方案范围编码
     */
    @ApiModelProperty("方案范围编码")
    @Column(name = "plan_org_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案范围编码'")
    private String planOrgCode;
    /**
     * 方案范围名称
     */
    @ApiModelProperty("方案范围名称")
    @Column(name = "plan_org_name", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案范围名称'")
    private String planOrgName;
    /**
     * 方案关联限制，数据字典tpm_activity_plan_relate_limit
     */
    @ApiModelProperty("方案关联限制，数据字典tpm_activity_plan_relate_limit")
    @Column(name = "plan_relate_limit_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案关联限制'")
    private String planRelateLimitCode;
    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_begin_date", columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndDate;

    /**
     * 活动分类编码
     */
    @ApiModelProperty("活动分类编码")
    @Column(name = "activity_type_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动类型编码'")
    private String activityTypeCode;
    /**
     * 活动分类名称
     */
    @ApiModelProperty("活动分类名称")
    @Column(name = "activity_type_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动分类名称'")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动形式编码'")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式名称'")
    private String activityFormName;

    /**
     * 方案开始时间
     */
    @ApiModelProperty("方案开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "begin_date",  columnDefinition = "datetime COMMENT '方案开始时间'")
    private Date beginDate;
    /**
     * 方案结束时间
     */
    @ApiModelProperty("方案结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "end_date",  columnDefinition = "datetime COMMENT '方案结束时间'")
    private Date endDate;

    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道")
    @Column(name = "first_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '一级管理渠道'")
    private String firstChannelCode;
    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道名称")
    @Column(name = "first_channel_name", length = 255, columnDefinition = "varchar(255) COMMENT '一级管理渠道名称'")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    @Column(name = "second_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '二级管理渠道'")
    private String secondChannelCode;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道名称")
    @Column(name = "second_channel_name", length = 255, columnDefinition = "varchar(255) COMMENT '二级管理渠道名称'")
    private String secondChannelName;

    /**
     * MDM客户编码
     */
    @ApiModelProperty("MDM客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "varchar(32) COMMENT 'MDM客户编码'")
    private String customerCode;

    /**
     * MDG客户编码
     */
    @ApiModelProperty("MDG客户编码")
    @Column(name = "customer_erp_code", length = 32, columnDefinition = "varchar(32) COMMENT 'MDG客户编码'")
    private String customerErpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;

    /**
     * 数量
     */
    @ApiModelProperty("数量")
    @Column(name = "quantity", length = 11, columnDefinition = "int(11) COMMENT '数量'")
    private Integer quantity;
    /**
     * 陈列数量
     */
    @ApiModelProperty("陈列数量")
    @Column(name = "display_quantity", columnDefinition = "DECIMAL(24,6) COMMENT '陈列数量'")
    private BigDecimal displayQuantity;

    /**
     * SFA协议金额
     */
    @ApiModelProperty("SFA协议金额")
    @Column(name = "sfa_fee_amount", columnDefinition = "DECIMAL(24,6) COMMENT 'SFA协议金额'")
    private BigDecimal sfaFeeAmount;

    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型，数据字典：tpm_audit_type")
    @Column(name = "audit_type", length = 32, columnDefinition = "varchar(32) COMMENT '核销类型'")
    private String auditType;

    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    @Column(name = "audit_condition_code", length = 32, columnDefinition = "varchar(32) COMMENT '核销条件编码'")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    @Column(name = "audit_condition_name", length = 128, columnDefinition = "varchar(128) COMMENT '核销条件名称'")
    private String auditConditionName;
    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    @Column(name = "activity_org_code", length = 32, columnDefinition = "varchar(32) COMMENT '销售组织编码'")
    private String activityOrgCode;
    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    @Column(name = "activity_org_name", length = 128, columnDefinition = "varchar(128) COMMENT '销售组织名称'")
    private String activityOrgName;
    /**
     * 促销对象
     */
    @ApiModelProperty("促销对象")
    @Column(name = "promotion_object", length = 32, columnDefinition = "varchar(32) COMMENT '促销对象'")
    private String promotionObject;
    /**
     * 是否完全承接
     */
    @ApiModelProperty("是否完全承接")
    @Column(name = "full_accept", length = 32, columnDefinition = "varchar(32) COMMENT '是否完全承接'")
    private String fullAccept;
    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    @Column(name = "template_config_code", length = 32, columnDefinition = "varchar(32) COMMENT '方案模板编码'")
    private String templateConfigCode;
    /**
     * 方案模板名称
     */
    @ApiModelProperty("方案模板名称")
    @Column(name = "template_config_name", length = 128, columnDefinition = "varchar(128) COMMENT '方案模板名称'")
    private String templateConfigName;
    /**
     * 预估销售额（万元）
     */
    @ApiModelProperty("预估销售额（万元）")
    @Column(name = "sales_amount", columnDefinition = "DECIMAL(24,6) COMMENT '预估销售额（万元）'")
    private BigDecimal salesAmount;

}

