package com.biz.crm.tpm.business.activity.plan.local.event;

import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyQueryActivityPlanDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.event.MarketingStrategyQueryActivityPlanListener;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyQueryActivityPlanResponse;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.StrategyActivityPlanItemVo;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/8/2 14:52
 */
@Slf4j
@Component
public class MarketingStrategyQueryActivityPlanListenerImpl implements MarketingStrategyQueryActivityPlanListener {

    @Autowired(required = false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;

    @Override
    public MarketingStrategyQueryActivityPlanResponse strategyRelatePlanCodeList(MarketingStrategyQueryActivityPlanDto eventDto) {
        MarketingStrategyQueryActivityPlanResponse response= new MarketingStrategyQueryActivityPlanResponse();
        if (CollectionUtils.isEmpty(eventDto.getPlanCodeList())){
            return response;
        }
        MarsAuthorityContextHolder.clearContext();
        List<String> strategyCodeList = activityPlanBudgetRepository.strategyRelatePlanCodeList(Sets.newHashSet(eventDto.getPlanCodeList()));
        response.setStrategyCodeList(strategyCodeList);
        return response;
    }

    @Override
    public MarketingStrategyQueryActivityPlanResponse findActivityPlanList(MarketingStrategyQueryActivityPlanDto eventDto) {
        MarketingStrategyQueryActivityPlanResponse response= new MarketingStrategyQueryActivityPlanResponse();
        if (CollectionUtils.isEmpty(eventDto.getStrategyItemCodeList())){
            return response;
        }
        MarsAuthorityContextHolder.clearContext();
        List<StrategyActivityPlanItemVo> activityPlanByStrategyItemCodeList = activityPlanBudgetRepository.findActivityPlanByStrategyItemCodeList(eventDto.getStrategyItemCodeList());
        response.setPlanList(activityPlanByStrategyItemCodeList);
        return response;
    }
}
