package com.biz.crm.tpm.business.activity.plan.local.exports.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.local.exports.vo.ActivityPlanItemExportsVo;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2023/2/7 15:06
 * @description: 活动方案明细导出
 */
@Slf4j
@Component
public class ActivityPlanItemExportsProcess implements ExportProcess<ActivityPlanItemExportsVo> {
    @Autowired(required = false)
    private ActivityPlanItemService activityPlanItemService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private ActivityPlanItemPageCacheHelper pageCacheHelper;

    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        Object cacheKeyObj = params.get("cacheKey");
        Validate.notNull(cacheKeyObj, "缓存键，参数未传入");
        String cacheKey = cacheKeyObj.toString();
        Integer total = pageCacheHelper.getTotal(cacheKey);
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        String cacheKey = (String) params.get("cacheKey");
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, this.getPageSize());
        ActivityPlanItemDto dto = new ActivityPlanItemDto();
        Page<ActivityPlanItemVo> cachePage = activityPlanItemService.findCachePageList(pageable, dto, cacheKey);
        if (cachePage.getTotal() == 0) {
            return new JSONArray();
        }
        Collection<ActivityPlanItemExportsVo> exportsVos = nebulaToolkitService.copyCollectionByWhiteList(
                cachePage.getRecords(), ActivityPlanItemVo.class, ActivityPlanItemExportsVo.class, LinkedHashSet.class, ArrayList.class);
        //调整
        adjustData(exportsVos);
        return JSON.parseArray(JSON.toJSONString(exportsVos));
    }

    @Override
    public String getBusinessCode() {
        return "TPM_ACTIVITY_PLAN_ITEM_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "活动方案明细导出";
    }

    /**
     * 调整数据
     *
     * @param data
     */
    private void adjustData(Collection<ActivityPlanItemExportsVo> data) {
        Map<String, String> poMap = dictToolkitService.findMapByDictTypeCode(ActivityPlanConstant.DICT_TPM_PROMOTION_OBJECT);
        Map<String, String> ptMap = dictToolkitService.findMapByDictTypeCode(ActivityPlanConstant.DICT_TPM_ACTIVITY_PLAN_PROMOTION_TYPE);
        Map<String, String> atMap = dictToolkitService.findMapByDictTypeCode(ActivityPlanConstant.DICT_TPM_AUDIT_TYPE);

        for (ActivityPlanItemExportsVo vo : data) {
            if (null != vo.getActivityBeginDate()) {
                vo.setActivityBeginDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getActivityBeginDate()));
            }
            if (null != vo.getActivityEndDate()) {
                vo.setActivityEndDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getActivityEndDate()));
            }
            if (null != vo.getOrderBeginDate()) {
                vo.setOrderBeginDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getOrderBeginDate()));
            }
            if (null != vo.getOrderEndDate()) {
                vo.setOrderEndDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getOrderEndDate()));
            }
            if (StringUtils.isNotBlank(vo.getPromotionObject())) {
                vo.setPromotionObject(poMap.getOrDefault(vo.getPromotionObject(), vo.getPromotionObject()));
            }
            if (StringUtils.isNotBlank(vo.getPromotionType())) {
                vo.setPromotionType(ptMap.getOrDefault(vo.getPromotionType(), vo.getPromotionType()));
            }
            if (StringUtils.isNotBlank(vo.getAuditType())) {
                vo.setAuditType(atMap.getOrDefault(vo.getAuditType(), vo.getAuditType()));
            }
        }
    }

    /**
     * 获取对象转换实体
     *
     * @return
     */
    @Override
    public Class<ActivityPlanItemExportsVo> findCrmExcelVoClass() {
        return ActivityPlanItemExportsVo.class;
    }
}
