package com.biz.crm.tpm.business.activity.plan.local.exports.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.ie.sdk.process.MnExportProcess;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemRelateDetailItemService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemRelateDetailItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemRelateDetailItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemRelateDetailItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: wanghaojia
 * @date: 2023/2/7 15:06
 * @description: 活动方案明细导出-按模板配置
 */
@Slf4j
@Component
public class ActivityPlanItemRelateDetailItemExportByTemplateProcess extends MnExportProcess {
    @Autowired(required = false)
    private ActivityPlanItemRelateDetailItemService activityPlanItemService;
    @Autowired(required = false)
    private ActivityPlanItemRelateDetailItemPageCacheHelper pageCacheHelper;

    /**
     * 活动模板服务
     */
    @Autowired(required = false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    protected static final ThreadLocal<ActivitiesTemplateConfigVo> templateConfigVoThreadLocal = new ThreadLocal<>();

    @Override
    public Integer getTotal(Map<String, Object> params) {
        Object cacheKeyObj = params.get("cacheKey");
        Validate.notNull(cacheKeyObj, "缓存键，参数未传入");
        String cacheKey = cacheKeyObj.toString();
        Integer total = pageCacheHelper.getTotal(cacheKey);
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Object cacheKeyObj = params.get("cacheKey");
        Validate.notNull(cacheKeyObj, "缓存键，参数未传入");
        String cacheKey = cacheKeyObj.toString();
        Pageable pageable = PageRequest.of(vo.getPageNo()+1,this.getPageSize());
        ActivityPlanItemRelateDetailItemDto dto = new ActivityPlanItemRelateDetailItemDto();
        Page<ActivityPlanItemRelateDetailItemVo> cachePage = activityPlanItemService.findCachePageList(pageable, dto, cacheKey);
        if (cachePage.getTotal() == 0) {
            return new JSONArray();
        }
        List<ActivityPlanItemRelateDetailItemVo> records = cachePage.getRecords();
        //调整
        adjustData(cacheKey,records);
        return JSON.parseArray(JSON.toJSONString(records, SerializerFeature.WriteDateUseDateFormat));
    }

    @Override
    public String getBusinessCode() {
        return "TPM_ACTIVITY_PLAN_ITEM_RELATE_DETAIL_ITEM_BY_TEMPLATE_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "活动方案明细-关联明细导出-按模板配置";
    }

    /**
     * 调整数据
     */
    private void adjustData(String cacheKey,Collection<ActivityPlanItemRelateDetailItemVo> list) {
        if (CollectionUtils.isEmpty(list)){
            return;
        }
        //数据字典转换
        ActivitiesTemplateConfigVo templateConfigVo = templateConfigVoThreadLocal.get();
        List<ActivitiesTemplateConfigDetailVo> dictFieldList = templateConfigVo.getDetails().stream().filter(item -> StringUtil.isNotEmpty(item.getDictCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dictFieldList)){
            return;
        }
        List<String> dictCodes = dictFieldList.stream().map(ActivitiesTemplateConfigDetailVo::getDictCode).distinct().collect(Collectors.toList());
        Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodes);
        Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue,(o,n)->n)),(o,n)->n));

        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanItemRelateDetailItemVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));

        for (ActivityPlanItemRelateDetailItemVo data : list) {
            data.setActivityType(data.getActivityTypeName());
            data.setActivityForm(data.getActivityFormName());
            for (ActivitiesTemplateConfigDetailVo activitiesTemplateConfigDetailVo : dictFieldList) {
                PropertyDescriptor propertyDescriptor = propertyMap.get(activitiesTemplateConfigDetailVo.getField());
                if (null == propertyDescriptor){
                    continue;
                }
                try {
                    Object originValue = propertyDescriptor.getReadMethod().invoke(data);
                    if (null == originValue){
                        continue;
                    }
                    String originStrValue = originValue.toString();
                    Map<String, String> thisDictMap = dictMapMap.get(activitiesTemplateConfigDetailVo.getDictCode());
                    propertyDescriptor.getWriteMethod().invoke(data,thisDictMap.getOrDefault(originStrValue,originStrValue));
                } catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public List<List<String>> findHead(ExportTaskProcessVo task, Map<String, Object> paramsMap) {
        Object cacheKeyObj = paramsMap.get("cacheKey");
        Validate.notNull(cacheKeyObj, "缓存键，参数未传入");
        String cacheKey = cacheKeyObj.toString();

        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        ActivitiesTemplateConfigVo templateConfigVo = activitiesTemplateSdkService.findByCode(templateCode);
        if (null ==  templateConfigVo){
            throw new RuntimeException("活动模板配置["+templateCode+"]查询失败");
        }
        templateConfigVoThreadLocal.set(templateConfigVo);
        List<List<String>> result = Lists.newArrayList();
        for (ActivitiesTemplateConfigDetailVo detail : templateConfigVo.getDetails()) {
            if (null == detail.getVisible() || !detail.getVisible()){
                continue;
            }
            result.add(Lists.newArrayList(detail.getTitle()));
        }
        return result;
    }

    @Override
    public List<String> findCrmExcelColumnField(ExportTaskProcessVo task, Map<String, Object> paramsMap) {
        Object cacheKeyObj = paramsMap.get("cacheKey");
        Validate.notNull(cacheKeyObj, "缓存键，参数未传入");
        String cacheKey = cacheKeyObj.toString();

        ActivitiesTemplateConfigVo templateConfigVo = templateConfigVoThreadLocal.get();

        List<String> list = Lists.newArrayList();
        for (ActivitiesTemplateConfigDetailVo detail : templateConfigVo.getDetails()) {
            if (null == detail.getVisible() || !detail.getVisible()){
                continue;
            }
            list.add(detail.getField());
        }
        return list;
    }

}
