package com.biz.crm.tpm.business.activity.plan.local.exports.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.plan.local.exports.vo.ActivityPlanItemRelateDetailItemExportsVo;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemRelateDetailItemService;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemRelateDetailItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemRelateDetailItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemRelateDetailItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

/**
 * @Author : dengwei
 * @Date :2023/10/4  10:56
 * @Description: 活动方案关联细案明细
 */
@Slf4j
@Component
public class ActivityPlanItemRelateDetailItemExportsProcess implements ExportProcess<ActivityPlanItemRelateDetailItemExportsVo> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private ActivityPlanItemRelateDetailItemPageCacheHelper pageCacheHelper;

    @Autowired(required = false)
    private ActivityPlanItemRelateDetailItemService activityPlanItemRelateDetailItemService;

    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        Object cacheKeyObj = params.get("cacheKey");
        Validate.notNull(cacheKeyObj, "缓存键，参数未传入");
        String cacheKey = cacheKeyObj.toString();
        Integer total = pageCacheHelper.getTotal(cacheKey);
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        String cacheKey = (String) params.get("cacheKey");
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, this.getPageSize());
        ActivityPlanItemRelateDetailItemDto dto = new ActivityPlanItemRelateDetailItemDto();
        Page<ActivityPlanItemRelateDetailItemVo> cachePage = activityPlanItemRelateDetailItemService.findCachePageList(pageable, dto, cacheKey);
        if (cachePage.getTotal() == 0) {
            return new JSONArray();
        }
        Collection<ActivityPlanItemRelateDetailItemExportsVo> exportsVos = nebulaToolkitService.copyCollectionByWhiteList(
                cachePage.getRecords(), ActivityPlanItemRelateDetailItemVo.class, ActivityPlanItemRelateDetailItemExportsVo.class, LinkedHashSet.class, ArrayList.class);
        //调整
        adjustData(exportsVos);
        return JSON.parseArray(JSON.toJSONString(exportsVos, SerializerFeature.WriteDateUseDateFormat));
    }

    private void adjustData(Collection<ActivityPlanItemRelateDetailItemExportsVo> data) {
        Map<String, String> poMap = dictToolkitService.findMapByDictTypeCode(ActivityPlanConstant.DICT_TPM_PROMOTION_OBJECT);
        Map<String, String> ptMap = dictToolkitService.findMapByDictTypeCode(ActivityPlanConstant.DICT_TPM_ACTIVITY_PLAN_PROMOTION_TYPE);
        Map<String, String> atMap = dictToolkitService.findMapByDictTypeCode(ActivityPlanConstant.DICT_TPM_AUDIT_TYPE);

        for (ActivityPlanItemRelateDetailItemExportsVo vo : data) {
            if (null != vo.getActivityBeginDate()) {
                vo.setActivityBeginDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getActivityBeginDate()));
            }
            if (null != vo.getActivityEndDate()) {
                vo.setActivityEndDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getActivityEndDate()));
            }
            if (null != vo.getOrderBeginDate()) {
                vo.setOrderBeginDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getOrderBeginDate()));
            }
            if (null != vo.getOrderEndDate()) {
                vo.setOrderEndDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getOrderEndDate()));
            }
            if (StringUtils.isNotBlank(vo.getPromotionObject())) {
                vo.setPromotionObject(poMap.getOrDefault(vo.getPromotionObject(), vo.getPromotionObject()));
            }
            if (StringUtils.isNotBlank(vo.getPromotionType())) {
                vo.setPromotionType(ptMap.getOrDefault(vo.getPromotionType(), vo.getPromotionType()));
            }
            if (StringUtils.isNotBlank(vo.getAuditType())) {
                vo.setAuditType(atMap.getOrDefault(vo.getAuditType(), vo.getAuditType()));
            }
        }
    }

    @Override
    public String getBusinessCode() {
        return "activity_plan_item_relate_detail_item_exports";
    }

    @Override
    public String getBusinessName() {
        return "活动方案关联细案明细导出";
    }
}
