package com.biz.crm.tpm.business.activity.plan.local.exports.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: chenlong
 * @date: 2023/2/7 15:07
 * @description: 活动方案明细导出vo
 */
@Data
@CrmExcelExport
public class ActivityPlanItemExportsVo extends CrmExcelVo {

    /**
     * 活动方案明细编码
     */
    @CrmExcelColumn("活动方案明细编码")
    private String planItemCode;

    /**
     * 活动类型编码
     */
    @CrmExcelColumn("活动分类编码")
    private String activityTypeCode;

    /**
     * 活动类型名称
     */
    @CrmExcelColumn("活动分类名称")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @CrmExcelColumn("活动形式名称")
    private String activityFormName;

    /**
     * 活动开始时间
     */
    @ExcelIgnore
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @ExcelIgnore
    private Date activityEndDate;
    /**
     * 活动开始时间-字符串，前端用
     */
    @CrmExcelColumn("活动开始时间")
    private String activityBeginDateStr;

    /**
     * 活动结束时间-字符串，前端用
     */
    @CrmExcelColumn("活动结束时间")
    private String activityEndDateStr;
    /**
     * 订单开始时间
     */
    @ExcelIgnore
    private Date orderBeginDate;
    /**
     * 订单结束时间
     */
    @ExcelIgnore
    private Date orderEndDate;
    /**
     * 订单开始时间-字符串，前端用
     */
    @CrmExcelColumn("订单开始时间")
    private String orderBeginDateStr;
    /**
     * 订单结束时间-字符串，前端用
     */
    @CrmExcelColumn("订单结束时间")
    private String orderEndDateStr;

    /**
     * 总部预算编码
     */
    @CrmExcelColumn("总部统筹预算编码")
    private String headMonthBudgetCode;

    /**
     * 总部预算项目编码
     */
    @CrmExcelColumn("总部预算项目编码")
    private String headBudgetItemCode;

    /**
     * 总部预算项目名称
     */
    @CrmExcelColumn("总部预算项目名称")
    private String headBudgetItemName;
    /**
     * 大区预算编码
     */
    @CrmExcelColumn("大区自控预算编码")
    private String monthBudgetCode;

    /**
     * 大区预算项目编码
     */
    @CrmExcelColumn("大区预算项目编码")
    private String budgetItemCode;

    /**
     * 大区预算项目名称
     */
    @CrmExcelColumn("大区预算项目名称")
    private String budgetItemName;

    /**
     * 一级管理渠道
     */
    @CrmExcelColumn("一级管理渠道编码")
    private String firstChannelCode;
    /**
     * 一级管理渠道
     */
    @CrmExcelColumn("一级管理渠道")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @CrmExcelColumn("二级管理渠道编码")
    private String secondChannelCode;
    /**
     * 二级管理渠道
     */
    @CrmExcelColumn("二级管理渠道")
    private String secondChannelName;

    /**
     * 区域编码
     */
//    @ExcelIgnore
    @CrmExcelColumn("区域编码")
    private String activityOrgCode;

    /**
     * 区域名称
     */
    @CrmExcelColumn("区域名称")
    private String activityOrgName;

    /**
     * 促销对象
     */
    @CrmExcelColumn("促销对象")
    private String promotionObject;
    /**
     * 促销类型
     */
    @CrmExcelColumn("促销类型")
    private String promotionType;
    /**
     * 品牌编码
     */
    @CrmExcelColumn("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @CrmExcelColumn("品牌名称")
    private String productBrandName;
    /**
     * 品类编码
     */
    @CrmExcelColumn("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @CrmExcelColumn("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @CrmExcelColumn("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @CrmExcelColumn("品项名称")
    private String productItemName;

    /**
     * 产品编码
     */
    @CrmExcelColumn("产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String productName;
    /**
     * 产品单位
     */
    @CrmExcelColumn("产品单位")
    private String productUnit;
    /**
     * 产品数量
     */
    @CrmExcelColumn("产品数量")
    private Integer productQuantity;
    /**
     * 供应商编码
     */
    @CrmExcelColumn("供应商编码")
    private String supplierCode;
    /**
     * 供应商名称
     */
    @CrmExcelColumn("供应商名称")
    private String supplierName;

    /**
     * 物料编码
     */
    @CrmExcelColumn("物料编码")
    private String materialCode;
    /**
     * 物料名称
     */
    @CrmExcelColumn("物料名称")
    private String materialName;
    /**
     * 单价
     */
    @CrmExcelColumn("单价")
    private BigDecimal price;

    /**
     * 费用总金额（元）
     */
    @CrmExcelColumn("费用总金额（元）")
    private BigDecimal totalFeeAmount;

    /**
     * 总部承担金额
     */
    @CrmExcelColumn("总部承担金额")
    private BigDecimal headFeeAmount;
    /**
     * 大区承担金额
     */
    @CrmExcelColumn("大区承担金额")
    private BigDecimal departmentFeeAmount;
    /**
     * 客户承担金额
     */
    @CrmExcelColumn("客户承担金额")
    private BigDecimal customerFeeAmount;

    /**
     * 预估销售额
     */
    @CrmExcelColumn("预估销售额")
    private BigDecimal salesAmount;

    /**
     * 核销类型
     */
    @CrmExcelColumn("核销类型")
    private String auditType;

    /**
     * 核销条件编码
     */
    @CrmExcelColumn("核销条件编码")
    private String auditConditionCode;

    /**
     * 核销条件名称
     */
    @CrmExcelColumn("核销条件名称")
    private String auditConditionName;
}
