package com.biz.crm.tpm.business.activity.plan.local.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author : dengwei
 * @Date :2023/10/4  10:57
 * @Description: TODO
 */
@Data
@CrmExcelExport
public class ActivityPlanItemRelateDetailItemExportsVo extends CrmExcelVo {

    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    @CrmExcelColumn("方案模板编码")
    private String templateConfigCode;

    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    @CrmExcelColumn("活动方案编码")
    private String planCode;

    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    @CrmExcelColumn("活动方案明细编码")
    private String planItemCode;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @CrmExcelColumn("活动类型编码")
    private String activityTypeCode;
    /**
     * 活动类型
     */
    @ApiModelProperty("活动类型")
    @CrmExcelColumn("活动类型")
    private String activityType;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @CrmExcelColumn("活动类型名称")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式
     */
    @ApiModelProperty("活动形式")
    @CrmExcelColumn("活动形式")
    private String activityForm;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn("活动形式名称")
    private String activityFormName;
    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    @CrmExcelColumn("所属销售机构")
    private String salesInstitutionName;
    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @CrmExcelColumn("所属销售机构编码")
    private String salesInstitutionCode;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @CrmExcelColumn("所属销售机构编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty("所属销售大区编码")
    @CrmExcelColumn("所属销售大区编码")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    @CrmExcelColumn("所属销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    @CrmExcelColumn("所属销售大区编码")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    @CrmExcelColumn("所属销售组织(组)编码")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)编码")
    @CrmExcelColumn("所属销售组织(组)编码")
    private String salesOrgCode;


    @ApiModelProperty("所属销售组织(组)名称")
    @CrmExcelColumn("所属销售组织(组)名称")
    private String salesOrgName;

    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginDate;

    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @CrmExcelColumn("活动开始时间")
    private String activityBeginDateStr;

    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndDate;

    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @CrmExcelColumn("活动结束时间")
    private String activityEndDateStr;

    /**
     * 订单开始时间
     */
    @ApiModelProperty("订单开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date orderBeginDate;


    /**
     * 订单开始时间
     */
    @ApiModelProperty("订单开始时间")
    @CrmExcelColumn("订单开始时间")
    private String orderBeginDateStr;

    /**
     * 订单结束时间
     */
    @ApiModelProperty("订单结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date orderEndDate;

    /**
     * 订单结束时间
     */
    @ApiModelProperty("订单结束时间")
    @CrmExcelColumn("订单结束时间")
    private String orderEndDateStr;
    /**
     * 总部预算编码
     */
    @ApiModelProperty("总部预算编码")
    @CrmExcelColumn("总部预算编码")
    private String headMonthBudgetCode;

    /**
     * 总部预算项目编码
     */
    @ApiModelProperty("总部预算项目编码")
    @CrmExcelColumn("总部预算项目编码")
    private String headBudgetItemCode;

    /**
     * 总部预算项目名称
     */
    @ApiModelProperty("总部预算项目名称")
    @CrmExcelColumn("总部预算项目名称")
    private String headBudgetItemName;

    /**
     * 大区预算编码
     */
    @ApiModelProperty("预算编码/大区预算编码")
    @CrmExcelColumn("预算编码/大区预算编码")
    private String monthBudgetCode;
    /**
     * 大区预算项目编码
     */
    @ApiModelProperty("大区预算项目编码")
    @CrmExcelColumn("大区预算项目编码")
    private String budgetItemCode;
    /**
     * 大区预算项目名称
     */
    @ApiModelProperty("大区预算项目名称")
    @CrmExcelColumn("大区预算项目名称")
    private String budgetItemName;

    @ApiModelProperty(value = "* 随车搭赠组合")
    @CrmExcelColumn("随车搭赠组合")
    private String carGiftGroup;
    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    @CrmExcelColumn("区域编码")
    private String activityOrgCode;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    @CrmExcelColumn("区域名称")
    private String activityOrgName;
    /**
     * 一级管理渠道编码
     */
    @ApiModelProperty("一级管理渠道编码")
    @CrmExcelColumn("一级管理渠道编码")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    @CrmExcelColumn("一级管理渠道名称")
    private String firstChannelName;
    /**
     * 二级管理渠道编码
     */
    @ApiModelProperty("二级管理渠道编码")
    @CrmExcelColumn("二级管理渠道编码")
    private String secondChannelCode;
    /**
     * 二级管理渠道名称
     */
    @ApiModelProperty("二级管理渠道名称")
    @CrmExcelColumn("二级管理渠道名称")
    private String secondChannelName;

    @ApiModelProperty("分销渠道编码")
    @CrmExcelColumn("分销渠道编码")
    private String distributionChannelCode;

    @ApiModelProperty("分销渠道名称")
    @CrmExcelColumn("分销渠道名称")
    private String distributionChannelName;

    @CrmExcelColumn(value = "客户组编码")
    private String customerGroupCode;

    @CrmExcelColumn(value = "客户组名称")
    private String customerGroupName;
    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @CrmExcelColumn("客户编码")
    private String customerCode;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户ERP编码")
    @CrmExcelColumn("客户ERP编码")
    private String customerErpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 促销对象
     */
    @ApiModelProperty("促销对象")
    @CrmExcelColumn("促销对象")
    private String promotionObject;

    /**
     * 促销类型
     */
    @ApiModelProperty("促销类型")
    @CrmExcelColumn("促销类型")
    private String promotionType;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @CrmExcelColumn("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @CrmExcelColumn("品牌名称")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    @CrmExcelColumn("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @CrmExcelColumn("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @CrmExcelColumn("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @CrmExcelColumn("品项名称")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @CrmExcelColumn("产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @CrmExcelColumn("产品名称")
    private String productName;

    /**
     * 单位编码
     */
    @ApiModelProperty("单位编码")
    @CrmExcelColumn("单位编码")
    private String productUnit;

    /**
     * 产品价格
     */
    @ApiModelProperty("产品价格")
    private BigDecimal productPrice;
    /**
     * 产品价格
     */
    @ApiModelProperty("产品价格")
    @CrmExcelColumn("产品价格")
    private String productPriceStr;

    /**
     * 赠品编码
     */
    @ApiModelProperty("赠品编码")
    @CrmExcelColumn("赠品编码")
    private String giftCode;
    /**
     * 赠品名称
     */
    @ApiModelProperty("赠品名称")
    @CrmExcelColumn("赠品名称")
    private String giftName;

    /**
     * 原品数量
     */
    @ApiModelProperty("原品数量")
    private Integer productQuantity;

    /**
     * 原品数量
     */
    @ApiModelProperty("原品数量")
    @CrmExcelColumn("原品数量")
    private String productQuantityStr;

    /**
     * 赠品数量
     */
    @ApiModelProperty("赠品数量")
    private Integer giftQuantity;
    /**
     * 赠品数量
     */
    @ApiModelProperty("赠品数量")
    @CrmExcelColumn("赠品数量")
    private String giftQuantityStr;

    /**
     * 活动描述
     */
    @ApiModelProperty("活动描述")
    @CrmExcelColumn("活动描述")
    private String activityDesc;

    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    private BigDecimal totalFeeAmount;
    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    @CrmExcelColumn("费用合计")
    private String totalFeeAmountStr;

    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    private BigDecimal headFeeAmount;

    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    @CrmExcelColumn("总部承担金额")
    private String headFeeAmountStr;

    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    private BigDecimal departmentFeeAmount;
    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    @CrmExcelColumn("大区承担金额")
    private String departmentFeeAmountStr;
    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    private BigDecimal customerFeeAmount;

    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    @CrmExcelColumn("客户承担金额")
    private String customerFeeAmountStr;

    /**
     * 预估销售额
     */
    @ApiModelProperty("预估销售额")
    private BigDecimal salesAmount;

    /**
     * 预估销售额
     */
    @ApiModelProperty("预估销售额")
    @CrmExcelColumn("预估销售额")
    private String salesAmountStr;
    /**
     * 预估费率
     */
    @ApiModelProperty("预估费率")
    private BigDecimal feeRate;

    /**
     * 预估费率
     */
    @ApiModelProperty("预估费率")
    @CrmExcelColumn("预估费率")
    private BigDecimal feeRateStr;

    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    @CrmExcelColumn("核销条件编码")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    @CrmExcelColumn("核销条件名称")
    private String auditConditionName;

    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    @CrmExcelColumn("核销类型")
    private String auditType;

    /**
     * 赠品单位
     */
    @ApiModelProperty("赠品单位")
    @CrmExcelColumn("赠品单位")
    private String giftUnit;
}
