package com.biz.crm.tpm.business.activity.plan.local.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author xiaoyoujun
 * @date
 */
@Data
@ApiModel(value = "StoreDetailsExportVo", description = "活动方案门店明细导出VO")
@CrmExcelExport
public class StoreDetailsExportVo extends CrmExcelVo {

    @CrmExcelColumn("门店编码")
    private String terminalCode;
    @CrmExcelColumn("门店名称")
    private String terminalName;
    @CrmExcelColumn("标准")
    private BigDecimal standard;
    @CrmExcelColumn("数量")
    private BigDecimal quantity;
    @CrmExcelColumn("员工")
    private String employeeCode;
    @CrmExcelColumn("费用合计")
    private BigDecimal amount;

    @CrmExcelColumn("我方承担金额")
    private BigDecimal feeAmount;

    @CrmExcelColumn("系统承担金额")
    private BigDecimal systemBorneAmount;

    @CrmExcelColumn("浮动利率")
    private BigDecimal floatingRate;




}
