package com.biz.crm.tpm.business.activity.plan.local.imports;

import com.alibaba.fastjson.JSON;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.plan.local.imports.vo.ActivityPlanItemDY00000008CarItemImportVo;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 随车搭赠（主体_大区方案）导入服务
 * @author wanghaojia
 * @date 2022/11/11 16:19
 */
@Slf4j
@Component
public class ActivityPlanCarGiftDY00000008RegionImportsProcess implements ImportProcess<ActivityPlanItemDY00000008CarItemImportVo> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityPlanItemPageCacheHelper activityPlanItemPageCacheHelper;

    @Autowired(required = false)
    private ActivityTypeService activityTypeService;
    @Autowired(required = false)
    private ActivityFormService activityFormService;
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private ProductBrandService productBrandService;
    @Autowired(required = false)
    private ProductVoService productVoService;
    @Autowired(required = false)
    private ProductLevelVoSdkService productLevelVoSdkService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;
    @Autowired(required = false)
    private AuditFormulaMainService auditFormulaMainService;
    @Autowired(required = false)
    private CustomerVoService customerVoService;
    @Autowired(required = false)
    private CustomerChannelVoService customerChannelVoService;

    private static String tpm_audit_type = "tpm_audit_type";
    private static String promotion_type = "tpm_activity_plan_promotion_type";

    @Override
    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, ActivityPlanItemDY00000008CarItemImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
//        5、随车搭赠（大区方案）：活动分类编码、活动形式编码、总部统筹预算编码、大区自控预算编码、大区编码、省区编码、品牌编码、品类编码、品项编码、产品编码（目前带出的产品名称、产品单位）、赠品编码（带出赠品名称、赠品单位）
        Map<Integer, String> errorMap = Maps.newHashMap();
        Map<Integer, List<String>> errorListMap = Maps.newHashMap();
        try {

            Object businessFormatCodeObj = params.get("businessFormatCode");
            if (null == businessFormatCodeObj){
                throw new RuntimeException("业态有误！");
            }
            String businessFormatCode = String.valueOf(businessFormatCodeObj);


            List<ActivityPlanItemDY00000008CarItemImportVo> importVos = Lists.newArrayList(data.values());

            List<String> dictCodeList = Lists.newArrayList();
            dictCodeList.add(tpm_audit_type);
            dictCodeList.add(promotion_type);
            dictCodeList.add(ActivityPlanConstant.carGiftGroup);

            Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodeList);
             Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode,(o,n)->n)),(o,n)->n));

            List<String> carGiftGroupList = dictMap.get(ActivityPlanConstant.carGiftGroup).stream().map(DictDataVo::getDictCode).collect(Collectors.toList());

            Set<String> orgCodeSet = Sets.newHashSet();
            Set<String> activityTypeCodeSet = Sets.newHashSet();
            Set<String> activityFormCodeSet = Sets.newHashSet();
            Set<String> monthBudgetCodeSet = Sets.newHashSet();
            Set<String> terminalChannelSet = Sets.newHashSet();
            Set<String> productBrandCodeSet = Sets.newHashSet();
            Set<String> productLevelCodeSet = Sets.newHashSet();
            Set<String> productCodeSet = Sets.newHashSet();
            Set<String> salesOrgCodeSet = Sets.newHashSet();
            Set<String> auditFormulaCodeSet = Sets.newHashSet();
            Set<String> customerCodeSet = Sets.newHashSet();
            Set<String> cusChannelCodeSet = Sets.newHashSet();
            
            int key = 0;
            for (ActivityPlanItemDY00000008CarItemImportVo importVo : importVos) {
                List<String> errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());

                if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())){
                    List<String> typeCodes = Arrays.asList(importVo.getActivityTypeCode().split(","));
                    activityTypeCodeSet.addAll(typeCodes);
                }
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())){
                    List<String> formCodes = Arrays.asList(importVo.getActivityFormCode().split(","));
                    activityFormCodeSet.addAll(formCodes);
                }
                if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())){
                    monthBudgetCodeSet.add(importVo.getHeadMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty(importVo.getMonthBudgetCode())){
                    monthBudgetCodeSet.add(importVo.getMonthBudgetCode());
                }
                if(StringUtils.isNotBlank(importVo.getDistributionChannelCode())){
                    cusChannelCodeSet.add(importVo.getDistributionChannelCode());
                }
                
                if (StringUtils.isNotEmpty(importVo.getSalesInstitutionCode())) {
                    if (StringUtils.isEmpty(importVo.getDistributionChannelCode())) {
                        errorList.add("渠道编码不能为空");
                    }else{
                        String insCode = importVo.getDistributionChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode();
                        salesOrgCodeSet.add(insCode);
                        if (StringUtils.isNotBlank(importVo.getSalesRegionCode())) {
                            String regionCode = insCode + importVo.getSalesRegionCode();
                            salesOrgCodeSet.add(regionCode);
                            if (StringUtils.isNotBlank(importVo.getSalesOrgCode())) {
                                String salesOrgcode = regionCode + importVo.getSalesOrgCode();
                                salesOrgCodeSet.add(salesOrgcode);
                            }
                        }
                    }
                }
                if (StringUtils.isNotBlank(importVo.getCustomerCode())) {
                    boolean customerValidate = true;
                    if (StringUtils.isEmpty(importVo.getDistributionChannelCode())){
                        customerValidate = false;
                        errorList.add("渠道编码不能为空");
                    }
                    if (StringUtils.isEmpty(importVo.getSalesInstitutionCode())){
                        customerValidate = false;
                        errorList.add("销售机构编码不能为空");
                    }
                    if (customerValidate){
                        customerCodeSet.add(importVo.getCustomerCode() + importVo.getSalesInstitutionCode() + importVo.getDistributionChannelCode() + businessFormatCode);
                    }
                }
//                if (StringUtils.isNotEmpty(importVo.getFirstChannelCode())){
//                    terminalChannelSet.add(importVo.getFirstChannelCode());
//                }
//                if (StringUtils.isNotEmpty(importVo.getSecondChannelCode())){
//                    terminalChannelSet.add(importVo.getSecondChannelCode());
//                }
                if (StringUtils.isNotEmpty(importVo.getProductBrandCode())){
                    productBrandCodeSet.add(importVo.getProductBrandCode());
                }
                if (StringUtils.isNotEmpty(importVo.getProductItemCode())){
                    productLevelCodeSet.add(importVo.getProductItemCode());
                }
                if (StringUtils.isNotEmpty(importVo.getProductCategoryCode())){
                    productLevelCodeSet.add(importVo.getProductCategoryCode());
                }
                if (StringUtils.isNotEmpty(importVo.getProductCode())){
                    productCodeSet.add(importVo.getProductCode());
                }
                if (StringUtils.isNotEmpty(importVo.getGiftCode())){
                    productCodeSet.add(importVo.getGiftCode());
                }
//                if (StringUtils.isNotEmpty(importVo.getMaterialCode())){
//                    materialCodeSet.add(importVo.getMaterialCode());
//                }
//                if (StringUtils.isNotEmpty(importVo.getSupplierCode())){
//                    supplierCodeSet.add(importVo.getSupplierCode());
//                }
                if (StringUtils.isNotEmpty(importVo.getAuditConditionCode())){
                    auditFormulaCodeSet.add(importVo.getAuditConditionCode());
                }
            }

            Map<String,SalesOrgVo> salesOrgMap = Maps.newHashMap();
            Map<String,String> customerMap = Maps.newHashMap();
            Map<String, CustomerChannelVo> cusChannelMap = Maps.newHashMap();
            Map<String,String> activityTypeMap = Maps.newHashMap();
            Map<String,String> activityFormMap = Maps.newHashMap();
            Map<String, MonthBudgetVo> monthBudgetMap = Maps.newHashMap();
            Map<String,String> terminalChannelMap = Maps.newHashMap();
            Map<String,String> productBrandMap = Maps.newHashMap();
            Map<String,String> productLevelMap = Maps.newHashMap();
            Map<String, ProductVo> productMap = Maps.newHashMap();
            Map<String, AuditFormulaMainVo> auditFormulaMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(activityTypeCodeSet)){
                List<ActivityTypeVo> activityTypeList = activityTypeService.findByCodes(Lists.newArrayList(activityTypeCodeSet));
                activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode,ActivityTypeVo::getActivityTypeName,(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(activityFormCodeSet)){
                List<String> activityFormCodeList = Lists.newArrayList(activityFormCodeSet);
                List<List<String>> activityFormCodeListBag = Lists.newArrayList();
                activityFormCodeListBag.add(activityFormCodeList);
                activityFormMap = activityFormService.findFormByCodes(activityFormCodeListBag);
            }
            if (!CollectionUtils.isEmpty(monthBudgetCodeSet)){
                List<MonthBudgetVo> monthBudgetVos = monthBudgetService.listByCodes(Lists.newArrayList(monthBudgetCodeSet));
                monthBudgetMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity(),(o,n)->n));
            }

            if (!CollectionUtils.isEmpty(cusChannelCodeSet)) {
                List<CustomerChannelVo> channelVos = customerChannelVoService.findByCodes(new ArrayList<>(cusChannelCodeSet));
                if (!CollectionUtils.isEmpty(channelVos)) {
                    cusChannelMap = channelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity(), (o, n) -> n));
                }
            }

            if (!CollectionUtils.isEmpty(salesOrgCodeSet)){
                List<SalesOrgVo> salesOrgVos = salesOrgVoService.findBySalesOrgCodes(Lists.newArrayList(salesOrgCodeSet));
                if (!CollectionUtils.isEmpty(salesOrgVos)){
                    salesOrgMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(),(o,n)->n));
                }
            }
            if (!CollectionUtils.isEmpty(customerCodeSet)) {
                List<List<String>> cusList = Lists.partition(new ArrayList<>(customerCodeSet), 500);
                customerMap = customerVoService.getCusNameByCodes(cusList);
            }
            if (!CollectionUtils.isEmpty(productBrandCodeSet)){
                List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(Lists.newArrayList(productBrandCodeSet));
                productBrandMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode,ProductBrandVo::getProductBrandName,(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(productLevelCodeSet)){
                List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByBusinessFormatAndCodes(businessFormatCode,Lists.newArrayList(productLevelCodeSet));
                productLevelMap = productLevelVos.stream().collect(Collectors.toMap(item -> {
                    return item.getProductLevelType() + item.getProductLevelCode();
                },ProductLevelVo::getProductLevelName,(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(productCodeSet)){
                List<ProductVo> productVos = productVoService.findByCodes(Lists.newArrayList(productCodeSet));
                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode,Function.identity(),(o,n)->n));
            }
//            if (!CollectionUtils.isEmpty(materialCodeSet)){
//                List<ProductVo> productVos = materialVoService.findDetailByMaterialCodes(materialCodeSet);
//                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode,Function.identity()));
//            }
//            if (!CollectionUtils.isEmpty(supplierCodeSet)){
//                List<ProductVo> productVos = supplierVoService.findByConditions(Lists.newArrayList(supplierCodeSet));
//                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode,Function.identity()));
//            }
            if(!CollectionUtils.isEmpty(auditFormulaCodeSet)){
                List<AuditFormulaMainVo> auditFormulaList = auditFormulaMainService.findByCodeList(Lists.newArrayList(auditFormulaCodeSet));
                if (!CollectionUtils.isEmpty(auditFormulaList)){
                    auditFormulaMap = auditFormulaList.stream().collect(Collectors.toMap(AuditFormulaMainVo::getAuditFormulaCode, Function.identity()));
                }
            }

            List<ActivityPlanItemDto> newList = Lists.newArrayList();
            key = 0;
            for (ActivityPlanItemDY00000008CarItemImportVo importVo : importVos) {
                List<String> errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());

                ActivityPlanItemDto itemDto = nebulaToolkitService.copyObjectByWhiteList(importVo, ActivityPlanItemDto.class, HashSet.class, ArrayList.class);

                if (StringUtils.isNotEmpty(importVo.getActivityBeginDateStr())){
                    validateDateFormat(importVo.getActivityBeginDateStr(), "活动开始时间格式错误！",errorList);
                }
                if (StringUtils.isNotEmpty(importVo.getActivityEndDateStr())){
                    validateDateFormat(importVo.getActivityEndDateStr(), "活动结束时间格式错误！",errorList);
                }
                if (StringUtils.isNotEmpty(importVo.getOrderBeginDateStr())){
                    validateDateFormat(importVo.getOrderBeginDateStr(), "订单开始时间格式错误！",errorList);
                }
                if (StringUtils.isNotEmpty(importVo.getOrderEndDateStr())){
                    validateDateFormat(importVo.getOrderEndDateStr(), "订单结束时间格式错误！",errorList);
                }

                validateAndConvertDictData(dictMapMap,tpm_audit_type,importVo.getAuditType(),itemDto::setAuditType,"核销类型",errorList);
                validateAndConvertDictData(dictMapMap,promotion_type,importVo.getPromotionType(),itemDto::setPromotionType,"促销类型",errorList);
                if (StringUtils.isNotEmpty(importVo.getCarGiftGroup())){
                    if (!carGiftGroupList.contains(importVo.getCarGiftGroup())){
                        errorList.add("随车搭赠组合["+importVo.getCarGiftGroup()+"]有误");
                    }
                }

                //活动分类
                activityType:if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                    String[] codes = importVo.getActivityTypeCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String activityTypeName = activityTypeMap.get(code);
                        if (StringUtils.isEmpty(activityTypeName)) {
                            errorList.add("活动分类[" + code + "]有误");
                            break activityType;
                        } else {
                            allNames.add(activityTypeName);
                        }
                    }
                    itemDto.setActivityTypeName(String.join(",", allNames));
                }

                //活动形式
                activityForm:if (StringUtils.isNotEmpty(importVo.getActivityFormCode())){
                    String[] codes = importVo.getActivityFormCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String activityFormName = activityFormMap.get(code);
                        if (StringUtils.isEmpty(activityFormName)) {
                            errorList.add("活动形式[" + code + "]有误");
                            break activityForm;
                        } else {
                            allNames.add(activityFormName);
                        }
                    }
                    itemDto.setActivityForm(importVo.getActivityFormCode());
                    itemDto.setActivityFormName(String.join(",", allNames));
                }
                //分销渠道
                channel:if (StringUtils.isNotEmpty(importVo.getDistributionChannelCode())) {
                    CustomerChannelVo channelVo = cusChannelMap.get(importVo.getDistributionChannelCode());
                    if (null == channelVo) {
                        errorList.add("渠道编码[" + importVo.getDistributionChannelCode() + "]有误");
                        break channel;
                    }
                    itemDto.setDistributionChannelCode(channelVo.getCustomerChannelCode());
                    itemDto.setDistributionChannelName(channelVo.getCustomerChannelName());
                }

                //销售组织
                salesInstitution:if (StringUtils.isNotEmpty(importVo.getSalesInstitutionCode())) {
                    String insCode = importVo.getDistributionChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode();
                    SalesOrgVo salesOrgVo = salesOrgMap.get(insCode);
                    if (null == salesOrgVo) {
                        errorList.add("销售机构编码[" + importVo.getSalesInstitutionCode() + "]有误");
                        break salesInstitution;
                    }
                    itemDto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                    itemDto.setSalesInstitutionErpCode(salesOrgVo.getErpCode());
                    itemDto.setSalesInstitutionCode(salesOrgVo.getSalesOrgCode());
                    itemDto.setActivityOrgCode(itemDto.getSalesInstitutionCode());
                    itemDto.setActivityOrgName(itemDto.getSalesInstitutionName());
                    itemDto.setActivityOrgErpCode(itemDto.getSalesInstitutionErpCode());
                    //销售部门
                    salesRegion:if (StringUtils.isNotEmpty(importVo.getSalesRegionCode())) {
                        String regionCode = insCode + importVo.getSalesRegionCode();
                        SalesOrgVo salesOrgVo2 = salesOrgMap.get(regionCode);
                        if (null == salesOrgVo2) {
                            errorList.add("大区编码[" + importVo.getSalesRegionCode() + "]有误");
                            break salesRegion;
                        }
                        itemDto.setSalesRegionErpCode(salesOrgVo2.getErpCode());
                        itemDto.setSalesRegionCode(salesOrgVo2.getSalesOrgCode());
                        itemDto.setSalesRegionName(salesOrgVo2.getSalesOrgName());
                        itemDto.setActivityOrgCode(itemDto.getSalesRegionCode());
                        itemDto.setActivityOrgName(itemDto.getSalesRegionName());
                        itemDto.setActivityOrgErpCode(itemDto.getSalesRegionErpCode());
                        //销售组
                        salesOrg:if (StringUtils.isNotEmpty(importVo.getSalesOrgCode())) {
                            String salesOrgCode = insCode + importVo.getSalesRegionCode() + importVo.getSalesOrgCode();
                            SalesOrgVo salesOrgVo3 = salesOrgMap.get(salesOrgCode);
                            if (null == salesOrgVo3) {
                                errorList.add("省区编码[" + importVo.getSalesOrgCode() + "]有误");
                                break salesOrg;
                            }
                            itemDto.setSalesOrgErpCode(salesOrgVo3.getErpCode());
                            itemDto.setSalesOrgName(salesOrgVo3.getSalesOrgName());
                            itemDto.setSalesOrgCode(salesOrgVo3.getSalesOrgCode());
                            itemDto.setActivityOrgCode(itemDto.getSalesOrgCode());
                            itemDto.setActivityOrgName(itemDto.getSalesOrgName());
                            itemDto.setActivityOrgErpCode(itemDto.getSalesOrgErpCode());
                        }
                    }
                }
                customer:if (StringUtils.isNotBlank(importVo.getCustomerCode())) {
                    String customer = importVo.getCustomerCode() + importVo.getSalesInstitutionCode() + importVo.getDistributionChannelCode() + businessFormatCode;
                    if (!customerMap.containsKey(customer)) {
                        errorList.add("客户编码[" + importVo.getCustomerCode() + "]有误");
                        break customer;
                    }
                    itemDto.setCustomerCode(customer);
                    itemDto.setCustomerErpCode(importVo.getCustomerCode());
                    itemDto.setCustomerName(customerMap.get(customer));
                }

                //品牌
                productBrand:if (StringUtils.isNotEmpty(importVo.getProductBrandCode())){
                    String brandName = productBrandMap.get(importVo.getProductBrandCode());
                    if (StringUtils.isEmpty(brandName)){
                        errorList.add("品牌["+importVo.getProductBrandCode()+"]有误");
                        break productBrand;
                    }
                    itemDto.setProductBrandName(brandName);
                }

                //品类
                productCategory:if (StringUtils.isNotEmpty(importVo.getProductCategoryCode())){
                    String productLevelName = productLevelMap.get(ProductLevelEnum.category.getCode() + importVo.getProductCategoryCode());
                    if (StringUtils.isEmpty(productLevelName)){
                        errorList.add("品类["+importVo.getProductCategoryCode()+"]有误");
                        break productCategory;
                    }
                    itemDto.setProductCategoryName(productLevelName);
                }

                //品项
                productItem:if (StringUtils.isNotEmpty(importVo.getProductItemCode())){
                    String productLevelName = productLevelMap.get(ProductLevelEnum.items.getCode() + importVo.getProductItemCode());
                    if (StringUtils.isEmpty(productLevelName)){
                        errorList.add("品项["+importVo.getProductItemCode()+"]有误");
                        break productItem;
                    }
                    itemDto.setProductItemName(productLevelName);
                }

                //产品
                product:if (StringUtils.isNotEmpty(importVo.getProductCode())){
                    ProductVo productVo = productMap.get(importVo.getProductCode());
                    if(null == productVo){
                        errorList.add("产品编码["+importVo.getProductCode()+"]有误");
                        break product;
                    }
                    itemDto.setProductName(productVo.getProductName());
                    if (StringUtils.isEmpty(importVo.getProductUnit())){
                        itemDto.setProductUnit(productVo.getBaseUnit());
                    }
                }
                //赠品编码
                gift:if (StringUtils.isNotEmpty(importVo.getGiftCode())){
                    ProductVo productVo = productMap.get(importVo.getGiftCode());
                    if(null == productVo){
                        errorList.add("赠品编码["+importVo.getGiftCode()+"]有误");
                        break gift;
                    }
                    itemDto.setGiftName(productVo.getProductName());
                    if (StringUtils.isEmpty(importVo.getGiftUnit())){
                        itemDto.setGiftUnit(productVo.getBaseUnit());
                    }
                }


                headBudget:if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())){
                    MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getHeadMonthBudgetCode());
                    if (null == monthBudgetVo){
                        errorList.add("总部费用预算编码"+importVo.getHeadMonthBudgetCode()+"有误");
                        break headBudget;
                    }
                    itemDto.setHeadBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    itemDto.setHeadBudgetItemName(monthBudgetVo.getBudgetItemName());
                }

                monthBudget:if (StringUtils.isNotEmpty(importVo.getMonthBudgetCode())){
                    MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getMonthBudgetCode());
                    if (null == monthBudgetVo){
                        errorList.add("大区自控预算编码"+importVo.getMonthBudgetCode()+"有误");
                        break monthBudget;
                    }
                    itemDto.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    itemDto.setBudgetItemName(monthBudgetVo.getBudgetItemName());
                }

                auditType:if (StringUtils.isNotEmpty(itemDto.getAuditType())) {
                    if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(itemDto.getAuditType())) {
                        if (StringUtils.isEmpty(itemDto.getAuditConditionCode())){
                            errorList.add( "核销条件编码必填！");
                            break auditType;
                        }
                        AuditFormulaMainVo auditFormula = auditFormulaMap.get(itemDto.getAuditConditionCode());
                        if (auditFormula == null){
                            errorList.add("核销条件["+importVo.getAuditConditionCode()+"]有误");
                            break auditType;
                        }
                        itemDto.setAuditConditionName(auditFormula.getAuditFormulaName());
                    }
                }

                newList.add(itemDto);
            }

            if (errorListMap.size() > 0) {
                for (Map.Entry<Integer, List<String>> entry : errorListMap.entrySet()) {
                    List<String> value = entry.getValue();
                    if (value.size() > 0) {
                        errorMap.put(entry.getKey(), String.join(" | ", value));
                    }
                }
            }

            if (errorMap.size() == 0 && !CollectionUtils.isEmpty(newList)){
                activityPlanItemPageCacheHelper.importNewItem(String.valueOf(params.get("cacheKey")), newList);
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty(e.getMessage())){
                errorMsg = "数据处理失败！";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return errorMap;
    }

    /**
     * 时间格式判断
     *
     * @param currentTime
     * @return
     */
    private void validateDateFormat(String currentTime,String errorMsg,List<String> errorList) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        boolean flag = true;
        try {
            dtf.parse(currentTime);
        } catch (Exception e) {
            errorList.add(errorMsg);
        }
    }

    public void validateAndConvertDictData(Map<String, Map<String,String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc, List<String> errorList){
        try {
            validateAndConvertDictData(dictMap,dictTypeCode,dictValue,setMethod,desc);
        }catch (RuntimeException e){
            errorList.add(e.getMessage());
        }
    }

    public void validateAndConvertDictData(Map<String, Map<String,String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc){
        if (StringUtils.isEmpty(dictValue)){
            return;
        }
        Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
        String dictCode = dictDataMap.get(dictValue);
        if (StringUtils.isEmpty(dictCode)){
            throw new RuntimeException(desc+"["+dictValue+"]有误");
        }
        setMethod.accept(dictCode);
    }

    @Override
    public Class<ActivityPlanItemDY00000008CarItemImportVo> findCrmExcelVoClass() {
        return ActivityPlanItemDY00000008CarItemImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_ACTIVITY_PLAN_IMPORT_CAR_GIFT_DY00000008_REGION";
    }

    @Override
    public String getTemplateName() {
        return "随车搭赠（主体_大区方案）";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_ACTIVITY_PLAN_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-活动方案明细导入";
    }

}
