package com.biz.crm.tpm.business.activity.plan.local.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgRangeDto;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.plan.local.imports.vo.ActivityPlanItemDY00000008RegionImportVo;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动方案导入模板（主体-大区）-通用
 * @author wanghaojia
 * @date 2022/11/11 16:19
 */
@Slf4j
@Component
public class ActivityPlanDY00000008RegionImportsProcess implements ImportProcess<ActivityPlanItemDY00000008RegionImportVo> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityPlanItemPageCacheHelper activityPlanItemPageCacheHelper;

    @Autowired(required = false)
    private ActivityTypeService activityTypeService;
    @Autowired(required = false)
    private ActivityFormService activityFormService;
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private MdmTerminalChannelVoService terminalChannelVoService;
    @Autowired(required = false)
    private ProductBrandService productBrandService;
    @Autowired(required = false)
    private ProductVoService productVoService;
    @Autowired(required = false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required = false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required = false)
    private DictDataVoService dictDataVoService;
    @Autowired(required = false)
    private AuditFormulaMainService auditFormulaMainService;
    @Autowired(required = false)
    private CustomerChannelVoService customerChannelVoService;


    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, ActivityPlanItemDY00000008RegionImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
//        2、活动导入模板（大区方案）：活动分类编码、活动形式编码、总部统筹预算编码、大区自控预算编码、一级渠道编码、二级渠道编码、区域编码、品牌编码、品类编码、品项编码、产品编码（目前带出的产品名称、产品单位）、供应商编码、物料编码
        try {

            Object businessFormatCodeObj = params.get("businessFormatCode");
            if (null == businessFormatCodeObj){
                throw new RuntimeException("业态有误！");
            }
            String businessFormatCode = String.valueOf(businessFormatCodeObj);


            List<ActivityPlanItemDY00000008RegionImportVo> importVos = Lists.newArrayList(data.values());

            Set<String> orgCodeSet = Sets.newHashSet();
            Set<String> activityTypeCodeSet = Sets.newHashSet();
            Set<String> activityFormCodeSet = Sets.newHashSet();
            Set<String> monthBudgetCodeSet = Sets.newHashSet();
            Set<String> terminalChannelSet = Sets.newHashSet();
            Set<String> productBrandCodeSet = Sets.newHashSet();
            Set<String> productLevelCodeSet = Sets.newHashSet();
            Set<String> productCodeSet = Sets.newHashSet();
            Set<String> salesOrgCodeSet = Sets.newHashSet();
            Set<String> salesInsCodeSet = Sets.newHashSet();
            Set<String> customerRetailerCodeSet = Sets.newHashSet();
            Set<String> supplierCodeSet = Sets.newHashSet();
            Set<String> materialCodeSet = Sets.newHashSet();
            Set<String> auditFormulaCodeSet = Sets.newHashSet();
            Set<String> cusChannelCodeSet = Sets.newHashSet();

            List<String> dictCodeList = Lists.newArrayList();
            dictCodeList.add(ActivityPlanConstant.DICT_TPM_AUDIT_TYPE);

            Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodeList);
            Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode,(o,n)->n)),(o,n)->n));

            for (ActivityPlanItemDY00000008RegionImportVo importVo : importVos) {
                if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())){
                    List<String> typeCodes = Arrays.asList(importVo.getActivityTypeCode().split(","));
                    activityTypeCodeSet.addAll(typeCodes);
                }
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())){
                    List<String> formCodes = Arrays.asList(importVo.getActivityFormCode().split(","));
                    activityFormCodeSet.addAll(formCodes);
                }
                if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())){
                    monthBudgetCodeSet.add(importVo.getHeadMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty(importVo.getMonthBudgetCode())){
                    monthBudgetCodeSet.add(importVo.getMonthBudgetCode());
                }

                if (StringUtils.isNotEmpty(importVo.getChannelCode())){
                    cusChannelCodeSet.add(importVo.getChannelCode());
                }
                if (StringUtils.isNotEmpty(importVo.getActivityOrgCode())){
                    Validate.notBlank(importVo.getChannelCode(),"渠道编码不能为空");
                    Validate.notBlank(importVo.getSalesInstitutionCode(),"销售机构编码不能为空");
                    salesInsCodeSet.add(importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode());
                    salesOrgCodeSet.add(importVo.getActivityOrgCode());
                }
                if (StringUtils.isNotEmpty(importVo.getFirstChannelCode())){
                    List<String> channelCodes = Arrays.asList(importVo.getFirstChannelCode().split(","));
                    terminalChannelSet.addAll(channelCodes);
                }
                if (StringUtils.isNotEmpty(importVo.getSecondChannelCode())){
                    List<String> channelCodes = Arrays.asList(importVo.getSecondChannelCode().split(","));
                    terminalChannelSet.addAll(channelCodes);
                }
                if (StringUtils.isNotEmpty(importVo.getProductBrandCode())){
                    productBrandCodeSet.add(importVo.getProductBrandCode());
                }
                if (StringUtils.isNotEmpty(importVo.getProductItemCode())){
                    productLevelCodeSet.add(importVo.getProductItemCode());
                }
                if (StringUtils.isNotEmpty(importVo.getProductCategoryCode())){
                    productLevelCodeSet.add(importVo.getProductCategoryCode());
                }
                if (StringUtils.isNotEmpty(importVo.getProductCode())){
                    List<String> productCodes = Arrays.asList(importVo.getProductCode().split(","));
                    productCodeSet.addAll(productCodes);
                    //productCodeSet.add(importVo.getProductCode());
                }
//                if (StringUtils.isNotEmpty(importVo.getGiftCode())){
//                    productCodeSet.add(importVo.getGiftCode());
//                }
                if (StringUtils.isNotEmpty(importVo.getMaterialCode())){
                    materialCodeSet.add(importVo.getMaterialCode());
                }
                if (StringUtils.isNotEmpty(importVo.getSupplierCode())){
                    supplierCodeSet.add(importVo.getSupplierCode());
                }
                if (StringUtils.isNotEmpty(importVo.getSystemCode())){
                    customerRetailerCodeSet.add(importVo.getSystemCode());
                }
                if (StringUtils.isNotEmpty(importVo.getAuditConditionCode())){
                    auditFormulaCodeSet.add(importVo.getAuditConditionCode());
                }
            }

//            Map<String,String> salesOrgMap = Maps.newHashMap();
            Map<String, Map<String, SalesOrgVo>> salesMap = Maps.newHashMap();
            Map<String,String> activityTypeMap = Maps.newHashMap();
            Map<String,String> activityFormMap = Maps.newHashMap();
            Map<String, MonthBudgetVo> monthBudgetMap = Maps.newHashMap();
            Map<String,String> terminalChannelMap = Maps.newHashMap();
            Map<String,String> productBrandMap = Maps.newHashMap();
            Map<String,String> productLevelMap = Maps.newHashMap();
            Map<String, ProductVo> productMap = Maps.newHashMap();
            Map<String,String> customerRetailerMap = Maps.newHashMap();
            Map<String, AuditFormulaMainVo> auditFormulaMap = Maps.newHashMap();
            Map<String, CustomerChannelVo> cusChannelMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(activityTypeCodeSet)){
                List<ActivityTypeVo> activityTypeList = activityTypeService.findByCodes(Lists.newArrayList(activityTypeCodeSet));
                activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode,ActivityTypeVo::getActivityTypeName,(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(activityFormCodeSet)){
                List<String> activityFormCodeList = Lists.newArrayList(activityFormCodeSet);
                List<List<String>> activityFormCodeListBag = Lists.newArrayList();
                activityFormCodeListBag.add(activityFormCodeList);
                activityFormMap = activityFormService.findFormByCodes(activityFormCodeListBag);
            }
            if (!CollectionUtils.isEmpty(monthBudgetCodeSet)){
                List<MonthBudgetVo> monthBudgetVos = monthBudgetService.listByCodes(Lists.newArrayList(monthBudgetCodeSet));
                monthBudgetMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity(),(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(cusChannelCodeSet)) {
                List<CustomerChannelVo> channelVos = customerChannelVoService.findByCodes(new ArrayList<>(cusChannelCodeSet));
                if (!CollectionUtils.isEmpty(channelVos)) {
                    cusChannelMap = channelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity(), (o, n) -> n));
                }
            }
            if (!CollectionUtils.isEmpty(salesOrgCodeSet)){
                SalesOrgRangeDto rangeDto = new SalesOrgRangeDto();
                rangeDto.setSalesInstitutionCodes(new ArrayList<>(salesInsCodeSet));
                rangeDto.setErpCodes(new ArrayList<>(salesOrgCodeSet));
                salesMap = salesOrgVoService.findMapBySalesOrgErpCodesAndInsCodes(rangeDto);
            }
            if (!CollectionUtils.isEmpty(terminalChannelSet)){
                List<MdmTerminalChannelVo> mdmTerminalChannelVos = terminalChannelVoService.listByCodes(Lists.newArrayList(terminalChannelSet));
                terminalChannelMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode,MdmTerminalChannelVo::getTerminalChannelName,(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(productBrandCodeSet)){
                List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(Lists.newArrayList(productBrandCodeSet));
                productBrandMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode,ProductBrandVo::getProductBrandName,(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(productLevelCodeSet)){
                List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByBusinessFormatAndCodes(businessFormatCode,Lists.newArrayList(productLevelCodeSet));
                productLevelMap = productLevelVos.stream().collect(Collectors.toMap(item -> {
                    return item.getProductLevelType() + item.getProductLevelCode();
                },ProductLevelVo::getProductLevelName,(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(productCodeSet)){
                List<ProductVo> productVos = productVoService.findByCodes(Lists.newArrayList(productCodeSet));
                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode,Function.identity(),(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(customerRetailerCodeSet)){
                List<CustomerRetailerVo> customerRetailerVos = customerRetailerVoService.findByCodes(Lists.newArrayList(customerRetailerCodeSet));
                if (!CollectionUtils.isEmpty(customerRetailerVos)){
                    customerRetailerMap = customerRetailerVos.stream().collect(Collectors.toMap(CustomerRetailerVo::getCustomerRetailerCode,CustomerRetailerVo::getCustomerRetailerName,(o,n)->n));
                }
            }
//            if (!CollectionUtils.isEmpty(materialCodeSet)){
//                List<ProductVo> productVos = materialVoService.findDetailByMaterialCodes(materialCodeSet);
//                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode,Function.identity()));
//            }
//            if (!CollectionUtils.isEmpty(supplierCodeSet)){
//                List<ProductVo> productVos = supplierVoService.findByConditions(Lists.newArrayList(supplierCodeSet));
//                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode,Function.identity()));
//            }
            if(!CollectionUtils.isEmpty(auditFormulaCodeSet)){
                List<AuditFormulaMainVo> auditFormulaList = auditFormulaMainService.findByCodeList(Lists.newArrayList(auditFormulaCodeSet));
                if (!CollectionUtils.isEmpty(auditFormulaList)){
                    auditFormulaMap = auditFormulaList.stream().collect(Collectors.toMap(AuditFormulaMainVo::getAuditFormulaCode, Function.identity(),(o,n)->n));
                }
            }

            List<ActivityPlanItemDto> newList = Lists.newArrayList();
            for (ActivityPlanItemDY00000008RegionImportVo importVo : importVos) {
                ActivityPlanItemDto itemDto = nebulaToolkitService.copyObjectByWhiteList(importVo, ActivityPlanItemDto.class, HashSet.class, ArrayList.class);

                if (StringUtils.isNotEmpty(importVo.getActivityBeginDateStr())){
                    Validate.isTrue(isFlag(importVo.getActivityBeginDateStr()), "活动开始时间格式错误！");
                }
                if (StringUtils.isNotEmpty(importVo.getActivityEndDateStr())){
                    Validate.isTrue(isFlag(importVo.getActivityEndDateStr()), "活动结束时间格式错误！");
                }
                if (StringUtils.isNotEmpty(importVo.getOrderBeginDateStr())){
                    Validate.isTrue(isFlag(importVo.getOrderBeginDateStr()), "订单开始时间格式错误！");
                }
                if (StringUtils.isNotEmpty(importVo.getOrderEndDateStr())){
                    Validate.isTrue(isFlag(importVo.getOrderEndDateStr()), "订单结束时间格式错误！");
                }

                validateAndConvertDictData(dictMapMap,ActivityPlanConstant.DICT_TPM_AUDIT_TYPE,importVo.getAuditType(),itemDto::setAuditType,"核销类型");

                //活动分类
                if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                    String[] codes = importVo.getActivityTypeCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String activityTypeName = activityTypeMap.get(code);
                        if (StringUtils.isEmpty(activityTypeName)) {
                            throw new RuntimeException("活动分类[" + code + "]有误");
                        } else {
                            allNames.add(activityTypeName);
                        }
                    }
                    itemDto.setActivityTypeName(String.join(",", allNames));
                }

                //活动形式
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())){
                    String[] codes = importVo.getActivityFormCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String activityFormName = activityFormMap.get(code);
                        if (StringUtils.isEmpty(activityFormName)) {
                            throw new RuntimeException("活动形式[" + code + "]有误");
                        } else {
                            allNames.add(activityFormName);
                        }
                    }
                    itemDto.setActivityForm(importVo.getActivityFormCode());
                    itemDto.setActivityFormName(String.join(",", allNames));
                }

                //分销渠道
                if (StringUtils.isNotEmpty(importVo.getChannelCode())) {
                    CustomerChannelVo channelVo = cusChannelMap.get(importVo.getChannelCode());
                    if (null == channelVo) {
                        throw new RuntimeException("渠道编码[" + importVo.getChannelCode() + "]有误");
                    }
                    itemDto.setDistributionChannelCode(channelVo.getCustomerChannelCode());
                    itemDto.setDistributionChannelName(channelVo.getCustomerChannelName());
                }

                //销售组织
                if (StringUtils.isNotEmpty(importVo.getActivityOrgCode())) {
                    String insCode = importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode();
                    Map<String, SalesOrgVo> salesOrgVoMap = salesMap.get(insCode);
                    if (salesOrgVoMap.isEmpty()) {
                        throw new RuntimeException("销售组织编码[" + importVo.getActivityOrgCode() + "]未在销售机构[" + importVo.getSalesInstitutionCode() + "]下");
                    }
                    SalesOrgVo salesOrgVo = salesOrgVoMap.get(importVo.getActivityOrgCode());
                    if (Objects.isNull(salesOrgVo)) {
                        throw new RuntimeException("销售组织编码[" + importVo.getActivityOrgCode() + "]未在销售机构[" + importVo.getSalesInstitutionCode() + "]下");
                    }
                    itemDto.setActivityOrgName(salesOrgVo.getSalesOrgName());
                    itemDto.setActivityOrgCode(salesOrgVo.getSalesOrgCode());
                    itemDto.setActivityOrgErpCode(salesOrgVo.getErpCode());
                }

                //一级渠道
                if (StringUtils.isNotEmpty(importVo.getFirstChannelCode())){
                    String[] codes = importVo.getFirstChannelCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String terminalChannelName = terminalChannelMap.get(code);
                        if (StringUtils.isEmpty(terminalChannelName)){
                            throw new RuntimeException("一级渠道["+importVo.getFirstChannelCode()+"]有误");
                        }
                        allNames.add(terminalChannelName);
                    }
                    itemDto.setFirstChannelName(String.join(",", allNames));
                }

                //二级渠道
                if (StringUtils.isNotEmpty(importVo.getSecondChannelCode())){
                    String[] codes = importVo.getSecondChannelCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String terminalChannelName = terminalChannelMap.get(code);
                        if (StringUtils.isEmpty(terminalChannelName)){
                            throw new RuntimeException("二级渠道["+importVo.getSecondChannelCode()+"]有误");
                        }
                        allNames.add(terminalChannelName);
                    }
                    itemDto.setSecondChannelName(String.join(",", allNames));
                }

                //品牌
                if (StringUtils.isNotEmpty(importVo.getProductBrandCode())){
                    String brandName = productBrandMap.get(importVo.getProductBrandCode());
                    if (StringUtils.isEmpty(brandName)){
                        throw new RuntimeException("品牌["+importVo.getProductBrandCode()+"]有误");
                    }
                    itemDto.setProductBrandName(brandName);
                }

                //品类
                if (StringUtils.isNotEmpty(importVo.getProductCategoryCode())){
                    String productLevelName = productLevelMap.get(ProductLevelEnum.category.getCode() + importVo.getProductCategoryCode());
                    if (StringUtils.isEmpty(productLevelName)){
                        throw new RuntimeException("品类["+importVo.getProductCategoryCode()+"]有误");
                    }
                    itemDto.setProductCategoryName(productLevelName);
                }

                //品项
                if (StringUtils.isNotEmpty(importVo.getProductItemCode())){
                    String productLevelName = productLevelMap.get(ProductLevelEnum.items.getCode() + importVo.getProductItemCode());
                    if (StringUtils.isEmpty(productLevelName)){
                        throw new RuntimeException("品项["+importVo.getProductItemCode()+"]有误");
                    }
                    itemDto.setProductItemName(productLevelName);
                }

                //产品
                if (StringUtils.isNotEmpty(importVo.getProductCode())){
                    String[] codes = importVo.getProductCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        ProductVo productVo = productMap.get(code);
                        if(null == productVo){
                            throw new RuntimeException("产品编码["+importVo.getProductCode()+"]有误");
                        }
                        itemDto.setProductUnit(productVo.getBaseUnit());
                        allNames.add(productVo.getProductName());
                    }
                    itemDto.setProductName(String.join(",",allNames));

                    /*ProductVo productVo = productMap.get(importVo.getProductCode());
                    if(null == productVo){
                        throw new RuntimeException("产品编码["+importVo.getProductCode()+"]有误");
                    }
                    itemDto.setProductName(productVo.getProductName());
                    itemDto.setProductUnit(productVo.getSaleUnit());*/
                }

                //零售商
                if (StringUtils.isNotEmpty(importVo.getSystemCode())){
                    String customerRetailerName = customerRetailerMap.get(importVo.getSystemCode());
                    if(StringUtils.isEmpty(customerRetailerName)){
                        throw new RuntimeException("零售商编码["+importVo.getSystemCode()+"]有误");
                    }
                    itemDto.setSystemName(customerRetailerName);
                }

//                //赠品编码
//                if (StringUtils.isNotEmpty(importVo.getGiftCode())){
//                    ProductVo productVo = productMap.get(importVo.getGiftCode());
//                    if(null == productVo){
//                        throw new RuntimeException("赠品编码["+importVo.getGiftCode()+"]有误");
//                    }
//                    itemDto.setGiftName(productVo.getProductName());
//                    itemDto.setGiftUnit(productVo.getSaleUnit());
//                }

                if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())){
                    MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getHeadMonthBudgetCode());
                    if (null == monthBudgetVo){
                        throw new RuntimeException("总部费用预算编码"+importVo.getHeadMonthBudgetCode()+"有误");
                    }
                    itemDto.setHeadBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    itemDto.setHeadBudgetItemName(monthBudgetVo.getBudgetItemName());
                }
                if (StringUtils.isNotEmpty(importVo.getMonthBudgetCode())){
                    MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getMonthBudgetCode());
                    if (null == monthBudgetVo){
                        throw new RuntimeException("大区自控预算编码"+importVo.getHeadMonthBudgetCode()+"有误");
                    }
                    itemDto.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    itemDto.setBudgetItemName(monthBudgetVo.getBudgetItemName());
                }
                if (StringUtils.isNotEmpty(itemDto.getAuditType())) {
                    if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(itemDto.getAuditType())) {
                        Validate.notBlank(itemDto.getAuditConditionCode(), "核销条件编码必填！");
                        AuditFormulaMainVo auditFormula = auditFormulaMap.get(itemDto.getAuditConditionCode());
                        if (auditFormula == null){
                            throw new RuntimeException("核销条件["+importVo.getAuditConditionCode()+"]有误");
                        }
                        itemDto.setAuditConditionName(auditFormula.getAuditFormulaName());
                    }
                }

                newList.add(itemDto);
            }

            activityPlanItemPageCacheHelper.importNewItem(String.valueOf(params.get("cacheKey")), newList);
        }catch (Exception e){
            log.error(e.getMessage(),e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty(e.getMessage())){
                errorMsg = "数据处理失败！";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return null;
    }

    public void validateAndConvertDictData(Map<String, Map<String,String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc){
        if (StringUtils.isEmpty(dictValue)){
            return;
        }
        Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
        String dictCode = dictDataMap.get(dictValue);
        if (StringUtils.isEmpty(dictCode)){
            throw new RuntimeException(desc+"["+dictValue+"]有误");
        }
        setMethod.accept(dictCode);
    }

    /**
     * 时间格式判断
     *
     * @param currentTime
     * @return
     */
    private boolean isFlag(String currentTime) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        boolean flag = true;
        try {
            dtf.parse(currentTime);
        } catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    @Override
    public Class<ActivityPlanItemDY00000008RegionImportVo> findCrmExcelVoClass() {
        return ActivityPlanItemDY00000008RegionImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_ACTIVITY_PLAN_DETAIL_IMPORT_DY00000008_REGION";
    }

    @Override
    public String getTemplateName() {
        return "活动方案导入模板（主体-大区）";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_ACTIVITY_PLAN_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-活动方案明细导入";
    }

}
