package com.biz.crm.tpm.business.activity.plan.local.imports;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.brand.sdk.dto.ProductBrandFormatDto;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.promotion.material.sdk.service.PromotionMaterialService;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.PromotionMaterialVO;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.MnBeanUtils;
import com.biz.crm.mn.common.ie.sdk.process.MnImportProcess;
import com.biz.crm.mn.common.ie.sdk.vo.MnCrmExcelVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractMaterialDto;
import com.biz.crm.tpm.business.activity.contract.sdk.enums.ContractTypeEnum;
import com.biz.crm.tpm.business.activity.contract.sdk.service.ActivityContractSdkService;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractMaterialVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractVo;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.enums.VerticalActivityTypeEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.plan.local.imports.vo.ActivityPlanDY00000010ImportVo;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanTemplateMapEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.WriteOffMethodEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.ActivityPlanQuerySchemeForecastListener;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.dto.ActivityPlanQuerySchemeForecastDto;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQuerySchemeForecastCashVo;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQuerySchemeForecastResponse;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName ActivityPlanDY00000010ImportsProcess
 * @Description 垂直活动方案导入-通用，按模板导入
 * @Author: wanghaojia
 * @Date 2023/3/5
 */
@Slf4j
@Component
public class ActivityPlanDY00000010ImportsProcess extends MnImportProcess<ActivityPlanDY00000010ImportVo> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityPlanItemPageCacheHelper activityPlanItemPageCacheHelper;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private ActivityTypeService activityTypeService;
    @Autowired(required = false)
    private ActivityFormService activityFormService;
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private TerminalVoService terminalVoService;
    @Autowired(required = false)
    private CustomerVoService customerVoService;
    @Autowired(required = false)
    private AuditFormulaMainService auditFormulaMainService;
    @Autowired(required = false)
    private ProductBrandService productBrandService;
    @Autowired(required = false)
    private ProductVoService productVoService;
    @Autowired(required = false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required = false)
    private CustomerRetailerVoService customerRetailerVoService;

    @Autowired(required = false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    @Autowired(required = false)
    private ActivityContractSdkService activityContractSdkService;

    @Autowired(required = false)
    private PromotionMaterialService promotionMaterialService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    //促销方案模版总部
    final String TEMPLATE_SALE_CODE = "HDMBPZ3122";
    //
    final String TEMPLATE_PROMOTION_CODE = "HDMBPZ0163";

    protected static final ThreadLocal<ActivitiesTemplateConfigVo> templateConfigVoThreadLocal = new ThreadLocal<>();

    @Override
    public Integer getHeadTitleRowIndex() {
        return 0;
    }


    @Override
    public Map<Integer, String> analysisHeadFieldMap(Map<String, Object> params, Map<Integer, String> headMap) {
        String cacheKey = String.valueOf(params.get("cacheKey"));
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];//模板编码

        ActivitiesTemplateConfigVo templateConfigVo = activitiesTemplateSdkService.findByCode(templateCode);
        if (null == templateConfigVo) {
            throw new RuntimeException("模板解析错误！");
        }
        templateConfigVoThreadLocal.set(templateConfigVo);
        Map<String, String> templateFieldMap = templateConfigVo.getDetails().stream()
                .filter(item -> StringUtils.isNotEmpty(item.getTitle()))
                .collect(Collectors.toMap(ActivitiesTemplateConfigDetailVo::getTitle, ActivitiesTemplateConfigDetailVo::getField, (o, n) -> n));

        Map<Integer, String> headFieldMap = Maps.newHashMap();
        for (Map.Entry<Integer, String> entry : headMap.entrySet()) {
            headFieldMap.put(entry.getKey(), templateFieldMap.get(entry.getValue()));
        }
        return headFieldMap;
    }

    @Override
    public Integer getBatchCount() {
        return 1000;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, ActivityPlanDY00000010ImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        String cacheKey = String.valueOf(params.get("cacheKey"));
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];//模板编码

        Map<Integer, String> errorMap = Maps.newHashMap();
        Map<Integer, List<String>> errorListMap = Maps.newHashMap();
        try {
            String businessFormatCode = String.valueOf(params.get("businessFormatCode"));

            List<Map<String, Object>> importMaps = data.values().stream().map(MnCrmExcelVo::getData).collect(Collectors.toList());

            ActivitiesTemplateConfigVo templateConfigVo = templateConfigVoThreadLocal.get();
            List<ActivitiesTemplateConfigDetailVo> dictFieldList = templateConfigVo.getDetails().stream().filter(item -> StringUtils.isNotEmpty(item.getDictCode())).collect(Collectors.toList());
            //数据字典 活动模板与具体活动形式的映射 字典编码（plan_template_map）
            Map<String, String> planTemplateMap = new HashMap<>();
            Map<String, Map<String, String>> dictMapMap = Maps.newHashMap();
            List<String> dictCodeList = Lists.newArrayList("plan_template_map");
            if (dictFieldList.size() > 0) {
                List<String> templateDictCodeList = dictFieldList.stream().filter(item -> StringUtils.isNotEmpty(item.getDictCode())).map(ActivitiesTemplateConfigDetailVo::getDictCode).collect(Collectors.toList());
                dictCodeList.addAll(templateDictCodeList);
            }
            Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodeList);
            dictMapMap = !CollectionUtils.isEmpty(dictMap) ? dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n)), (o, n) -> n)) : new HashMap<>();
            if (!CollectionUtils.isEmpty(dictMap)) {
                List<DictDataVo> planTemplateDictDataVos = dictMap.get("plan_template_map");
                if (null != planTemplateDictDataVos) {
                    planTemplateMap = planTemplateDictDataVos.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> n));
                }
            }
            //先校验一遍数据字典并赋值
            for (Map.Entry<Integer, ActivityPlanDY00000010ImportVo> entry : data.entrySet()) {
                Integer key = entry.getKey();
                List<String> errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
                Map<String, Object> importMap = entry.getValue().getData();
                for (ActivitiesTemplateConfigDetailVo activitiesTemplateConfigDetailVo : templateConfigVo.getDetails()) {
                    Object fieldObj = importMap.get(activitiesTemplateConfigDetailVo.getField());
                    try {
                        //一二级渠道名称处理
                        if ("firstChannelCode".equals(activitiesTemplateConfigDetailVo.getField())) {
                            importMap.put("firstChannelName", fieldObj);
                        }
                        if ("secondChannelCode".equals(activitiesTemplateConfigDetailVo.getField())) {
                            importMap.put("secondChannelName", fieldObj);
                        }
                        if (Boolean.TRUE.equals(activitiesTemplateConfigDetailVo.getRequired()) && null == fieldObj) {
                            errorList.add("字段【" + activitiesTemplateConfigDetailVo.getTitle() + "】必填！");
                        }
                        if (null != fieldObj && StringUtils.isNotEmpty(activitiesTemplateConfigDetailVo.getDictCode())) {
                            validateAndConvertDictData(dictMapMap, activitiesTemplateConfigDetailVo.getDictCode(), fieldObj.toString(), s -> importMap.put(activitiesTemplateConfigDetailVo.getField(), s), activitiesTemplateConfigDetailVo.getTitle());

                        }
                    } catch (Exception e) {
                        log.error(e.getMessage(), e);
                        errorList.add(e.getMessage());
                    }
                }
            }

            List<ActivityPlanItemDto> importVos = MnBeanUtils.mapListToBeanList(importMaps, ActivityPlanItemDto.class, false);

            //校验数字类型字段格式
            Map<String, String> templateDetailTitleMap = templateConfigVo.getDetails().stream().collect(Collectors.toMap(ActivitiesTemplateConfigDetailVo::getField, ActivitiesTemplateConfigDetailVo::getTitle));
            validateNumberScale(importVos, errorListMap, templateDetailTitleMap);

//            销售组织编码、门店编码、售达方编码、品牌、品类、品项、赠品编码、产品编码等通过导入编码的字段，根据编码识别名称保存

            Set<String> orgCodeSet = Sets.newHashSet();
            Set<String> activityTypeCodeSet = Sets.newHashSet();
            Set<String> activityFormCodeSet = Sets.newHashSet();
            Set<String> monthBudgetCodeSet = Sets.newHashSet();
            Set<String> customerCodeSet = Sets.newHashSet();
            Set<String> terminalCodeSet = Sets.newHashSet();
            Set<String> terminalChannelSet = Sets.newHashSet();
            Set<String> productBrandCodeSet = Sets.newHashSet();
            Set<String> productLevelCodeSet = Sets.newHashSet();
            Set<String> productCodeSet = Sets.newHashSet();
            Set<String> salesOrgCodeSet = Sets.newHashSet();
            Set<String> auditFormulaCodeSet = Sets.newHashSet();
            Set<String> customerRetailerCodeSet = Sets.newHashSet();
            Set<String> customerRetailerNameSet = Sets.newHashSet();
            Set<String> contractCodeSet = Sets.newHashSet();
            Set<String> materialCodeSet = Sets.newHashSet();
            Set<String> schemeForecastDetailCodeSet = Sets.newHashSet();


            int key = 0;
            for (ActivityPlanItemDto importVo : importVos) {
                List<String> errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
                try {
                    if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                        activityTypeCodeSet.add(importVo.getActivityTypeCode());
                    }
                    if (StringUtils.isNotEmpty(importVo.getActivityFormCode())) {
                        activityFormCodeSet.add(importVo.getActivityFormCode());
                    }
                    if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())) {
                        monthBudgetCodeSet.add(importVo.getHeadMonthBudgetCode());
                    }
                    if (StringUtils.isNotEmpty(importVo.getRegionAutomaticMonthBudgetCode())) {
                        monthBudgetCodeSet.add(importVo.getRegionAutomaticMonthBudgetCode());
                    }
                    if (StringUtils.isNotEmpty(importVo.getRegionReferendumMonthBudgetCode())) {
                        monthBudgetCodeSet.add(importVo.getRegionReferendumMonthBudgetCode());
                    }
                    if (StringUtils.isNotEmpty(importVo.getSalesInstitutionErpCode())) {
                        if (StringUtils.isEmpty(importVo.getDistributionChannelCode())) {
//                            throw new RuntimeException("导入销售组织时分销渠道不能为空！");
                            errorList.add("导入销售组织时分销渠道不能为空！");
                        }
                        importVo.setActivityOrgCode(importVo.getDistributionChannelCode() + businessFormatCode + importVo.getSalesInstitutionErpCode());
                    }
                    if (StringUtils.isNotEmpty(importVo.getActivityOrgCode())) {
                        salesOrgCodeSet.add(importVo.getActivityOrgCode());
                    }
                    if (StringUtils.isNotEmpty(importVo.getCustomerErpCode())) {
                        if (StringUtils.isEmpty(importVo.getSalesInstitutionErpCode()) || StringUtils.isEmpty(importVo.getDistributionChannelCode())) {
                            //导入的时候拼接吧
//                            throw new RuntimeException("导入客户时销售机构编码和分销渠道不能为空！");
                            errorList.add("导入客户时销售机构编码和分销渠道不能为空！");
                        }
                        customerCodeSet.add(importVo.getCustomerErpCode() + importVo.getSalesInstitutionErpCode() + importVo.getDistributionChannelCode() + businessFormatCode);
                    }
                    if (StringUtils.isNotEmpty(importVo.getTerminalCode())) {
                        terminalCodeSet.add(importVo.getTerminalCode());
                    }
                    //零售商支持多选
                    if (StringUtils.isNotEmpty(importVo.getSystemCode())) {
                        customerRetailerCodeSet.addAll(Arrays.asList(importVo.getSystemCode().replace("，", ",").split(",")));
                    }
                    if (StringUtils.isNotEmpty(importVo.getSystemName())) {
                        customerRetailerNameSet.addAll(Arrays.asList(importVo.getSystemName().replace("，", ",").split(",")));
                    }
                    if (StringUtils.isNotEmpty(importVo.getAuditConditionCode())) {
                        auditFormulaCodeSet.add(importVo.getAuditConditionCode());
                    }
                    if (StringUtils.isNotEmpty(importVo.getProductBrandCode())) {
                        productBrandCodeSet.add(importVo.getProductBrandCode());
                    }
                    if (StringUtils.isNotEmpty(importVo.getProductCode())) {
                        productCodeSet.add(importVo.getProductCode());
                    }
                    if (StringUtils.isNotEmpty(importVo.getProductItemCode())) {
                        productLevelCodeSet.add(importVo.getProductItemCode());
                    }
                    if (StringUtils.isNotEmpty(importVo.getProductCategoryCode())) {
                        productLevelCodeSet.add(importVo.getProductCategoryCode());
                    }
                    if (StringUtils.isNotEmpty(importVo.getContractCode())) {
                        contractCodeSet.add(importVo.getContractCode());
                    }
                    if (StringUtils.isNotEmpty(importVo.getMaterialCode())) {
                        materialCodeSet.add(importVo.getMaterialCode());
                    }
                    if (StringUtils.isNotEmpty(importVo.getSchemeForecastDetailCode())) {
                        schemeForecastDetailCodeSet.add(importVo.getSchemeForecastDetailCode());
                    }
                } catch (RuntimeException e) {
                    log.error("", e);
                    errorList.add(e.getMessage());
                } catch (Exception e) {
                    log.error(e.getMessage(), e);
                    errorList.add(e.getMessage());
                } finally {
                    key++;
                }
            }

            Map<String, String> salesOrgMap = Maps.newHashMap();
            Map<String, TerminalVo> terminalMap = Maps.newHashMap();
            Map<String, CustomerVo> customerMap = Maps.newHashMap();
            Map<String, String> activityTypeMap = Maps.newHashMap();
            Map<String, ActivityFormVo> activityFormMap = Maps.newHashMap();
            Map<String, MonthBudgetVo> monthBudgetMap = Maps.newHashMap();
            Map<String, AuditFormulaMainVo> auditFormulaMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(activityTypeCodeSet)) {
                List<ActivityTypeVo> activityTypeList = activityTypeService.findByCodes(Lists.newArrayList(activityTypeCodeSet));
                activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, ActivityTypeVo::getActivityTypeName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(activityFormCodeSet)) {
                List<String> activityFormCodeList = Lists.newArrayList(activityFormCodeSet);
                ActivityFormDto activityFormDto = new ActivityFormDto();
                activityFormDto.setActivityFormCodeList(activityFormCodeList);
                activityFormDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
                List<ActivityFormVo> activityFormVos = activityFormService.findListByConditions(activityFormDto);
                activityFormMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(monthBudgetCodeSet)) {
                List<MonthBudgetVo> monthBudgetVos = monthBudgetService.listByCodes(Lists.newArrayList(monthBudgetCodeSet), BusinessUnitEnum.VERTICAL.getCode());
                monthBudgetMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(salesOrgCodeSet)) {
                List<SalesOrgVo> salesOrgList = salesOrgVoService.findBySalesOrgCodes(Lists.newArrayList(salesOrgCodeSet));
                if (!CollectionUtils.isEmpty(salesOrgList)) {
                    salesOrgMap = salesOrgList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, SalesOrgVo::getSalesOrgName, (o, n) -> n));
                }
            }
            if (!CollectionUtils.isEmpty(terminalCodeSet)) {
                List<TerminalVo> terminalVos = terminalVoService.findBaseByTerminalCodes(Lists.newArrayList(terminalCodeSet));
                if (!CollectionUtils.isEmpty(terminalVos)) {
                    terminalMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity(), (o, n) -> n));
                }
            }
            if (!CollectionUtils.isEmpty(customerCodeSet)) {
                List<CustomerVo> customerVos = customerVoService.findBaseByCustomerCodes(Lists.newArrayList(customerCodeSet));
                if (!CollectionUtils.isEmpty(customerVos)) {
                    customerMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
                }
            }
            if (!CollectionUtils.isEmpty(auditFormulaCodeSet)) {
                List<AuditFormulaMainVo> auditFormulaList = auditFormulaMainService.findByCodeList(Lists.newArrayList(auditFormulaCodeSet));
                if (!CollectionUtils.isEmpty(auditFormulaList)) {
                    auditFormulaMap = auditFormulaList.stream().collect(Collectors.toMap(AuditFormulaMainVo::getAuditFormulaCode, Function.identity(), (o, n) -> n));
                }
            }
            Map<String, String> productBrandMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(productBrandCodeSet)) {
                ProductBrandFormatDto productBrandFormatDto = new ProductBrandFormatDto();
                productBrandFormatDto.setBusinessFormatCode(businessFormatCode);
                productBrandFormatDto.setCodes(Lists.newArrayList(productBrandCodeSet));
                Map<String, String> productBrandMapTemp = productBrandService.findNameByCodesAndFormat(productBrandFormatDto);
                if (null != productBrandMapTemp) {
                    productBrandMap = productBrandMapTemp;
                }
            }
            Map<String, String> productCategoryMap = Maps.newHashMap();
            Map<String, String> productItemMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(productLevelCodeSet)) {
                List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByBusinessFormatAndCodes(businessFormatCode, Lists.newArrayList(productLevelCodeSet));
                List<ProductLevelVo> productCategoryList = productLevelVos.stream().filter(item -> ProductLevelEnum.category.equals(item.getProductLevelType())).collect(Collectors.toList());
                productCategoryMap = productCategoryList.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (o, n) -> n));
                List<ProductLevelVo> productItemList = productLevelVos.stream().filter(item -> ProductLevelEnum.items.equals(item.getProductLevelType())).collect(Collectors.toList());
                productItemMap = productItemList.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (o, n) -> n));
            }
            Map<String, ProductVo> productMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(productCodeSet)) {
                List<ProductVo> productVos = productVoService.findByCodes(Lists.newArrayList(productCodeSet));
                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o, n) -> n));
            }
            Map<String, String> customerRetailerMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(customerRetailerCodeSet)) {
                List<CustomerRetailerVo> customerRetailerVos = customerRetailerVoService.findByCodes(Lists.newArrayList(customerRetailerCodeSet));
                if (!CollectionUtils.isEmpty(customerRetailerVos)) {
                    customerRetailerMap = customerRetailerVos.stream().collect(Collectors.toMap(CustomerRetailerVo::getCustomerRetailerCode, CustomerRetailerVo::getCustomerRetailerName, (o, n) -> n));
                }
            }
            Map<String, String> systemMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(customerRetailerNameSet)) {
                List<CustomerRetailerVo> customerRetailerVos = customerRetailerVoService.findByNames(Lists.newArrayList(customerRetailerNameSet));
                if (!CollectionUtils.isEmpty(customerRetailerVos)) {
                    systemMap = customerRetailerVos.stream().collect(Collectors.toMap(CustomerRetailerVo::getCustomerRetailerName, CustomerRetailerVo::getCustomerRetailerCode, (o, n) -> n));
                }
            }
            Map<String, ActivityContractVo> contractVoMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(contractCodeSet)) {
                List<ActivityContractVo> contractVoList = activityContractSdkService.findByCodeList(Lists.newArrayList(contractCodeSet));
                if (!CollectionUtils.isEmpty(contractVoList)) {
                    contractVoMap = contractVoList.stream().collect(Collectors.toMap(ActivityContractVo::getContractNo, Function.identity(), (o, n) -> n));
                }
            }
            Map<String, PromotionMaterialVO> promotionMaterialMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(materialCodeSet)) {
                List<PromotionMaterialVO> materialList = promotionMaterialService.findByCodeList(Lists.newArrayList(materialCodeSet));
                if (!CollectionUtils.isEmpty(materialList)) {
                    promotionMaterialMap = materialList.stream().collect(Collectors.toMap(PromotionMaterialVO::getMaterialCode, Function.identity(), (o, n) -> n));
                }
            }
            Map<String, ActivityPlanQuerySchemeForecastCashVo> schemeForecastDetailMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(schemeForecastDetailCodeSet)) {
                ActivityPlanQuerySchemeForecastDto eventDto = new ActivityPlanQuerySchemeForecastDto();
                eventDto.setSchemeForecastDetailCodeList(Lists.newArrayList(schemeForecastDetailCodeSet));
                SerializableBiConsumer<ActivityPlanQuerySchemeForecastListener, ActivityPlanQuerySchemeForecastDto> findDetailListByConditions =
                        ActivityPlanQuerySchemeForecastListener::findDetailListByConditions;
                ActivityPlanQuerySchemeForecastResponse eventResponse = (ActivityPlanQuerySchemeForecastResponse) this.nebulaNetEventClient.directPublish(eventDto, ActivityPlanQuerySchemeForecastListener.class, findDetailListByConditions);
                if (null != eventResponse && !CollectionUtils.isEmpty(eventResponse.getList())) {
                    schemeForecastDetailMap = eventResponse.getList().stream().collect(Collectors.toMap(ActivityPlanQuerySchemeForecastCashVo::getDetailCode, Function.identity(), (o, n) -> n));
                }
            }


            key = 0;
            List<ActivityPlanItemDto> newList = Lists.newArrayList();
            String currYearMonth = DateUtil.getDateStrByFormat(new Date(), DateUtil.DEFAULT_YEAR_MONTH);
            for (ActivityPlanItemDto importVo : importVos) {
                List<String> errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
                try {

                    ActivityPlanItemDto itemDto = nebulaToolkitService.copyObjectByWhiteList(importVo, ActivityPlanItemDto.class, HashSet.class, ArrayList.class);
                    if (!CollectionUtils.isEmpty(planTemplateMap)) {
                        String type = planTemplateMap.get(templateCode);
                        //Validate.notBlank(type,"请用模版编码【"+templateCode+"】在数据字典plan_template_map中配置模版映射");
                        if (!StringUtils.isBlank(type)) {
                            if (!ActivityPlanTemplateMapEnum.TRADE_SALE.getCode().equals(type)
                                    && !ActivityPlanTemplateMapEnum.LOGISTICS.getCode().equals(type)
                                    && !ActivityPlanTemplateMapEnum.MILK_CARD.getCode().equals(type)) {

                                if (StringUtils.isNotBlank(itemDto.getTerminalCode())) {
//                                    Validate.notEmpty(terminalMap, "根据门店编码，未查询到任何门店信息");
                                    if (terminalMap.isEmpty()) {
                                        errorList.add("根据门店编码，未查询到任何门店信息");
                                    }
                                    TerminalVo terminalVo = terminalMap.get(itemDto.getTerminalCode());
//                                    Validate.notNull(terminalVo, "根据门店编码【" + itemDto.getTerminalCode() + "】未查询到门店信息");
                                    if (Objects.isNull(terminalVo)) {
                                        errorList.add("根据门店编码【" + itemDto.getTerminalCode() + "】未查询到门店信息");
                                    }
                                    if (StringUtils.isEmpty(terminalVo.getSellerCode())) {
                                        throw new RuntimeException("门店[" + itemDto.getTerminalCode() + "]未获取到售达方信息");
                                    }
                                    if (StringUtils.isEmpty(terminalVo.getSalesInstitutionCode())) {
                                        throw new RuntimeException("门店[" + itemDto.getTerminalCode() + "]未获取到销售机构信息");
                                    }
                                    itemDto.setCustomerCode(terminalVo.getSellerCode() + itemDto.getSalesInstitutionErpCode() + itemDto.getDistributionChannelCode() + "11");
                                    itemDto.setCustomerErpCode(terminalVo.getSellerCode());
                                    itemDto.setActivityOrgCode(terminalVo.getSalesInstitutionCode());
                                    itemDto.setActivityOrgName(terminalVo.getSalesInstitutionName());
                                } else if (StringUtils.isNotBlank(itemDto.getCustomerCode())) {
                                    itemDto.setCustomerErpCode(itemDto.getCustomerCode());
                                    itemDto.setCustomerCode(itemDto.getCustomerCode() + itemDto.getSalesInstitutionErpCode() + itemDto.getDistributionChannelCode() + "11");
                                }

                            }
                        }
                    }

//                    Validate.notBlank(importVo.getActivityBeginDateStr(), "活动开始时间不能为空！");
                    if (StringUtils.isEmpty(importVo.getActivityBeginDateStr())) {
                        errorList.add("活动开始时间不能为空！");
                    }
                    String feeYearMonth = StringUtils.stripToEmpty(importVo.getActivityBeginDateStr());
//                    Validate.isTrue(isFlag(importVo.getActivityBeginDateStr()), "活动开始时间格式错误！");
                    if (!isFlag(importVo.getActivityBeginDateStr())) {
                        errorList.add("活动开始时间格式错误！");
                    } else {
//                    费用归属年月=活动开始时间年月，核销方式是事中的话，用订单开始时间作为费用归属年月
//                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
                        feeYearMonth = feeYearMonth.substring(0, 7);
                        if (WriteOffMethodEnum.THINGS.getCode().equals(importVo.getWriteOffMethod()) && StringUtils.isNotEmpty(importVo.getOrderBeginDateStr())) {
                            feeYearMonth = importVo.getOrderBeginDateStr().substring(0, 7);
                        } else {
//                        事后活动，费用归属年月：活动所属年月和当前年月取最最近的年月
                            if (currYearMonth.compareTo(feeYearMonth) > 0) {
                                feeYearMonth = currYearMonth;
                            }
                        }

                        itemDto.setFeeYearMonthStr(feeYearMonth);
                    }

//                    Validate.notBlank(importVo.getActivityEndDateStr(), "活动结束时间不能为空！");
                    if (StringUtils.isEmpty(importVo.getActivityEndDateStr())) {
                        errorList.add("活动结束时间不能为空！");
                    }
//                    Validate.isTrue(isFlag(importVo.getActivityEndDateStr()), "活动结束时间格式错误！");
                    if (!isFlag(importVo.getActivityEndDateStr())) {
                        errorList.add("活动结束时间格式错误！");
                    }

                    if (StringUtils.isNotEmpty(importVo.getOrderBeginDateStr())) {
//                        Validate.isTrue(isFlag(importVo.getOrderBeginDateStr()), "订单开始时间格式错误！");
                        if (!isFlag(importVo.getOrderBeginDateStr())) {
                            errorList.add("订单开始时间格式错误！");
                        }
                    }
                    if (StringUtils.isNotEmpty(importVo.getOrderEndDateStr())) {
//                        Validate.isTrue(isFlag(importVo.getOrderEndDateStr()), "订单结束时间格式错误！");
                        if (!isFlag(importVo.getOrderEndDateStr())) {
                            errorList.add("订单结束时间格式错误！");
                        }
                    }


                    //活动分类
                    List<String> codeList = new ArrayList<>();
                    if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                        String[] codes = importVo.getActivityTypeCode().split(",");
                        LinkedList<String> allNames = new LinkedList<>();
                        for (String code : codes) {
                            String activityTypeName = activityTypeMap.get(code);
                            if (StringUtils.isEmpty(activityTypeName)) {
                                throw new RuntimeException("活动分类[" + code + "]有误");
                            } else {
                                allNames.add(activityTypeName);
                            }
                        }
                        itemDto.setActivityType(itemDto.getActivityTypeCode());
                        itemDto.setActivityTypeName(String.join(",", allNames));
                        codeList = Arrays.asList(codes);
                    }

                    //活动形式
                    if (StringUtils.isNotEmpty(importVo.getActivityFormCode())) {
                        String[] codes = importVo.getActivityFormCode().split(",");
                        LinkedList<String> allNames = new LinkedList<>();
                        ActivityFormVo activityFormVo = null;
                        for (String code : codes) {
                            activityFormVo = activityFormMap.get(code);
                            if (null == activityFormVo) {
//                                throw new RuntimeException("活动形式[" + code + "]有误");
                                errorList.add("活动形式[" + code + "]有误");
                            } else {
//                                Validate.isTrue(codeList.contains(activityFormVo.getActivityTypeCode()), "活动形式[" + code + "]不在当前活动分类中");
                                if (!codeList.contains(activityFormVo.getActivityTypeCode())) {
                                    errorList.add("活动形式[" + code + "]不在当前活动分类中");
                                }
                                allNames.add(activityFormVo.getActivityFormName());
                                if (VerticalActivityTypeEnum.temporary_staff.getCode().equals(activityFormVo.getVerticalActivityType())) {
                                    //活动形式下“垂直活动类型”为“临促人员活动”的活动做校验，临促人员的人员信息不允许维护。
                                    if (StringUtils.isNotEmpty(importVo.getEmployeeCode()) ||
                                            StringUtils.isNotEmpty(importVo.getEmployeeId())) {
//                                throw new RuntimeException("临促人员的人员信息不允许维护");
                                        errorList.add("临促人员的人员信息不允许维护");
                                    }
                                }
                            }
                        }
                        itemDto.setActivityForm(importVo.getActivityFormCode());
                        itemDto.setActivityFormName(String.join(",", allNames));
                    }
                    //档期日期
                    if (StringUtils.isNotEmpty(importVo.getScheduleBeginDateStr())) {
                        try {
                            itemDto.setScheduleBeginDate(DateUtil.parseDate(importVo.getScheduleBeginDateStr(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
                        } catch (Exception e) {
                            log.error(e.getMessage());
//                            throw new IllegalArgumentException("档期开始日期[" + importVo.getScheduleBeginDateStr() + "]格式错误，请更改为yyyy-MM-dd");
                            errorList.add("档期开始日期[" + importVo.getScheduleBeginDateStr() + "]格式错误，请更改为yyyy-MM-dd");
                        }
                    }
                    if (StringUtils.isNotEmpty(importVo.getScheduleEndDateStr())) {
                        try {
                            itemDto.setScheduleEndDate(DateUtil.parseDate(importVo.getScheduleEndDateStr(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
                        } catch (Exception e) {
                            log.error(e.getMessage());
//                            throw new IllegalArgumentException("档期结束日期[" + importVo.getScheduleEndDateStr() + "]格式错误，请更改为yyyy-MM-dd");
                            errorList.add("档期结束日期[" + importVo.getScheduleEndDateStr() + "]格式错误，请更改为yyyy-MM-dd");
                        }
                    }

                    //销售组织
                    if (StringUtils.isNotEmpty(importVo.getActivityOrgCode())) {
                        String salesOrgName = salesOrgMap.get(importVo.getActivityOrgCode());
                        if (StringUtils.isEmpty(salesOrgName)) {
//                            throw new RuntimeException("销售组织[" + importVo.getActivityOrgCode() + "]有误");
                            errorList.add("销售组织[" + importVo.getActivityOrgCode() + "]有误");
                        }
                        itemDto.setActivityOrgName(salesOrgName);
                    }

                    //零售商
                    if (TEMPLATE_SALE_CODE.equals(templateCode) || TEMPLATE_PROMOTION_CODE.equals(templateCode)) {
                        String systemCode = importVo.getSystemCode();
                        if (StringUtils.isNotEmpty(systemCode)) {
                            systemCode = systemCode.replace("，", ",");
                            String[] form = systemCode.split(",");
                            List<String> customerRetailerNameList = new ArrayList<>();
                            for (String code : form) {
                                String customerRetailerName = customerRetailerMap.get(code);
                                if (StringUtils.isEmpty(customerRetailerName)) {
//                                    throw new RuntimeException("零售商编码[" + code + "]有误");
                                    errorList.add("零售商编码[" + code + "]有误");
                                }
                                customerRetailerNameList.add(customerRetailerName);
                            }
                            String name = null;
                            if (!CollectionUtils.isEmpty(customerRetailerNameList)) {
                                name = String.join(",", customerRetailerNameList);
                            } else {
//                                throw new RuntimeException("零售商编码[" + importVo.getSystemCode() + "]有误");
                                errorList.add("零售商编码[" + importVo.getSystemCode() + "]有误");
                            }

                            itemDto.setSystemName(name);
                        }
//                        if (StringUtils.isNotEmpty(systemCode)) {
//                            String customerRetailerName = customerRetailerMap.get(importVo.getSystemCode());
//                            if (StringUtils.isEmpty(customerRetailerName)) {
//                                throw new RuntimeException("零售商编码[" + importVo.getSystemCode() + "]有误");
//                            }
//                            itemDto.setSystemName(customerRetailerName);
//                        }
                        String systemName = importVo.getSystemName();
                        if (StringUtils.isNotEmpty(systemName)) {
                            systemName = systemName.replace("，", ",");
                            String[] form = systemName.split(",");
                            List<String> customerRetailerCodeList = new ArrayList<>();
                            for (String s : form) {
                                String code = systemMap.get(s);
                                if (StringUtils.isEmpty(code)) {
//                                    throw new RuntimeException("零售商编码[" + s + "]有误");
                                    errorList.add("零售商编码[" + s + "]有误");
                                }
                                customerRetailerCodeList.add(code);
                            }
                            String customerRetailerCode = null;
                            if (!CollectionUtils.isEmpty(customerRetailerCodeList)) {
                                customerRetailerCode = String.join(",", customerRetailerCodeList);
                            } else {
//                                throw new RuntimeException("零售商名称[" + importVo.getSystemName() + "]有误");
                                errorList.add("零售商名称[" + importVo.getSystemName() + "]有误");
                            }
                            itemDto.setSystemCode(customerRetailerCode);
                        }
///*                        if (StringUtils.isNotEmpty(importVo.getSystemName())) {
//                            String customerRetailerCode = systemMap.get(importVo.getSystemName());
//                            if (StringUtils.isEmpty(customerRetailerCode)) {
//                                throw new RuntimeException("零售商名称[" + importVo.getSystemName() + "]有误");
//                            }
//                            itemDto.setSystemCode(customerRetailerCode);
//                        }*/
                    } else {
                        if (StringUtils.isNotEmpty(importVo.getSystemCode())) {
                            String customerRetailerName = customerRetailerMap.get(importVo.getSystemCode());
                            if (StringUtils.isEmpty(customerRetailerName)) {
//                                throw new RuntimeException("零售商编码[" + importVo.getSystemCode() + "]有误");
                                errorList.add("零售商编码[" + importVo.getSystemCode() + "]有误");
                            }
                            itemDto.setSystemName(customerRetailerName);
                        }
                        if (StringUtils.isNotEmpty(importVo.getSystemName())) {
                            String customerRetailerCode = systemMap.get(importVo.getSystemName());
                            if (StringUtils.isEmpty(customerRetailerCode)) {
//                                throw new RuntimeException("零售商名称[" + importVo.getSystemName() + "]有误");
                                errorList.add("零售商名称[" + importVo.getSystemName() + "]有误");
                            }
                            itemDto.setSystemCode(customerRetailerCode);
                        }
                    }
                    //核销条件（核销公式）
                    if (StringUtils.isNotEmpty(importVo.getAuditConditionCode())) {
                        AuditFormulaMainVo auditFormula = auditFormulaMap.get(importVo.getAuditConditionCode());
                        if (auditFormula == null) {
//                            throw new RuntimeException("核销条件[" + importVo.getAuditConditionCode() + "]有误");
                            errorList.add("核销条件[" + importVo.getAuditConditionCode() + "]有误");
                        }
                        itemDto.setAuditConditionName(auditFormula.getAuditFormulaName());
                    } else {
//                        Validate.isTrue(!TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(importVo.getAuditType()), "核销条件编码必填");
                        if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(importVo.getAuditType())) {
                            errorList.add("核销条件编码必填");
                        }
                    }

                    //门店
                    if (StringUtils.isNotEmpty(importVo.getTerminalCode())) {
                        TerminalVo terminalVo = terminalMap.get(importVo.getTerminalCode());
                        if (null == terminalVo) {
//                            throw new RuntimeException("门店编码[" + importVo.getTerminalCode() + "]有误");
                            errorList.add("门店编码[" + importVo.getTerminalCode() + "]有误");
                        }
                        if (!EnableStatusEnum.ENABLE.getCode().equals(terminalVo.getEnableStatus()) || !BooleanEnum.TRUE.getNumStr().equals(terminalVo.getTerminalState())) {
//                            throw new RuntimeException("方案中包含已被禁用、已关闭的门店，门店编码为" + importVo.getTerminalCode() + ",请校对后再提交");
                            errorList.add("方案中包含已被禁用、已关闭的门店，门店编码为" + importVo.getTerminalCode() + ",请校对后再提交");
                        }
                        //校验门店所属销售组织、AC分仓、区域、零售商、ac门店类型与方案填写内容是否一致，若方案字段销售组织、AC分仓、区域、零售商、ac门店类型字段为空，则跳过改字段校验
//                    if (!StringUtils.isEmpty(importVo.getActivityOrgCode())){
//                        if (!importVo.getActivityOrgCode().equals(terminalVo.getSalesOrgCode())){
//                            throw new RuntimeException("门店["+importVo.getTerminalCode()+"]不属于销售组织["+importVo.getActivityOrgCode()+"]有误");
//                        }
//                    }
//                    if (!StringUtils.isEmpty(itemDto.getAcWarehouseCode())){
//                        if (!itemDto.getAcWarehouseCode().equals(terminalVo.getPointsWarehouseCode())){
//                            throw new RuntimeException("门店["+importVo.getTerminalCode()+"]不属于AC分仓["+importVo.getAcWarehouseName()+"]");
//                        }
//                    }
                        if (!StringUtils.isEmpty(itemDto.getRegion())) {
                            if (!itemDto.getRegion().equals(terminalVo.getRegionCode())) {
//                                throw new RuntimeException("门店[" + importVo.getTerminalCode() + "]不属于区域[" + importVo.getRegion() + "]");
                                errorList.add("门店[" + importVo.getTerminalCode() + "]不属于区域[" + importVo.getRegion() + "]");
                            }
                        }
                        if (!StringUtils.isEmpty(importVo.getSystemCode())) {
                            if (!importVo.getSystemCode().equals(terminalVo.getCustomerRetailerCode())) {
//                                throw new RuntimeException("门店[" + importVo.getTerminalCode() + "]不属于零售商[" + importVo.getSystemCode() + "]");
                                errorList.add("门店[" + importVo.getTerminalCode() + "]不属于零售商[" + importVo.getSystemCode() + "]");
                            }
                        }
                        if (!StringUtils.isEmpty(itemDto.getAcStoreType())) {
                            if (!itemDto.getAcStoreType().equals(terminalVo.getTerminalTypeCode())) {
//                                throw new RuntimeException("门店[" + importVo.getTerminalCode() + "]AC门店类型不是[" + importVo.getAcStoreType() + "]");
                                errorList.add("门店[" + importVo.getTerminalCode() + "]AC门店类型不是[" + importVo.getAcStoreType() + "]");
                            }
                        }
                        itemDto.setTerminalName(terminalVo.getTerminalName());
                    }
                    if (StringUtils.isNotEmpty(importVo.getCustomerErpCode())) {
                        String customerCode = importVo.getCustomerErpCode() + importVo.getSalesInstitutionErpCode() + importVo.getDistributionChannelCode() + businessFormatCode;
                        CustomerVo customerVo = customerMap.get(customerCode);
                        if (null == customerVo) {
//                            throw new RuntimeException("客户[" + customerCode + "]有误");
                            errorList.add("客户[" + customerCode + "]有误");
                        }
                        itemDto.setCustomerCode(customerCode);
                        itemDto.setCustomerName(customerVo.getCustomerName());
                        itemDto.setCustomerErpCode(customerVo.getErpCode());
                    }


                    //品类
                    if (StringUtils.isNotEmpty(importVo.getProductCategoryCode())) {
                        String productLevelName = productCategoryMap.get(importVo.getProductCategoryCode());
                        if (StringUtils.isEmpty(productLevelName)) {
//                            throw new RuntimeException("品类[" + importVo.getProductCategoryCode() + "]有误");
                            errorList.add("品类[" + importVo.getProductCategoryCode() + "]有误");
                        }
                        itemDto.setProductCategoryName(productLevelName);
                    }

                    //品项
                    if (StringUtils.isNotEmpty(importVo.getProductItemCode())) {
                        String productLevelName = productItemMap.get(importVo.getProductItemCode());
                        if (StringUtils.isEmpty(productLevelName)) {
//                            throw new RuntimeException("品项[" + importVo.getProductItemCode() + "]有误");
                            errorList.add("品项[" + importVo.getProductItemCode() + "]有误");
                        }
                        itemDto.setProductItemName(productLevelName);
                    }

                    //品牌
                    if (StringUtils.isNotEmpty(importVo.getProductBrandCode())) {
                        String brandName = productBrandMap.get(importVo.getProductBrandCode());
                        if (StringUtils.isEmpty(brandName)) {
//                            throw new RuntimeException("品牌[" + importVo.getProductBrandCode() + "]有误");
                            errorList.add("品牌[" + importVo.getProductBrandCode() + "]有误");
                        }
                        itemDto.setProductBrandName(brandName);
                    }

                    //产品
                    if (StringUtils.isNotEmpty(importVo.getProductCode())) {
                        String[] codes = importVo.getProductCode().split(",");
                        LinkedList<String> allNames = new LinkedList<>();
                        for (String code : codes) {
                            ProductVo productVo = productMap.get(code);
                            if (null == productVo) {
//                                throw new RuntimeException("产品编码[" + importVo.getProductCode() + "]有误");
                                errorList.add("产品编码[" + importVo.getProductCode() + "]有误");
                            } else {
                                itemDto.setProductUnit(productVo.getBaseUnit());
                                allNames.add(productVo.getProductName());
                            }
                        }
                        itemDto.setProductName(String.join(",", allNames));
                    }

                    if (StringUtils.isNotEmpty(importVo.getContractCode())) {
                        ActivityContractVo activityContractVo = contractVoMap.get(importVo.getContractCode());
                        if (null == activityContractVo) {
//                            throw new RuntimeException("合同编码[" + importVo.getContractCode() + "]有误");
                            errorList.add("合同编码[" + importVo.getContractCode() + "]有误");
                        }
                        if (!ContractTypeEnum.SUPPLIER_CONTRACT.getCode().equals(activityContractVo.getContractType())) {
//                            throw new RuntimeException("合同[" + importVo.getContractCode() + "]不是供应商合同");
                            errorList.add("合同[" + importVo.getContractCode() + "]不是供应商合同");
                        }
                        if (StringUtils.isEmpty(activityContractVo.getSupplierCode())) {
//                            throw new RuntimeException("合同[" + importVo.getContractCode() + "]没有维护供应商");
                            errorList.add("合同[" + importVo.getContractCode() + "]没有维护供应商");
                        }
                        itemDto.setSupplierCode(activityContractVo.getSupplierCode());
                        itemDto.setSupplierName(activityContractVo.getSupplierName());
                    }

                    if (StringUtils.isNotEmpty(importVo.getMaterialCode())) {
                        PromotionMaterialVO promotionMaterialVO = promotionMaterialMap.get(importVo.getMaterialCode());
                        if (null == promotionMaterialVO) {
//                            throw new RuntimeException("物料编码[" + importVo.getMaterialCode() + "]有误");
                            errorList.add("物料编码[" + importVo.getMaterialCode() + "]有误");
                        } else {
                            itemDto.setMaterialName(promotionMaterialVO.getMaterialName());
                        }
                    }

                    if (StringUtils.isNotEmpty(importVo.getContractCode()) && StringUtils.isNotEmpty(importVo.getMaterialCode())) {
//                        Validate.notBlank(importVo.getMaterialQuantityStr(), "物料数量不能为空");
                        if (StringUtils.isEmpty(importVo.getMaterialQuantityStr())) {
                            errorList.add("物料数量不能为空");
                        }
                        //有合同，有物料，有物料数据，查含税价格
                        ActivityContractMaterialDto activityContractMaterialDto = new ActivityContractMaterialDto();
                        activityContractMaterialDto.setContractNo(importVo.getContractCode());
                        activityContractMaterialDto.setMaterialCode(importVo.getMaterialCode());
                        BigDecimal materialQuantity = null;
                        try {
                            materialQuantity = new BigDecimal(importVo.getMaterialQuantityStr());
                        } catch (Exception e) {
                            log.error("", e);
//                            throw new RuntimeException("物料数量[" + importVo.getMaterialQuantityStr() + "]格式有误!");
                            errorList.add("物料数量[" + importVo.getMaterialQuantityStr() + "]格式有误!");
                        }
                        activityContractMaterialDto.setMaterialQuantity(materialQuantity);
                        ActivityContractMaterialVo contractMaterialVo = activityContractSdkService.getActivityContractMaterial(activityContractMaterialDto);
                        if (null == contractMaterialVo) {
//                            throw new RuntimeException("未获取到合同[" + importVo.getContractCode() + "]物料[" + importVo.getMaterialCode() + "]数量[" + importVo.getMaterialQuantityStr() + "]匹配价格坎级");
                            errorList.add("未获取到合同[" + importVo.getContractCode() + "]物料[" + importVo.getMaterialCode() + "]数量[" + importVo.getMaterialQuantityStr() + "]匹配价格坎级");
                        } else if (null != contractMaterialVo.getMoney()) {
                            itemDto.setOriginalSupplyPriceStr(contractMaterialVo.getMoney().toString());
                        }
                    }

                    //金额校验
                    amountCheck(importVo, itemDto);

                    //单件申请费用
                    if (StringUtils.isNotEmpty(importVo.getSingleApplicationFeeStr())) {
                        try {
                            itemDto.setSingleApplicationFee(new BigDecimal(importVo.getSingleApplicationFeeStr()));
                        } catch (Exception e) {
                            log.error("", e);
//                            throw new IllegalArgumentException("单件申请费用金额格式异常[" + importVo.getSingleApplicationFeeStr() + "]");
                            errorList.add("单件申请费用金额格式异常[" + importVo.getSingleApplicationFeeStr() + "]");
                        }
                    }
                    //金额字符转化为数值放入对应字段
                    if (StringUtils.isNotEmpty(importVo.getPriceStr())) {
                        try {
                            itemDto.setPrice(new BigDecimal(importVo.getPriceStr()));
                        } catch (Exception e) {
                            log.error("", e);
//                            throw new RuntimeException("陈列单价格式有误");
                            errorList.add("陈列单价格式有误");
                        }
                    }
                    if (StringUtils.isNotEmpty(importVo.getDisplayQuantityStr())) {
                        try {
                            itemDto.setDisplayQuantity(new BigDecimal(importVo.getDisplayQuantityStr()));
                        } catch (Exception e) {
                            log.error("", e);
//                            throw new RuntimeException("陈列数量格式有误");
                            errorList.add("陈列数量格式有误");
                        }
                    }
                    if (StringUtils.isNotEmpty(importVo.getMonthlyPlannedQuantityStr())) {
                        try {
                            itemDto.setMonthlyPlannedQuantity(new BigDecimal(importVo.getMonthlyPlannedQuantityStr()));
                        } catch (Exception e) {
                            log.error("", e);
//                            throw new RuntimeException("月度计划量格式有误");
                            errorList.add("月度计划量格式有误");
                        }
                    }
                    if (StringUtils.isNotEmpty(importVo.getSystemBorneAmountStr())) {
                        try {
                            itemDto.setSystemBorneAmount(new BigDecimal(importVo.getSystemBorneAmountStr()).setScale(2, RoundingMode.HALF_UP));
                            itemDto.setSystemBorneAmountStr(itemDto.getSystemBorneAmount().toString());
                        } catch (Exception e) {
                            log.error("", e);
//                            throw new RuntimeException("自投费用格式有误");
                            errorList.add("自投费用格式有误");
                        }
                    }

                    List<ActivityPlanBudgetDto> budgetShares = Lists.newArrayList();
                    if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())) {
                        MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getHeadMonthBudgetCode());
                        if (null == monthBudgetVo) {
//                            throw new RuntimeException("总部费用预算编码" + importVo.getHeadMonthBudgetCode() + "有误");
                            errorList.add("总部费用预算编码" + importVo.getHeadMonthBudgetCode() + "未在重客垂直月度预算中查询到");
                        } else {
                            if (!FeeBelongEnum.HEAD.getCode().equals(monthBudgetVo.getFeeBelongCode())) {
//                            throw new RuntimeException("预算编码" + importVo.getHeadMonthBudgetCode() + "不是总部预算");
                                errorList.add("预算编码" + importVo.getHeadMonthBudgetCode() + "不是总部预算");
                            }
                            if (StringUtils.isNotEmpty(importVo.getRegion()) && StringUtils.isNotEmpty(importVo.getSystemCode())) {
                                if (StringUtils.isNotEmpty(monthBudgetVo.getRegionCode()) && StringUtils.isNotEmpty(monthBudgetVo.getSystemCode())) {
                                    if (!monthBudgetVo.getRegionCode().equals(importVo.getRegion()) && !monthBudgetVo.getSystemCode().equals(importVo.getSystemCode())) {
//                                    throw new RuntimeException("活动申请所属区域、零售商与预算[" + importVo.getHeadMonthBudgetCode() + "]所属区域、零售商不一致");
                                        errorList.add("活动申请所属区域、零售商与预算[" + importVo.getHeadMonthBudgetCode() + "]所属区域、零售商不一致");
                                    }
                                }
                            }
                            if (StringUtils.isNotEmpty(importVo.getRegion())) {
                                if (StringUtils.isNotEmpty(monthBudgetVo.getRegionCode())) {
                                    if (!monthBudgetVo.getRegionCode().equals(importVo.getRegion())) {
//                                    throw new RuntimeException("活动申请所属区域与预算[" + importVo.getHeadMonthBudgetCode() + "]所属区域不一致");
                                        errorList.add("活动申请所属区域与预算[" + importVo.getHeadMonthBudgetCode() + "]所属区域不一致");
                                    }
                                }

                            }
                            if (StringUtils.isNotEmpty(importVo.getSystemCode())) {
                                if (StringUtils.isNotEmpty(monthBudgetVo.getSystemCode())) {
                                    if (!monthBudgetVo.getSystemCode().equals(importVo.getSystemCode())) {
//                                    throw new RuntimeException("活动申请所属零售商与预算[" + importVo.getHeadMonthBudgetCode() + "]所属零售商不一致");
                                        errorList.add("活动申请所属零售商与预算[" + importVo.getHeadMonthBudgetCode() + "]所属零售商不一致");
                                    }
                                }
                            }
                        }

                        BigDecimal headFeeAmount = BigDecimal.ZERO;
//                        Validate.notBlank(importVo.getHeadFeeAmountStr(), "总部费用不能为空");
                        if (StringUtils.isEmpty(importVo.getHeadFeeAmountStr())) {
                            errorList.add("总部费用不能为空");
                        } else {
                            try {
                                headFeeAmount = new BigDecimal(importVo.getHeadFeeAmountStr()).setScale(2, RoundingMode.HALF_UP);
                                itemDto.setHeadFeeAmount(headFeeAmount);
                                itemDto.setHeadFeeAmountStr(headFeeAmount.toString());
                            } catch (Exception e) {
                                log.error("", e);
//                            throw new RuntimeException("总部费用" + importVo.getHeadFeeAmountStr() + "有误");
                                errorList.add("总部费用" + importVo.getHeadFeeAmountStr() + "有误");
                            }
                        }
                        if (Objects.nonNull(monthBudgetVo)) {
                            itemDto.setHeadBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                            itemDto.setHeadBudgetItemName(monthBudgetVo.getBudgetItemName());
                            ActivityPlanBudgetDto budgetDto = new ActivityPlanBudgetDto();
                            budgetDto.setMonthBudgetCode(monthBudgetVo.getMonthBudgetCode());
                            budgetDto.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                            budgetDto.setBudgetItemName(monthBudgetVo.getBudgetItemName());
                            budgetDto.setYearMonthLy(monthBudgetVo.getYearMonthLy());
                            budgetDto.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
                            budgetDto.setAccumulatedAvailableBalance(monthBudgetVo.getAccumulatedAvailableBalance());
                            budgetDto.setUseAmount(headFeeAmount);
                            budgetDto.setUseAmountStr(budgetDto.getUseAmount().toString());
                            budgetShares.add(budgetDto);
                            //垂直大区方案兑付明细编码不为空才校验总部预算的年月
                            if (StringUtils.isEmpty(itemDto.getSchemeForecastDetailCode())
                                    && !feeYearMonth.equals(monthBudgetVo.getYearMonthLy())) {
                                errorList.add("费用归属年月[" + feeYearMonth + "]与预算[" + monthBudgetVo.getMonthBudgetCode() + "]年月[" + monthBudgetVo.getYearMonthLy() + "]不一致");
                            }
                        }

                    }
                    if (StringUtils.isNotEmpty(importVo.getRegionAutomaticMonthBudgetCode())) {
                        MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getRegionAutomaticMonthBudgetCode());
                        if (null == monthBudgetVo) {
                            errorList.add("自投费用预算编码【" + importVo.getRegionAutomaticMonthBudgetCode() + "】未在重客垂直月度预算中查询到");
                        } else {
                            if (!FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(monthBudgetVo.getFeeBelongCode())) {
                                errorList.add("预算【" + importVo.getRegionAutomaticMonthBudgetCode() + "】未在重客垂直月度预算中查询到！");
                            }
                            if (StringUtils.isNotEmpty(importVo.getRegion()) && StringUtils.isNotEmpty(importVo.getSystemCode())) {
                                if (StringUtils.isNotEmpty(monthBudgetVo.getRegionCode()) && StringUtils.isNotEmpty(monthBudgetVo.getSystemCode())) {
                                    if (!monthBudgetVo.getRegionCode().equals(importVo.getRegion()) && !monthBudgetVo.getSystemCode().equals(importVo.getSystemCode())) {
                                        errorList.add("活动申请所属区域、零售商与预算[" + importVo.getRegionAutomaticMonthBudgetCode() + "]所属区域、零售商不一致");
                                    }
                                }
                            }
                            if (StringUtils.isNotEmpty(importVo.getRegion())) {
                                if (StringUtils.isNotEmpty(monthBudgetVo.getRegionCode())) {
                                    if (!monthBudgetVo.getRegionCode().equals(importVo.getRegion())) {
                                        errorList.add("活动申请所属区域与预算[" + importVo.getRegionAutomaticMonthBudgetCode() + "]所属区域不一致");
                                    }
                                }
                            }
                            if (StringUtils.isNotEmpty(importVo.getSystemCode())) {
                                if (StringUtils.isNotEmpty(monthBudgetVo.getSystemCode())) {
                                    if (!monthBudgetVo.getSystemCode().equals(importVo.getSystemCode())) {
                                        errorList.add("活动申请所属零售商与预算[" + importVo.getRegionAutomaticMonthBudgetCode() + "]所属零售商不一致");
                                    }
                                }
                            }
                            if (!feeYearMonth.equals(monthBudgetVo.getYearMonthLy())) {
                                errorList.add("费用归属年月[" + feeYearMonth + "]与预算[" + monthBudgetVo.getMonthBudgetCode() + "]年月[" + monthBudgetVo.getYearMonthLy() + "]不一致");
                            }
                            itemDto.setRegionAutomaticBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                            itemDto.setRegionAutomaticBudgetItemName(monthBudgetVo.getBudgetItemName());
//                    itemDto.setSelfInvestedBudgetItems(monthBudgetVo.getBudgetItemCode());
//                        Validate.notBlank(importVo.getRegionAutomaticFeeAmountStr(), "自投费用不能为空");
                            if (StringUtils.isEmpty(importVo.getRegionAutomaticFeeAmountStr())) {
                                errorList.add("自投费用不能为空");
                            }
                            BigDecimal regionAutomaticFeeAmount = BigDecimal.ZERO;
                            try {
                                regionAutomaticFeeAmount = new BigDecimal(importVo.getRegionAutomaticFeeAmountStr()).setScale(2, RoundingMode.HALF_UP);
                                itemDto.setRegionAutomaticFeeAmount(regionAutomaticFeeAmount);
                                itemDto.setRegionAutomaticFeeAmountStr(regionAutomaticFeeAmount.toString());
                            } catch (Exception e) {
                                log.error("", e);
                                errorList.add("自投费用" + importVo.getRegionAutomaticFeeAmountStr() + "有误");
                            }
                            ActivityPlanBudgetDto budgetDto = new ActivityPlanBudgetDto();
                            budgetDto.setMonthBudgetCode(monthBudgetVo.getMonthBudgetCode());
                            budgetDto.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                            budgetDto.setBudgetItemName(monthBudgetVo.getBudgetItemName());
                            budgetDto.setYearMonthLy(monthBudgetVo.getYearMonthLy());
                            budgetDto.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
                            budgetDto.setAccumulatedAvailableBalance(monthBudgetVo.getAccumulatedAvailableBalance());
                            budgetDto.setUseAmount(regionAutomaticFeeAmount);
                            budgetDto.setUseAmountStr(budgetDto.getUseAmount().toString());
                            budgetShares.add(budgetDto);
                        }

                    }
                    if (StringUtils.isNotEmpty(importVo.getRegionReferendumMonthBudgetCode())) {
                        MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getRegionReferendumMonthBudgetCode());
                        if (null == monthBudgetVo) {
                            errorList.add("公投费用预算编码" + importVo.getRegionReferendumMonthBudgetCode() + "未在重客垂直月度预算中查询到");
                        } else {
                            if (!FeeBelongEnum.REGION_REFERENDUM.getCode().equals(monthBudgetVo.getFeeBelongCode())) {
                                errorList.add("预算编码" + importVo.getRegionReferendumMonthBudgetCode() + "不是公投预算");
                            }
                            if (StringUtils.isNotEmpty(importVo.getRegion()) && StringUtils.isNotEmpty(importVo.getSystemCode())) {
                                if (StringUtils.isNotEmpty(monthBudgetVo.getRegionCode()) && StringUtils.isNotEmpty(monthBudgetVo.getSystemCode())) {
                                    if (!monthBudgetVo.getRegionCode().equals(importVo.getRegion()) && !monthBudgetVo.getSystemCode().equals(importVo.getSystemCode())) {
                                        errorList.add("活动申请所属区域、零售商与预算[" + importVo.getRegionReferendumMonthBudgetCode() + "]所属区域、零售商不一致");
                                    }
                                }
                            }
                            if (StringUtils.isNotEmpty(importVo.getRegion())) {
                                if (StringUtils.isNotEmpty(monthBudgetVo.getRegionCode())) {
                                    if (!monthBudgetVo.getRegionCode().equals(importVo.getRegion())) {
                                        errorList.add("活动申请所属区域与预算[" + importVo.getRegionReferendumMonthBudgetCode() + "]所属区域不一致");
                                    }
                                }
                            }
                            if (StringUtils.isNotEmpty(importVo.getSystemCode())) {
                                if (StringUtils.isNotEmpty(monthBudgetVo.getSystemCode())) {
                                    if (!monthBudgetVo.getSystemCode().equals(importVo.getSystemCode())) {
                                        errorList.add("活动申请所属零售商与预算[" + importVo.getRegionReferendumMonthBudgetCode() + "]所属零售商不一致");
                                    }
                                }
                            }
                            if (!feeYearMonth.equals(monthBudgetVo.getYearMonthLy())) {
                                errorList.add("费用归属年月与预算年月不一致");
                            }
                            itemDto.setRegionReferendumBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                            itemDto.setRegionReferendumBudgetItemName(monthBudgetVo.getBudgetItemName());
//                    itemDto.setReferendumBudgetItem(monthBudgetVo.getBudgetItemName());
//                        Validate.notBlank(importVo.getRegionReferendumFeeAmountStr(), "公投费用不能为空");
                            if (StringUtils.isEmpty(importVo.getRegionReferendumFeeAmountStr())) {
                                errorList.add("公投费用不能为空");
                            }
                            BigDecimal regionReferendumFeeAmount = BigDecimal.ZERO;
                            try {
                                regionReferendumFeeAmount = new BigDecimal(importVo.getRegionReferendumFeeAmountStr()).setScale(2, RoundingMode.HALF_UP);
                                itemDto.setRegionReferendumFeeAmount(regionReferendumFeeAmount);
                                itemDto.setRegionReferendumFeeAmountStr(regionReferendumFeeAmount.toString());
                            } catch (Exception e) {
                                log.error("", e);
                                errorList.add("公投费用" + importVo.getRegionReferendumFeeAmountStr() + "有误");
                            }
                            ActivityPlanBudgetDto budgetDto = new ActivityPlanBudgetDto();
                            budgetDto.setMonthBudgetCode(monthBudgetVo.getMonthBudgetCode());
                            budgetDto.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                            budgetDto.setBudgetItemName(monthBudgetVo.getBudgetItemName());
                            budgetDto.setYearMonthLy(monthBudgetVo.getYearMonthLy());
                            budgetDto.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
                            budgetDto.setAccumulatedAvailableBalance(monthBudgetVo.getAccumulatedAvailableBalance());
                            budgetDto.setUseAmount(regionReferendumFeeAmount);
                            budgetDto.setUseAmountStr(budgetDto.getUseAmount().toString());
                            budgetShares.add(budgetDto);
                        }
                    }
                    itemDto.setBudgetShares(budgetShares);

                    if (StringUtils.isNotEmpty(importVo.getSchemeForecastDetailCode())) {
                        ActivityPlanQuerySchemeForecastCashVo activityPlanQuerySchemeForecastCashVo = schemeForecastDetailMap.get(importVo.getSchemeForecastDetailCode());
                        if (null == activityPlanQuerySchemeForecastCashVo) {
                            errorList.add("大区兑付编码" + importVo.getSchemeForecastDetailCode() + "有误");
                        }
                        for (ActivityPlanBudgetDto budgetShare : budgetShares) {
                            budgetShare.setSchemeForecastDetailCode(importVo.getSchemeForecastDetailCode());
                        }
                    }

                    newList.add(itemDto);
                } catch (RuntimeException e) {
                    log.error("", e);
                    errorList.add(e.getMessage());
                } catch (Exception e) {
                    log.error(e.getMessage(), e);
                    errorList.add(e.getMessage());
                } finally {
                    key++;
                }
            }

            if (errorListMap.size() > 0) {
                log.error("===========================方案导入，错误信息" + JSON.toJSONString(errorListMap));
                for (Map.Entry<Integer, List<String>> entry : errorListMap.entrySet()) {
                    List<String> value = entry.getValue();
                    if (value.size() > 0) {
                        errorMap.put(entry.getKey(), String.join(" | ", value));
                    }
                }
            }

            if (errorMap.size() == 0 && !CollectionUtils.isEmpty(newList)) {
                activityPlanItemPageCacheHelper.importNewItem(String.valueOf(params.get("cacheKey")), newList);
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty(e.getMessage())) {
                errorMsg = "数据处理失败！";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return errorMap;
    }

    @Override
    public Class<ActivityPlanDY00000010ImportVo> findCrmExcelVoClass() {
        return ActivityPlanDY00000010ImportVo.class;
    }

    /**
     * 校验数字格式的字段不能超过两位小数
     */
    private void validateNumberScale(List<ActivityPlanItemDto> dtos, Map<Integer, List<String>> errorListMap, Map<String, String> templateDetailTitleMap) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanItemDto.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors)
                .collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));

        int key = 0;
        for (ActivityPlanItemDto dto : dtos) {
            List<String> errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
            validateNumberScale(dto, propertyMap, errorList, templateDetailTitleMap);
            key++;
        }
    }

    /**
     * 校验数字格式的字段不能超过两位小数
     */
    private void validateNumberScale(ActivityPlanItemDto t, Map<String, PropertyDescriptor> propertyMap, List<String> errorList, Map<String, String> fieldTitleMap) {
        for (Map.Entry<String, PropertyDescriptor> entry : propertyMap.entrySet()) {
            PropertyDescriptor propertyDescriptor = entry.getValue();
            if (!(propertyDescriptor.getPropertyType() == String.class)) {
                continue;
            }
            String fieldName = propertyDescriptor.getName();
            if (!fieldName.endsWith("Str")) {
                continue;
            }
            String originPropertyName = fieldName.substring(0, fieldName.indexOf("Str"));
            if (!propertyMap.containsKey(originPropertyName)) {
                //没有定义对应字符串属性就跳过
                continue;
            }
            Object propertyValueObj = null;
            try {
                propertyValueObj = propertyDescriptor.getReadMethod().invoke(t);
                if (null == propertyValueObj) {
                    continue;
                }
                String propertyValue = propertyValueObj.toString().trim();
                if (StringUtils.isEmpty(propertyValue)) {
                    continue;
                }
                PropertyDescriptor originPropertyDescriptor = propertyMap.get(originPropertyName);
                if (originPropertyDescriptor.getPropertyType() == Integer.class) {
                    Integer integer = Integer.valueOf(propertyValue);
                } else if (originPropertyDescriptor.getPropertyType() == BigDecimal.class) {
                    BigDecimal originValue = new BigDecimal(propertyValue);
                    if (originValue.compareTo(originValue.setScale(2, RoundingMode.UP)) != 0) {
                        throw new RuntimeException("不能超过两位小数");
                    }
                } else {
                    return;
                }
            } catch (IllegalAccessException | InvocationTargetException | NumberFormatException e) {
                log.error("属性[" + fieldName + "][" + propertyValueObj + "]转换失败");
                String fieldTitle = fieldName;
                if (null != fieldTitleMap && fieldTitleMap.containsKey(fieldName)) {
                    fieldTitle = fieldTitleMap.get(fieldName);
                }
                errorList.add("属性[" + fieldTitle + "][" + propertyValueObj + "]转换失败");
            } catch (RuntimeException e) {
                String fieldTitle = fieldName;
                if (null != fieldTitleMap && fieldTitleMap.containsKey(fieldName)) {
                    fieldTitle = fieldTitleMap.get(fieldName);
                }
                errorList.add("[" + fieldTitle + "]" + e.getMessage());
            }
        }
    }

    public void validateAndConvertDictData(Map<String, Map<String, String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc) {
        if (StringUtils.isEmpty(dictValue) || dictMap.isEmpty()) {
            return;
        }
        if (dictValue.contains(",")) {
            //数据字典多选处理
            String[] split = dictValue.split(",");
            List<String> form = Lists.newArrayList();
            Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
            for (String s : split) {
                String code = dictDataMap.get(s);
                if (StringUtils.isEmpty(code)) {
                    throw new RuntimeException(desc + "[" + code + "]有误");
                }
                form.add(code);
            }
            String dictCode = String.join(",", form);
            setMethod.accept(dictCode);
        } else {
            Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
            String dictCode = dictDataMap.get(dictValue);
            if (StringUtils.isEmpty(dictCode)) {
                throw new RuntimeException(desc + "[" + dictValue + "]有误");
            }
            setMethod.accept(dictCode);
        }
    }

    private void amountCheck(ActivityPlanItemDto importVo, ActivityPlanItemDto itemDto) {
        BigDecimal feeAmount = BigDecimal.ZERO;
        BigDecimal headFeeAmount = BigDecimal.ZERO;
        BigDecimal regionReferendumFeeAmount = BigDecimal.ZERO;
        BigDecimal regionAutomaticFeeAmount = BigDecimal.ZERO;

        if (StringUtils.isNotEmpty(importVo.getFeeAmountStr())) {
            try {
                feeAmount = new BigDecimal(importVo.getFeeAmountStr());
            } catch (Exception e) {
                log.error("", e);
                throw new IllegalArgumentException("我方承担金额格式异常");
            }
        }
        if (StringUtils.isNotEmpty(importVo.getHeadFeeAmountStr())) {
            try {
                headFeeAmount = new BigDecimal(importVo.getHeadFeeAmountStr());
            } catch (Exception e) {
                log.error("", e);
                throw new IllegalArgumentException("总部费用金额格式异常");
            }
        }
        if (StringUtils.isNotEmpty(importVo.getRegionReferendumFeeAmountStr())) {
            try {
                regionReferendumFeeAmount = new BigDecimal(importVo.getRegionReferendumFeeAmountStr());
            } catch (Exception e) {
                log.error("", e);
                throw new IllegalArgumentException("公投费用金额格式异常");
            }
        }
        if (StringUtils.isNotEmpty(importVo.getRegionAutomaticFeeAmountStr())) {
            try {
                regionAutomaticFeeAmount = new BigDecimal(importVo.getRegionAutomaticFeeAmountStr());
            } catch (Exception e) {
                log.error("", e);
                throw new IllegalArgumentException("自投费用金额格式异常");
            }
        }
        if (feeAmount.compareTo(headFeeAmount.add(regionReferendumFeeAmount).add(regionAutomaticFeeAmount)) != 0) {
            throw new IllegalArgumentException("我方承担金额与总部费用、公投费用、自投费用的和不匹配");
        }
//        期间促销金额=促销售价*期间促销件数
        if (StringUtils.isNotEmpty(importVo.getPromotionalPriceStr()) && StringUtils.isNotEmpty(importVo.getPeriodPromotionalNumberStr())) {
            try {
                BigDecimal promotionPriceTax = new BigDecimal(importVo.getPromotionPriceTaxStr());
                BigDecimal periodPromotionalNumber = new BigDecimal(importVo.getPeriodPromotionalNumberStr());
                itemDto.setPeriodPromotionalAmount(promotionPriceTax.multiply(periodPromotionalNumber));
                itemDto.setPeriodPromotionalAmountStr(itemDto.getPeriodPromotionalAmount().toString());
            } catch (Exception e) {
                log.error("", e);
                throw new IllegalArgumentException("期间促销金额计算有误!");
            }
        }
    }

    /**
     * 时间格式判断
     *
     * @param currentTime
     * @return
     */
    private boolean isFlag(String currentTime) {
        if (StringUtil.isEmpty(currentTime)) {
            return false;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        boolean flag = true;
        try {
            dtf.parse(currentTime);
        } catch (Exception e) {
            log.error("", e);
            flag = false;
        }
        return flag;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_ACTIVITY_PLAN_IMPORT_DY00000010";
    }

    @Override
    public String getTemplateName() {
        return "垂直通用导入模板";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_ACTIVITY_PLAN_VERTICAL_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-垂直活动方案明细导入";
    }
}
