package com.biz.crm.tpm.business.activity.plan.local.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.activity.plan.local.imports.vo.ActivityPlanItemImportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 活动方案明细导入服务-通用
 * @author wanghaojia
 * @date 2022/11/11 16:19
 */
@Slf4j
@Component
public class ActivityPlanImportsProcess implements ImportProcess<ActivityPlanItemImportVo> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, ActivityPlanItemImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        List<ActivityPlanItemImportVo> importVos = Lists.newArrayList(data.values());
        return null;
    }

    @Override
    public Class<ActivityPlanItemImportVo> findCrmExcelVoClass() {
        return ActivityPlanItemImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_ACTIVITY_PLAN_IMPORT_COMMON";
    }

    @Override
    public String getTemplateName() {
        return "TPM-活动方案明细导入-通用";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_ACTIVITY_PLAN_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-活动方案明细导入";
    }

}
