package com.biz.crm.tpm.business.activity.plan.local.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgRangeDto;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.plan.local.imports.vo.ActivityPlanItemDY00000008SupplyHeadImportVo;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author baokai
 * @date 2023/9/19 14:37
 */
@Slf4j
@Component
public class ActivityPlanItemDY00000008SupplyHeadImportsProcess implements ImportProcess<ActivityPlanItemDY00000008SupplyHeadImportVo> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityPlanItemPageCacheHelper activityPlanItemPageCacheHelper;

    @Autowired(required = false)
    private SupplierVoService supplierVoService;

    @Autowired(required = false)
    private ActivityTypeService activityTypeService;
    @Autowired(required = false)
    private ActivityFormService activityFormService;
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private MdmTerminalChannelVoService terminalChannelVoService;
    @Autowired(required = false)
    private ProductBrandService productBrandService;
    @Autowired(required = false)
    private ProductVoService productVoService;
    @Autowired(required = false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required = false)
    private DictDataVoService dictDataVoService;
    @Autowired(required = false)
    private AuditFormulaMainService auditFormulaMainService;
    @Autowired(required = false)
    private CustomerChannelVoService customerChannelVoService;

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, ActivityPlanItemDY00000008SupplyHeadImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            Object businessFormatCodeObj = params.get("businessFormatCode");
            if (null == businessFormatCodeObj) {
                throw new RuntimeException("业态有误！");
            }
            String businessFormatCode = String.valueOf(businessFormatCodeObj);


            List<ActivityPlanItemDY00000008SupplyHeadImportVo> importVos = Lists.newArrayList(data.values());

            Set<String> orgCodeSet = Sets.newHashSet();
            Set<String> activityTypeCodeSet = Sets.newHashSet();
            Set<String> activityFormCodeSet = Sets.newHashSet();
            Set<String> monthBudgetCodeSet = Sets.newHashSet();
            Set<String> terminalChannelSet = Sets.newHashSet();
            Set<String> productBrandCodeSet = Sets.newHashSet();
            Set<String> productLevelCodeSet = Sets.newHashSet();
            Set<String> productCodeSet = Sets.newHashSet();
            Set<String> salesOrgCodeSet = Sets.newHashSet();
            Set<String> salesInsErpCodeSet = Sets.newHashSet();
            Set<String> salesInsCodeSet = Sets.newHashSet();
            Set<String> supplierCodeSet = Sets.newHashSet();
            Set<String> materialCodeSet = Sets.newHashSet();
            Set<String> auditFormulaCodeSet = Sets.newHashSet();
            Set<String> cusChannelCodeSet = Sets.newHashSet();

            for (ActivityPlanItemDY00000008SupplyHeadImportVo importVo : importVos) {
                if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                    List<String> typeCodes = Arrays.asList(importVo.getActivityTypeCode().split(","));
                    activityTypeCodeSet.addAll(typeCodes);
                }
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())) {
                    List<String> formCodes = Arrays.asList(importVo.getActivityFormCode().split(","));
                    activityFormCodeSet.addAll(formCodes);
                }
                if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getHeadMonthBudgetCode());
                }

                if (StringUtils.isNotEmpty(importVo.getChannelCode())) {
                    cusChannelCodeSet.add(importVo.getChannelCode());
                }
                Validate.notBlank(importVo.getSalesInstitutionCode(), "销售机构编码不能为空");
                salesInsErpCodeSet.add(importVo.getSalesInstitutionCode());
                if (StringUtils.isNotEmpty(importVo.getActivityOrgCode())) {
                    Validate.notBlank(importVo.getChannelCode(), "渠道编码不能为空");
                    salesInsCodeSet.add(importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode());
                    salesOrgCodeSet.add(importVo.getActivityOrgCode());
                }
                if (StringUtils.isNotEmpty(importVo.getFirstChannelCode())) {
                    List<String> channelCodes = Arrays.asList(importVo.getFirstChannelCode().split(","));
                    terminalChannelSet.addAll(channelCodes);
                }
                if (StringUtils.isNotEmpty(importVo.getSecondChannelCode())) {
                    List<String> channelCodes = Arrays.asList(importVo.getSecondChannelCode().split(","));
                    terminalChannelSet.addAll(channelCodes);
                }
                if (StringUtils.isNotEmpty(importVo.getSupplierCode())) {
                    supplierCodeSet.add(importVo.getSupplierCode());

                }
                if (StringUtils.isNotEmpty(importVo.getAuditConditionCode())) {
                    auditFormulaCodeSet.add(importVo.getAuditConditionCode());
                }
            }

//            Map<String,String> salesOrgMap = Maps.newHashMap();
            Map<String, Map<String, SalesOrgVo>> salesMap = Maps.newHashMap();
            Map<String, SalesOrgVo> salesInsMap = Maps.newHashMap();
            Map<String, String> activityTypeMap = Maps.newHashMap();
            Map<String, String> activityFormMap = Maps.newHashMap();
            Map<String, MonthBudgetVo> monthBudgetMap = Maps.newHashMap();
            Map<String, String> terminalChannelMap = Maps.newHashMap();
            Map<String, SupplierVo> supplierMap = Maps.newHashMap();
            Map<String, AuditFormulaMainVo> auditFormulaMap = Maps.newHashMap();
            Map<String, CustomerChannelVo> cusChannelMap = Maps.newHashMap();
            Map<String,String> productBrandMap = Maps.newHashMap();
            Map<String,String> productLevelMap = Maps.newHashMap();
            Map<String, ProductVo> productMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(activityTypeCodeSet)) {
                List<ActivityTypeVo> activityTypeList = activityTypeService.findByCodes(Lists.newArrayList(activityTypeCodeSet));
                activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, ActivityTypeVo::getActivityTypeName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(activityFormCodeSet)) {
                List<String> activityFormCodeList = Lists.newArrayList(activityFormCodeSet);
                List<List<String>> activityFormCodeListBag = Lists.newArrayList();
                activityFormCodeListBag.add(activityFormCodeList);
                activityFormMap = activityFormService.findFormByCodes(activityFormCodeListBag);
            }
            if (!CollectionUtils.isEmpty(monthBudgetCodeSet)) {
                List<MonthBudgetVo> monthBudgetVos = monthBudgetService.listByCodes(Lists.newArrayList(monthBudgetCodeSet));
                monthBudgetMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(cusChannelCodeSet)) {
                List<CustomerChannelVo> channelVos = customerChannelVoService.findByCodes(new ArrayList<>(cusChannelCodeSet));
                if (!CollectionUtils.isEmpty(channelVos)) {
                    cusChannelMap = channelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity(), (o, n) -> n));
                }
            }
            if (!CollectionUtils.isEmpty(supplierCodeSet)){
                List<SupplierVo> supplierVos = supplierVoService.findBySupplierCodes(Lists.newArrayList(supplierCodeSet));
                supplierMap = supplierVos.stream().collect(Collectors.toMap(SupplierVo::getSupplierCode,Function.identity()));
            }
            if (!CollectionUtils.isEmpty(salesOrgCodeSet)) {
                SalesOrgRangeDto rangeDto = new SalesOrgRangeDto();
                rangeDto.setSalesInstitutionCodes(new ArrayList<>(salesInsCodeSet));
                rangeDto.setErpCodes(new ArrayList<>(salesOrgCodeSet));
                salesMap = salesOrgVoService.findMapBySalesOrgErpCodesAndInsCodes(rangeDto);
            }
            if (!CollectionUtils.isEmpty(salesInsErpCodeSet)) {
                List<SalesOrgVo> orgVos = salesOrgVoService.findByErpCodeList(new ArrayList<>(salesInsErpCodeSet));
                if (!CollectionUtils.isEmpty(orgVos)) {
                    salesInsMap = orgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (o, n) -> n));
                }
            }
            if (!CollectionUtils.isEmpty(terminalChannelSet)) {
                List<MdmTerminalChannelVo> mdmTerminalChannelVos = terminalChannelVoService.listByCodes(Lists.newArrayList(terminalChannelSet));
                terminalChannelMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode, MdmTerminalChannelVo::getTerminalChannelName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(productBrandCodeSet)) {
                List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(Lists.newArrayList(productBrandCodeSet));
                productBrandMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, ProductBrandVo::getProductBrandName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(productLevelCodeSet)) {
                List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByBusinessFormatAndCodes(businessFormatCode, Lists.newArrayList(productLevelCodeSet));
                productLevelMap = productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(productCodeSet)) {
                List<ProductVo> productVos = productVoService.findByCodes(Lists.newArrayList(productCodeSet));
                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o, n) -> n));
            }
//            if (!CollectionUtils.isEmpty(materialCodeSet)){
//                List<ProductVo> productVos = materialVoService.findDetailByMaterialCodes(materialCodeSet);
//                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode,Function.identity()));
//            }
            if (!CollectionUtils.isEmpty(supplierCodeSet)) {
                List<SupplierVo> supplierVos = supplierVoService.findBySupplierCodes(Lists.newArrayList(supplierCodeSet));
                supplierMap = supplierVos.stream().collect(Collectors.toMap(SupplierVo::getSupplierCode, Function.identity()));
            }
            if (!CollectionUtils.isEmpty(auditFormulaCodeSet)) {
                List<AuditFormulaMainVo> auditFormulaList = auditFormulaMainService.findByCodeList(Lists.newArrayList(auditFormulaCodeSet));
                if (!CollectionUtils.isEmpty(auditFormulaList)) {
                    auditFormulaMap = auditFormulaList.stream().collect(Collectors.toMap(AuditFormulaMainVo::getAuditFormulaCode, Function.identity(), (o, n) -> n));
                }
            }
            // 查询数据字典
            Map<String, List<DictDataVo>> dictDataMap = dictDataVoService.findByDictTypeCodeList(Arrays.asList(ActivityPlanConstant.DICT_TPM_AUDIT_TYPE));

            List<ActivityPlanItemDto> newList = Lists.newArrayList();
            for (ActivityPlanItemDY00000008SupplyHeadImportVo importVo : importVos) {
                ActivityPlanItemDto itemDto = nebulaToolkitService.copyObjectByWhiteList(importVo, ActivityPlanItemDto.class, HashSet.class, ArrayList.class);

                if (StringUtils.isNotEmpty(importVo.getActivityBeginDateStr())) {
                    Validate.isTrue(isFlag(importVo.getActivityBeginDateStr()), "活动开始时间格式错误！");
                }
                if (StringUtils.isNotEmpty(importVo.getActivityEndDateStr())) {
                    Validate.isTrue(isFlag(importVo.getActivityEndDateStr()), "活动结束时间格式错误！");
                }

                //活动分类
                if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                    String[] codes = importVo.getActivityTypeCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String activityTypeName = activityTypeMap.get(code);
                        if (StringUtils.isEmpty(activityTypeName)) {
                            throw new RuntimeException("活动分类[" + code + "]有误");
                        } else {
                            allNames.add(activityTypeName);
                        }
                    }
                    itemDto.setActivityTypeName(String.join(",", allNames));
                }

                //活动形式
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())) {
                    String[] codes = importVo.getActivityFormCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String activityFormName = activityFormMap.get(code);
                        if (StringUtils.isEmpty(activityFormName)) {
                            throw new RuntimeException("活动形式[" + code + "]有误");
                        } else {
                            allNames.add(activityFormName);
                        }
                    }
                    itemDto.setActivityForm(importVo.getActivityFormCode());
                    itemDto.setActivityFormName(String.join(",", allNames));
                }

                //分销渠道
                if (StringUtils.isNotEmpty(importVo.getChannelCode())) {
                    CustomerChannelVo channelVo = cusChannelMap.get(importVo.getChannelCode());
                    if (null == channelVo) {
                        throw new RuntimeException("渠道编码[" + importVo.getChannelCode() + "]有误");
                    }
                    itemDto.setDistributionChannelCode(channelVo.getCustomerChannelCode());
                    itemDto.setDistributionChannelName(channelVo.getCustomerChannelName());
                }
                //供应商
                if (StringUtils.isNotEmpty(importVo.getSupplierCode())) {
                    SupplierVo supplierVo = supplierMap.get(importVo.getSupplierCode());
                    if (null == supplierVo) {
                        throw new RuntimeException("供应商[" + importVo.getSupplierCode() + "]有误");
                    }
                    itemDto.setSupplierCode(supplierVo.getSupplierCode());
                    itemDto.setSupplierName(supplierVo.getSupplierName());
                }

                //销售机构
                if (StringUtils.isNotEmpty(importVo.getSalesInstitutionCode())) {
                    String insCode = importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode();
                    Validate.isTrue(salesInsMap.containsKey(insCode), "销售机构[" + importVo.getSalesInstitutionCode() + "]有误");
                    SalesOrgVo salesOrgVo = salesInsMap.get(insCode);
                    itemDto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                    itemDto.setSalesInstitutionCode(salesOrgVo.getSalesOrgCode());
                    itemDto.setSalesInstitutionErpCode(salesOrgVo.getErpCode());
                }

                //销售组织
                if (StringUtils.isNotEmpty(importVo.getActivityOrgCode())) {
                    String insCode = importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode();
                    Map<String, SalesOrgVo> salesOrgVoMap = salesMap.get(insCode);
                    if (salesOrgVoMap.isEmpty()) {
                        throw new RuntimeException("区域编码[" + importVo.getActivityOrgCode() + "]未在销售机构[" + importVo.getSalesInstitutionCode() + "]下");
                    }
                    SalesOrgVo salesOrgVo = salesOrgVoMap.get(importVo.getActivityOrgCode());
                    if (Objects.isNull(salesOrgVo)) {
                        throw new RuntimeException("区域编码[" + importVo.getActivityOrgCode() + "]未在销售机构[" + importVo.getSalesInstitutionCode() + "]下");
                    }
                    itemDto.setActivityOrgName(salesOrgVo.getSalesOrgName());
                    itemDto.setActivityOrgCode(salesOrgVo.getSalesOrgCode());
                    itemDto.setActivityOrgErpCode(salesOrgVo.getErpCode());
                }

                //一级渠道
                if (StringUtils.isNotEmpty(importVo.getFirstChannelCode())) {
                    String[] codes = importVo.getFirstChannelCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String terminalChannelName = terminalChannelMap.get(code);
                        if (StringUtils.isEmpty(terminalChannelName)) {
                            throw new RuntimeException("一级渠道[" + importVo.getFirstChannelCode() + "]有误");
                        }
                        allNames.add(terminalChannelName);
                    }
                    itemDto.setFirstChannelName(String.join(",", allNames));
                }

                //二级渠道
                if (StringUtils.isNotEmpty(importVo.getSecondChannelCode())) {
                    String[] codes = importVo.getSecondChannelCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String terminalChannelName = terminalChannelMap.get(code);
                        if (StringUtils.isEmpty(terminalChannelName)) {
                            throw new RuntimeException("二级渠道[" + importVo.getSecondChannelCode() + "]有误");
                        }
                        allNames.add(terminalChannelName);
                    }
                    itemDto.setSecondChannelName(String.join(",", allNames));
                }

                if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())) {
                    MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getHeadMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        throw new RuntimeException("总部费用预算编码" + importVo.getHeadMonthBudgetCode() + "有误");
                    }
                    itemDto.setHeadBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    itemDto.setHeadBudgetItemName(monthBudgetVo.getBudgetItemName());
                }

                if (StringUtils.isNotEmpty(importVo.getAuditType())) {
                    DictDataVo auditType = dictDataMap.get(ActivityPlanConstant.DICT_TPM_AUDIT_TYPE).stream().filter(e -> e.getDictValue().equals(importVo.getAuditType())).findFirst().orElse(null);
                    if (auditType == null) {
                        throw new IllegalArgumentException("核销类型【" + importVo.getAuditType() + "】错误，请检查！");
                    }
                    importVo.setAuditType(auditType.getDictCode());
                    if (TpmAuditTypeEnum.AUDITTYPE2.getValue().equals(auditType.getDictValue())) {
                        Validate.notBlank(importVo.getAuditConditionCode(), "核销条件编码必填！");
                        AuditFormulaMainVo auditFormula = auditFormulaMap.get(importVo.getAuditConditionCode());
                        if (auditFormula == null) {
                            throw new RuntimeException("核销条件[" + importVo.getAuditConditionCode() + "]有误");
                        }
                        itemDto.setAuditConditionName(auditFormula.getAuditFormulaName());
                    }
                }

                newList.add(itemDto);
            }

            activityPlanItemPageCacheHelper.importNewItem(String.valueOf(params.get("cacheKey")), newList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty(e.getMessage())) {
                errorMsg = "数据处理失败！";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return null;
    }

    /**
     * 时间格式判断
     *
     * @param currentTime
     * @return
     */
    private boolean isFlag(String currentTime) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        boolean flag = true;
        try {
            dtf.parse(currentTime);
        } catch (Exception e) {
            flag = false;
        }
        return flag;
    }
    @Override
    public Class<ActivityPlanItemDY00000008SupplyHeadImportVo> findCrmExcelVoClass() {
        return ActivityPlanItemDY00000008SupplyHeadImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_ACTIVITY_PLAN_IMPORT_SUPPLY_DY00000008_HEAD";
    }

    @Override
    public String getTemplateName() {
        return "供应商活动（主体_总部方案）";
    }
    @Override
    public String getBusinessCode() {
        return "TPM_ACTIVITY_PLAN_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-活动方案明细导入";
    }
}
