package com.biz.crm.tpm.business.activity.plan.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Description: 方案终端导入vo
 * @Author: dengwei
 * @Date: 2023/1/28 23:37
 * @Version: 1.0
 */
@Data
@CrmExcelImport(startRow = 1)
@ApiModel("方案终端导入vo")
public class ActivityItemTerminalImportVo extends CrmExcelVo {


    /**
     * 门店编码
     */
    @CrmExcelColumn(value = "* 门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @CrmExcelColumn(value = "* 门店名称")
    private String terminalName;

    @CrmExcelColumn(value = "标准")
    private BigDecimal standard;

    @CrmExcelColumn(value = "数量")
    private BigDecimal quantity;

    @CrmExcelColumn(value = "员工号")
    private String employeeCode;

    @CrmExcelColumn(value = "浮动率")
    private BigDecimal floatingRate;

    @CrmExcelColumn(value = "费用合计")
    private BigDecimal amount;

    @CrmExcelColumn("我方承担金额")
    private BigDecimal feeAmount;

    @CrmExcelColumn("系统承担金额")
    private BigDecimal systemBorneAmount;

}
