package com.biz.crm.tpm.business.activity.plan.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 促销方案导入模版（垂直）导入VO
 * @author wanghaojia
 * @date 2023/1/11 14:17
 */
@Data
@CrmExcelImport(startRow = 1)
@ApiModel("促销方案导入模版（垂直）导入VO")
public class ActivityPlanDY00000010PromotionImportVo extends CrmExcelVo {

    /**
     * 活动便签号
     */
    @CrmExcelColumn(value = "✳ 活动便签号")
    private String  activityNumber;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @CrmExcelColumn(value = "✳ 活动分类")
    private String activityTypeCode;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @CrmExcelColumn(value = "✳ 活动形式")
    private String activityFormCode;

    /**
     * 搭赠类型
     */
    @CrmExcelColumn("*搭赠类型")
    private String bonusType;

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    @CrmExcelColumn(value = "✳销售组织编码")
    private String activityOrgCode;
    /**
     * 销售组织
     */
    @ApiModelProperty("销售组织")
    @CrmExcelColumn(value = "销售组织")
    private String activityOrgName;
    /**
     * ✳区域
     */
    @ApiModelProperty("✳区域")
    @CrmExcelColumn(value = "✳区域")
    private String region;

    /**
     * ✳零售商编码
     */
    @ApiModelProperty("✳零售商编码")
    @CrmExcelColumn(value = "✳零售商编码")
    private String systemCode;

    /**
     * 零售商
     */
    @ApiModelProperty("零售商")
    @CrmExcelColumn(value = "零售商")
    private String systemName;
    /**
     * AC分仓编码
     */
    @ApiModelProperty("AC分仓编码")
    @CrmExcelColumn(value = "AC分仓")
    private String acWarehouseName;

    /**
     * AC门店类型
     */
    @CrmExcelColumn(value = "AC门店类型")
    private String acStoreType;

    /**
     * 一级营销渠道
     */
    @CrmExcelColumn(value = "一级营销渠道")
    private String firstChannelName;
    /**
     * 二级营销渠道
     */
    @CrmExcelColumn(value = "二级营销渠道")
    private String secondChannelName;
    /**
     * 核销方式
     */
    @CrmExcelColumn(value = "✳核销方式")
    private String writeOffMethod;

    /**
     * 品牌编码
     */
    @CrmExcelColumn("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @CrmExcelColumn("品牌")
    private String productBrandName;
    /**
     * 品类编码
     */
    @CrmExcelColumn("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @CrmExcelColumn("品类")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @CrmExcelColumn("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @CrmExcelColumn("品项")
    private String productItemName;

    /**
     * 本品编码
     */
    @CrmExcelColumn("本品编码")
    private String productCode;
    /**
     * 本品
     */
    @CrmExcelColumn("本品")
    private String productName;
    /**
     * 赠品编码
     */
    @CrmExcelColumn("赠品编码")
    private String giftCode;
    /**
     * 赠品
     */
    @CrmExcelColumn("赠品")
    private String giftName;

    /**
     * ✳活动开始时间
     */
    @CrmExcelColumn("✳活动开始时间")
    private String activityBeginDateStr;
    /**
     * ✳活动结束时间
     */
    @CrmExcelColumn("✳活动结束时间")
    private String activityEndDateStr;
    /**
     * ✳订单开始时间
     */
    @CrmExcelColumn("✳订单开始时间")
    private String orderBeginDateStr;
    /**
     * ✳订单结束时间
     */
    @CrmExcelColumn("✳订单结束时间")
    private String orderEndDateStr;
    /**
     * ✳费用所属年月
     */
    @CrmExcelColumn("费用所属年月")
    private String feeYearMonthStr;

    /**
     * 本品生产日期
     */
    @CrmExcelColumn("本品生产日期")
    private String thisProductProductionDateStr;
    /**
     * 赠品生产日期
     */
    @CrmExcelColumn("赠品生产日期")
    private String giftProductionDateStr;




    @CrmExcelColumn("本品税率")
    private String taxRateStr;

    /**
     * 原供价（本品）
     */
    @CrmExcelColumn("原供价（本品）")
    private String originalSupplyPriceStr;
    /**
     * 原供价（本品）
     */
    @CrmExcelColumn("原未税价格（本品）")
    private String originalPriceProductStr;
    /**
     * 原供价（赠品）
     */
    @CrmExcelColumn("原供价（赠品）")
    private String originalPriceGiftStr;

    @CrmExcelColumn("赠品税率")
    private String giftTaxRateStr;
    /**
     * 原未税价格（赠品）
     */
    @CrmExcelColumn("原未税价格（赠品）")
    private String originalTaxPriceGiftStr;

    /**
     * 促销含税供价
     */
    @CrmExcelColumn("促销含税供价")
    private String promotionPriceTaxStr;
    /**
     * 促销未税供价
     */
    @CrmExcelColumn("促销未税供价")
    private String promotionNonTaxPriceStr;
    /**
     * 零售价
     */
    @CrmExcelColumn("原售价")
    private String retailPriceStr;
    /**
     * 促销售价
     */
    @CrmExcelColumn("促销售价")
    private String promotionalPriceStr;

    /**
     * 促销售价
     */
    @CrmExcelColumn("本品数量（力度）")
    private String productQuantityStr;

    /**
     * 促销售价
     */
    @CrmExcelColumn("赠品数量（力度）")
    private String giftQuantityStr;

    /**
     * 原毛利率
     */
    @CrmExcelColumn("原毛利率")
    private String originalGrossRateStr;
    /**
     * 促销毛利率
     */
    @CrmExcelColumn("促销毛利率")
    private String promotionalGrossRateStr;


    /**
     * 单件申请费用
     */
    @CrmExcelColumn("✳单件申请费用")
    private String singleApplicationFeeStr;
    /**
     * 期间促销件数
     */
    @CrmExcelColumn("✳期间促销件数")
    private String periodPromotionalNumberStr;

    /**
     * 期间促销金额
     */
    @CrmExcelColumn("期间促销金额")
    private String periodPromotionalAmountStr;
    /**
     * 费用合计
     */
    @CrmExcelColumn("费用合计")
    private String totalFeeAmountStr;
    /**
     * 系统承担比例
     */
    @CrmExcelColumn("系统承担比例")
    private String systemAssumeRatiStr;
    /**
     * 系统承担金额
     */
    @CrmExcelColumn("系统承担金额")
    private String systemBorneAmountStr;

    /**
     * 我方承担比例
     */
    @CrmExcelColumn("我方承担比例")
    private String ourAssumeRatioStr;
    /**
     * 我方承担金额
     */
    @CrmExcelColumn("我方承担金额")
    private String feeAmountStr;
    /**
     * 总部费用预算编码
     */
    @CrmExcelColumn("总部费用预算编码")
    private String headMonthBudgetCode;
    /**
     * 公投费用预算编码
     */
    @CrmExcelColumn("公投费用预算编码")
    private String regionReferendumMonthBudgetCode;
   /**
     * 公投费用预算编码
     */
    @CrmExcelColumn("自投费用预算编码")
    private String regionAutomaticMonthBudgetCode;
   /**
     * 总部费用
     */
    @CrmExcelColumn("总部费用")
    private String headFeeAmountStr;
   /**
     * 公投费用
     */
    @CrmExcelColumn("公投费用")
    private String regionReferendumFeeAmountStr;
   /**
     * 自投费用
     */
    @CrmExcelColumn("自投费用")
    private String regionAutomaticFeeAmountStr;
   /**
     * 自投费用
     */
    @CrmExcelColumn("系统月计划量")
    private String systemMonthPlanQuantityStr;

    /**
     * 自投费用
     */
    @CrmExcelColumn("✳是否共用")
    private String publicOrNot;
    /**
     * 门店共用量
     */
    @CrmExcelColumn("门店共用量")
    private String storeUtilityStr;
    /**
     * 门店共用金额
     */
    @CrmExcelColumn("门店共用金额")
    private String storePublicAmountStr;
    /**
     * ✳浮动率
     */
    @CrmExcelColumn("✳浮动率")
    private String floatingRateStr;
    /**
     * 浮动量
     */
    @CrmExcelColumn("浮动量")
    private String floatingNumberStr;

    /**
     * 浮动量
     */
    @CrmExcelColumn("浮动金额")
    private String floatingAmountStr;

    /**
     * ✳结案形式
     */
    @CrmExcelColumn("✳结案形式")
    private String auditForm;

    /**
     * 活动形式说明
     */
    @CrmExcelColumn("活动形式说明")
    private String remark;

    /**
     * 活动描述
     */
    @CrmExcelColumn("活动描述")
    private String activityDesc;
    /**
     * 活动描述
     */
    @CrmExcelColumn("* 核销类型")
    private String auditType;
    /**
     * 核销条件编码
     */
    @CrmExcelColumn("核销条件编码")
    private String auditConditionCode;

    /**
     * 核销条件编码
     */
    @CrmExcelColumn("门店编码")
    private String terminalCode;
    /**
     * 核销条件编码
     */
    @CrmExcelColumn("门店名称")
    private String terminalName;

}
