package com.biz.crm.tpm.business.activity.plan.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 活动方案-主体-随车搭增导入VO
 *
 * @author wanghaojia
 * @date 2023/1/11 14:17
 */
@Data
@CrmExcelImport(startRow = 2)
@ApiModel("活动方案明细-主体-随车搭增导入VO")
public class ActivityPlanItemDY00000008DetailPlanCarItemImportVo extends CrmExcelVo {

    @ApiModelProperty("活动方案明细编码")
    @CrmExcelColumn(value = "* 活动方案明细编码")
    private String planItemCode;

    @CrmExcelColumn(value = "* 活动分类编码")
    private String activityTypeCode;


    @CrmExcelColumn(value = "活动分类")
    private String activityTypeName;

    @CrmExcelColumn(value = "* 活动形式编码")
    private String activityFormCode;

    @CrmExcelColumn(value = "活动形式")
    private String activityFormName;

    @CrmExcelColumn(value = "* 活动开始时间")
    private String activityBeginDateStr;

    @CrmExcelColumn(value = "* 活动结束时间")
    private String activityEndDateStr;

    @CrmExcelColumn(value = "* 订单开始日期")
    private String orderBeginDateStr;

    @CrmExcelColumn(value = "* 订单结束日期")
    private String orderEndDateStr;

    @CrmExcelColumn(value = "总部统筹预算编码")
    private String headMonthBudgetCode;

    @CrmExcelColumn(value = "总部统筹预算名称")
    private String headBudgetItemName;

    @ApiModelProperty("预算编码/大区预算编码")
    @CrmExcelColumn(value = "大区自控预算编码")
    private String monthBudgetCode;
    /**
     * 大区预算项目名称
     */
    @ApiModelProperty("大区预算项目名称")
    @CrmExcelColumn(value = "大区自控预算名称")
    private String budgetItemName;

    @CrmExcelColumn(value = "* 随车搭赠组合")
    private String carGiftGroup;

    @CrmExcelColumn(value = "* 销售机构编码")
    private String salesInstitutionCode;


    @CrmExcelColumn(value = "* 大区编码")
    private String salesRegionCode;

    @CrmExcelColumn(value = "大区名称")
    private String salesRegionName;

    @CrmExcelColumn(value = "省区编码")
    private String salesOrgCode;

    @CrmExcelColumn(value = "省区名称")
    private String salesOrgName;

    @CrmExcelColumn(value = "一级渠道编码")
    private String firstChannelCode;

    @CrmExcelColumn(value = "一级渠道名称")
    private String firstChannelName;

    @CrmExcelColumn(value = "二级渠道编码")
    private String secondChannelCode;

    @CrmExcelColumn(value = "二级渠道名称")
    private String secondChannelName;

    @CrmExcelColumn(value = "分销渠道编码")
    private String distributionChannelCode;

    @CrmExcelColumn(value = "客户组编码")
    private String customerGroupCode;
    @CrmExcelColumn(value = "客户组名称")
    private String customerGroupName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @CrmExcelColumn(value = "* 客户编码")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @CrmExcelColumn(value = "客户名称")
    private String customerName;

    @CrmExcelColumn(value = "* 促销对象")
    private String promotionObject;

    @CrmExcelColumn(value = "* 促销类型")
    private String promotionType;

    @CrmExcelColumn(value = "品牌编码")
    private String productBrandCode;

    @CrmExcelColumn(value = "品牌")
    private String productBrandName;

    @CrmExcelColumn(value = "品类编码")
    private String productCategoryCode;

    @CrmExcelColumn(value = "品类")
    private String productCategoryName;

    @CrmExcelColumn(value = "品项编码")
    private String productItemCode;

    @CrmExcelColumn(value = "品项")
    private String productItemName;

    @CrmExcelColumn(value = "* 产品编码")
    private String productCode;

    @CrmExcelColumn(value = "产品名称")
    private String productName;

    @CrmExcelColumn(value = "单位")
    private String productUnit;

    @CrmExcelColumn(value = "产品价格")
    private String productPriceStr;

    @CrmExcelColumn(value = "* 赠品编码")
    private String giftCode;

    @CrmExcelColumn(value = "赠品名称")
    private String giftName;

    @CrmExcelColumn(value = "赠品单位")
    private String giftUnit;

    @CrmExcelColumn(value = "* 本品数量")
    private String productQuantityStr;

    @CrmExcelColumn(value = "* 赠品数量")
    private String giftQuantityStr;

    @CrmExcelColumn(value = "* 费用合计（元）")
    private String totalFeeAmountStr;

    @CrmExcelColumn(value = " 总部承担金额（元）")
    private String headFeeAmountStr;

    @CrmExcelColumn(value = "大区承担金额（元）")
    private String departmentFeeAmountStr;

    @CrmExcelColumn(value = "客户承担金额（元）")
    private String customerFeeAmountStr;

    @CrmExcelColumn(value = "形式说明")
    private String activityDesc;

    @CrmExcelColumn(value = "* 预估销售额")
    @ApiModelProperty(name = "salesAmount",notes = "预估销售额", value= "预估销售额")
    private String salesAmountStr;


    @CrmExcelColumn(value = "* 核销类型")
    private String auditType;

    @CrmExcelColumn(value = "核销条件编码")
    private String auditConditionCode;

    @CrmExcelColumn(value = "大区策略明细编码")
    private String relateStrategyItemCode;

    @CrmExcelColumn(value = "总部策略明细编码")
    private String relateHeadStrategyItemCode;

    @CrmExcelColumn(value = "总部方案明细编码")
    private String relatePlanItemCode;

}
