package com.biz.crm.tpm.business.activity.plan.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 活动方案明细导入
 * @author wanghaojia
 * @date 2023/1/11 14:17
 */
@Data
@CrmExcelImport(startRow = 2)
@ApiModel("活动方案明细-主体-总部导入VO")
public class ActivityPlanItemDY00000008HeadImportVo extends CrmExcelVo {

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @CrmExcelColumn(value = "* 活动分类编码")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @CrmExcelColumn(value = "活动分类名称")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @CrmExcelColumn(value = "* 活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn(value = "活动形式名称")
    private String activityFormName;


    /**
     * 活动开始时间-字符串，前端用
     */
    @ApiModelProperty("活动开始时间-字符串，前端用")
    @CrmExcelColumn(value = "* 活动开始时间")
    private String activityBeginDateStr;

    /**
     * 活动结束时间-字符串，前端用
     */
    @ApiModelProperty("活动结束时间-字符串，前端用")
    @CrmExcelColumn(value = "* 活动结束时间")
    private String activityEndDateStr;


    /**
     * 订单开始时间-字符串，前端用
     */
    @ApiModelProperty("订单开始时间-字符串，前端用")
    @CrmExcelColumn(value = "订单开始日期")
    private String orderBeginDateStr;
    /**
     * 订单结束时间-字符串，前端用
     */
    @ApiModelProperty("订单结束时间-字符串，前端用")
    @CrmExcelColumn(value = "订单结束日期")
    private String orderEndDateStr;


    /**
     * 总部预算编码
     */
    @ApiModelProperty("总部统筹预算编码")
    @CrmExcelColumn(value = "总部统筹预算编码")
    private String headMonthBudgetCode;
    /**
     * 总部预算项目编码
     */
    @ApiModelProperty("总部预算项目编码")
    @CrmExcelColumn(value = "总部统筹预算项目名称")
    private String headBudgetItemCode;


    /**
     * 一级管理渠道
     */
    @ApiModelProperty("* 一级渠道编码")
    @CrmExcelColumn(value = "* 一级渠道编码")
    private String firstChannelCode;
    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级渠道名称")
    @CrmExcelColumn(value = "一级渠道名称")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    @CrmExcelColumn(value = "二级渠道编码")
    private String secondChannelCode;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    @CrmExcelColumn(value = "二级渠道名称")
    private String secondChannelName;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    @CrmExcelColumn(value = "* 渠道编码")
    private String channelCode;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @CrmExcelColumn(value = "* 销售机构编码")
    private String salesInstitutionCode;

    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    @CrmExcelColumn(value = "* 区域编码")
    private String activityOrgCode;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    @CrmExcelColumn(value = "区域名称")
    private String activityOrgName;

    /**
     * ✳零售商编码
     */
    @ApiModelProperty("零售商编码")
    @CrmExcelColumn(value = "零售商编码")
    private String systemCode;

    /**
     * 零售商
     */
    @ApiModelProperty("零售商名称")
    @CrmExcelColumn(value = "零售商名称")
    private String systemName;

    /**
     * 促销对象
     */
    @ApiModelProperty("促销对象")
    @CrmExcelColumn(value = "* 促销对象")
    private String promotionObject;

    /**
     * 促销类型
     */
    @ApiModelProperty("促销类型")
    @CrmExcelColumn(value = "促销类型")
    private String promotionType;



    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @CrmExcelColumn(value = "品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @CrmExcelColumn(value = "品牌")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    @CrmExcelColumn(value = "品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @CrmExcelColumn(value = "品类")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @CrmExcelColumn(value = "品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @CrmExcelColumn(value = "品项")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @CrmExcelColumn(value = "产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @CrmExcelColumn(value = "产品")
    private String productName;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    @CrmExcelColumn(value = "单位")
    private String productUnit;

    /**
     * 品项组价格-字符串，前端用
     */
    @ApiModelProperty("品项组价格-字符串，前端用")
    @CrmExcelColumn(value = "产品价格")
    private String productItemPriceStr;

    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    @CrmExcelColumn(value = "供应商编码")
    private String supplierCode;
    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    @CrmExcelColumn(value = "供应商名称")
    private String supplierName;

    /**
     * 物料编码
     */
    @ApiModelProperty("物料编码")
    @CrmExcelColumn(value = "物料编码")
    private String materialCode;
    /**
     * 物料名称
     */
    @ApiModelProperty("物料名称")
    @CrmExcelColumn(value = "物料名称")
    private String materialName;

    /**
     * 数量-字符串，前端用
     */
    @ApiModelProperty("数量-字符串，前端用")
    @CrmExcelColumn(value = "数量")
    private String quantityStr;


    /**
     * 单价-字符串，前端用
     */
    @ApiModelProperty("单价-字符串，前端用")
    @CrmExcelColumn(value = "单价")
    private String priceStr;

    /**
     * 费用合计-字符串，前端用
     */
    @ApiModelProperty("费用合计-字符串，前端用")
    @CrmExcelColumn(value = "* 费用总金额（元）")
    private String totalFeeAmountStr;
    /**
     * 总部承担金额-字符串，前端用
     */
    @ApiModelProperty("总部承担金额-字符串，前端用")
    @CrmExcelColumn(value = "* 总部承担金额（元）")
    private String headFeeAmountStr;


    /**
     * 大区承担金额-字符串，前端用
     */
    @ApiModelProperty("大区承担金额-字符串，前端用")
    @CrmExcelColumn(value = "大区承担金额（元）")
    private String departmentFeeAmountStr;

    /**
     * 客户承担金额-字符串，前端用
     */
    @ApiModelProperty("客户承担金额-字符串，前端用")
    @CrmExcelColumn(value = "客户承担金额（元）")
    private String customerFeeAmountStr;


    /**
     * 预估销售额-字符串，前端用
     */
    @ApiModelProperty("预估销售额-字符串，前端用")
    @CrmExcelColumn(value = "* 预估销售额")
    private String salesAmountStr;

    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    @CrmExcelColumn(value = "* 核销类型")
    private String auditType;

    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    @CrmExcelColumn(value = "* 核销条件编码")
    private String auditConditionCode;

    @CrmExcelColumn(value = "策略明细编码")
    private String relateHeadStrategyItemCode;


}
