package com.biz.crm.tpm.business.activity.plan.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author baokai
 * @date 2023/9/18 15:53
 */
@Data
@CrmExcelImport(startRow = 2)
@ApiModel("供应商活动-主体-大区导入VO")
public class ActivityPlanItemDY00000008SupplyRegionImportVo extends CrmExcelVo {

    @CrmExcelColumn(value = "* 活动分类编码")
    private String activityTypeCode;

    @CrmExcelColumn(value = "活动分类")
    private String activityTypeName;

    @CrmExcelColumn(value = "* 活动形式编码")
    private String activityFormCode;

    @CrmExcelColumn(value = "活动形式")
    private String activityFormName;

    @CrmExcelColumn(value = "* 活动开始时间")
    private String activityBeginDateStr;

    @CrmExcelColumn(value = "* 活动结束时间")
    private String activityEndDateStr;

    @CrmExcelColumn(value = "总部统筹预算编码")
    private String headMonthBudgetCode;

    @CrmExcelColumn(value = "总部统筹预算项目名称")
    private String headBudgetItemName;

    /**
     * 大区自控预算编码
     */
    @ApiModelProperty("大区自控预算编码")
    @CrmExcelColumn(value = "大区自控预算编码")
    private String monthBudgetCode;

    /**
     * 大区自控预算编码
     */
    @ApiModelProperty("大区自控预算编码")
    @CrmExcelColumn(value = "大区自控预算名称")
    private String monthBudgetName;

    @CrmExcelColumn(value = "* 渠道编码")
    private String distributionChannelCode;

    @CrmExcelColumn(value = "* 销售机构编码")
    private String salesInstitutionCode;

    @CrmExcelColumn(value = "* 大区编码")
    private String salesRegionCode;

    @CrmExcelColumn(value = "大区名称")
    private String salesRegionName;

    @CrmExcelColumn(value = "省区编码")
    private String salesOrgCode;

    @CrmExcelColumn(value = "省区名称")
    private String salesOrgName;


    @CrmExcelColumn(value = "* 一级渠道编码")
    private String firstChannelCode;

    @CrmExcelColumn(value = "一级渠道名称")
    private String firstChannelName;

    @CrmExcelColumn(value = "二级渠道编码")
    private String secondChannelCode;

    @CrmExcelColumn(value = "二级渠道名称")
    private String secondChannelName;

    @ApiModelProperty("* 客户编码")
    @CrmExcelColumn(value = "* 客户编码")
    private String customerCode;

    @ApiModelProperty("* 客户编码")
    @CrmExcelColumn(value = "客户名称")
    private String customerName;

    @CrmExcelColumn(value = "* 促销对象")
    private String promotionObject;

    @CrmExcelColumn(value = "* 供应商编码")
    private String supplierCode;

    @CrmExcelColumn(value = "供应商名称")
    private String supplierName;

    @CrmExcelColumn(value = "个税金额(元）")
    private String personalIncomeTaxStr;

    @CrmExcelColumn(value = "* 费用总金额（元）")
    private String totalFeeAmountStr;

    @CrmExcelColumn(value = "* 总部承担金额（元）")
    private String headFeeAmountStr;

    @CrmExcelColumn("大区承担金额（元）")
    private String departmentFeeAmountStr;

    @CrmExcelColumn("客户承担金额（元）")
    private String customerFeeAmountStr;

    @CrmExcelColumn(value = "* 是否扣减费用池")
    private String isDeductionFeePool;

    @CrmExcelColumn(value = "* 核销类型")
    private String auditType;

    @CrmExcelColumn(value = "核销条件编码")
    private String auditConditionCode;

    @CrmExcelColumn(value = "大区策略明细编码")
    private String relateStrategyItemCode;

    @CrmExcelColumn(value = "总部策略明细编码")
    private String relateHeadStrategyItemCode;

    @CrmExcelColumn(value = "总部方案明细编码")
    private String relatePlanItemCode;

}
