package com.biz.crm.tpm.business.activity.plan.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName ActivityPlanItemDY00000010DisplayImportVo
 * @Description
 * @Author: jiangyin
 * @Date 2023/1/30
 */
@Data
@CrmExcelImport(startRow = 1)
@ApiModel("陈列方案导入模版（垂直）导入VO")
public class ActivityPlanItemDY00000010DisplayImportVo extends CrmExcelVo {

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码编码")
    @CrmExcelColumn(value = "✳ 活动分类编码")
    private String activityTypeCode;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型名称")
    @CrmExcelColumn(value = "✳ 活动分类名称")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @CrmExcelColumn(value = "✳ 活动形式编码")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn(value = "✳ 活动形式名称")
    private String activityFormName;

    /**
     * 购买方式
     */
    @ApiModelProperty("购买方式")
    @CrmExcelColumn(value = "✳ 购买方式")
    private String buyWay;

    /**
     * ✳活动开始时间
     */
    @CrmExcelColumn("✳活动开始时间")
    private String activityBeginDateStr;
    /**
     * ✳活动结束时间
     */
    @CrmExcelColumn("✳活动结束时间")
    private String activityEndDateStr;

    /**
     * 费用归属年月
     */
    @ApiModelProperty("费用归属年月")
    @CrmExcelColumn(value = "费用归属年月")
    private String feeBelongYearMonth;
    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    @CrmExcelColumn(value = "销售组织编码")
    private String activityOrgCode;
    /**
     * 销售组织
     */
    @ApiModelProperty("销售组织")
    @CrmExcelColumn(value = "销售组织")
    private String activityOrgName;
    /**
     * ✳区域
     */
    @ApiModelProperty("✳区域")
    @CrmExcelColumn(value = "✳区域")
    private String region;

    /**
     * 零售商
     */
    @ApiModelProperty("零售商")
    @CrmExcelColumn(value = "零售商")
    private String systemCode;

    /**
     * ✳零售商名称
     */
    @ApiModelProperty("✳零售商名称")
    @CrmExcelColumn(value = "✳零售商名称")
    private String systemName;

    @CrmExcelColumn(value = "城市等级")
    private String cityLevel;

    /**
     * AC门店类型
     */
    @CrmExcelColumn(value = "AC门店类型")
    private String acStoreType;

    @CrmExcelColumn(value = "门店编码")
    private String terminalCode;

    @CrmExcelColumn(value = "门店名称")
    private String terminalName;

    /**
     * 品牌编码
     */
    @CrmExcelColumn("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @CrmExcelColumn("品牌")
    private String productBrandName;
    /**
     * 品类编码
     */
    @CrmExcelColumn("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @CrmExcelColumn("品类")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @CrmExcelColumn("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @CrmExcelColumn("品项")
    private String productItemName;

    /**
     * 本品编码
     */
    @CrmExcelColumn("本品编码")
    private String productCode;
    /**
     * 本品
     */
    @CrmExcelColumn("本品")
    private String productName;
    /**
     * 陈列单价
     */
    @CrmExcelColumn("*陈列单价")
    private String priceStr;
    /**
     * 陈列数量
     */
    @CrmExcelColumn("*陈列数量")
    private String displayQuantityStr;

    /**
     * 费用合计
     */
    @CrmExcelColumn("费用合计")
    private String totalFeeAmountStr;

    /**
     * 系统承担金额
     */
    @CrmExcelColumn("系统承担金额")
    private String systemBorneAmountStr;
    /**
     * 我方承担金额
     */
    @CrmExcelColumn("我方承担金额")
    private String feeAmountStr;
    /**
     * 总部费用预算编码
     */
    @CrmExcelColumn("总部费用预算编码")
    private String headMonthBudgetCode;
    /**
     * 公投费用预算编码
     */
    @CrmExcelColumn("公投费用预算编码")
    private String regionReferendumMonthBudgetCode;
    /**
     * 公投费用预算编码
     */
    @CrmExcelColumn("自投费用预算编码")
    private String regionAutomaticMonthBudgetCode;
    /**
     * 总部费用
     */
    @CrmExcelColumn("总部费用")
    private String headFeeAmountStr;
    /**
     * 公投费用
     */
    @CrmExcelColumn("公投费用")
    private String regionReferendumFeeAmountStr;
    /**
     * 自投费用
     */
    @CrmExcelColumn("自投费用")
    private String regionAutomaticFeeAmountStr;
    /**
     * 月度计划量
     */
    @CrmExcelColumn("月度计划量")
    private String monthlyPlannedQuantityStr;
    /**
     * 投产比
     */
    @CrmExcelColumn("投产比")
    private String productionRatioStr;
    /**
     * ✳结案形式
     */
    @CrmExcelColumn("✳结案形式")
    private String auditForm;
    /**
     * 活动描述
     */
    @CrmExcelColumn("活动描述")
    private String activityDesc;
    /**
     * 是否档期
     */
    @CrmExcelColumn("是否档期")
    private String onScheduleOrNot;
    /**
     * 档期开始日期
     */
    @CrmExcelColumn("档期开始日期")
    private String scheduleBeginDateStr;
    /**
     * 档期结束日期
     */
    @CrmExcelColumn("档期结束日期")
    private String scheduleEndDateStr;
    /**
     * 活动描述
     */
    @CrmExcelColumn("* 核销类型")
    private String auditType;
    /**
     * 核销条件编码
     */
    @CrmExcelColumn("核销条件编码")
    private String auditConditionCode;
    /**
     * 申请金额
     */
    @CrmExcelColumn("申请金额")
    private String applyAmountStr;
    /**
     * 核销条件编码
     */
    @CrmExcelColumn("手续费点数")
    private String commissionPointStr;
    /**
     * 核销条件编码
     */
    @CrmExcelColumn("手续费金额")
    private String commissionAmountStr;

}
