package com.biz.crm.tpm.business.activity.plan.local.job;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanModifyService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 * 垂直活动方案人员变更任务
 * @author wanghaojia
 * @date 2023/4/23 11:18
 */
@Slf4j
@RestController
public class ActivityPlanVerticalPersonUpdateJob {

    @Autowired(required = false)
    private ActivityPlanModifyService activityPlanModifyService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * redis服务
     */
    @Autowired(required = false)
    private RedisLockService redisLockService;

    /**
     * 垂直促销人员变更更新活动方案任务
     */
    @PostMapping(value = "verticalPersonUpdateJob")
    @DynamicTaskService(cornExpression = "0 0 2 * * ?", taskDesc = "垂直促销人员变更更新活动方案任务")
    public void verticalPersonUpdateJob() {
        boolean hasLock = false;
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        String key = ActivityPlanConstant.LOCK_PERSON_UPDATE_ACTIVITY_PLAN + sdf.format(date);
        try {
            hasLock = redisLockService.tryLock(key, TimeUnit.MINUTES, 30);
            if (!hasLock) {
                return;
            }
            log.info("=====>    垂直促销人员变更更新活动方案任务[{}] start    <=====", DateUtil.dateStrNowAll());
            loginUserService.refreshAuthentication(null);
            activityPlanModifyService.verticalPersonUpdateJob();
            log.info("=====>    垂直促销人员变更更新活动方案任务[{}] end    <=====", DateUtil.dateStrNowAll());
        }finally {
            redisLockService.unlock(key);
        }
    }

}
