package com.biz.crm.tpm.business.activity.plan.local.listener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.rocketmq.event.RocketMqProducerEvent;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanPassMqTagEnum;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

/**
 * 活动方案审批通过回调
 * @author wanghaojia
 * @date 2022/11/30 20:57
 */
@Component
public class ActivityPlanProcessCompleteListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private ActivityPlanService activityPlanService;
    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;


    @Resource
    private ApplicationEventPublisher eventPublisher;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Override
    public String getBusinessCode() {
        return ActivityPlanConstant.PROCESS_NAME_ACTIVITY_PLAN;
    }

    @Override
    public void onProcessComplete(ProcessStatusDto dto) {
        if (StringUtils.isEmpty(dto.getBusinessNo())){
            return;
        }
        //多策略提交
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");
        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            activityPlanService.processPass(dto);
            this.passPushMq(dto.getProcessNo(),dto.getBusinessNoList());
        }
        //审批驳回|流程追回
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) ||
                ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            activityPlanService.processRejectAndRecover(dto);
        }
    }

    /**
     * 审批通过推送mq处理
     * @param processNo 流程编号
     * @param businessNoList 业务编码集合
     */
    private void passPushMq(String processNo,List<String> businessNoList){
        if (CollectionUtils.isEmpty(businessNoList)){
            return;
        }

        String uuid = UUID.randomUUID().toString().replace("-", "");
        String accountJson = "";
        String currentAccount = "";
        if (loginUserService != null) {
            currentAccount = loginUserService.getLoginAccountName();
            AbstractCrmUserIdentity userIdentity = loginUserService.getAbstractLoginUser();
            accountJson = Objects.isNull(userIdentity) ? null : JSON.toJSONString(userIdentity);
        }
        for (ActivityPlanPassMqTagEnum mqTagEnum : ActivityPlanPassMqTagEnum.values()) {
            RocketMqProducerEvent rocketMqProducerEvent = new RocketMqProducerEvent(this, currentAccount,  accountJson,
                    false,uuid,
                    ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment(),
                    mqTagEnum.getCode(),JSON.toJSONString(businessNoList));
            eventPublisher.publishEvent(rocketMqProducerEvent);
        }
    }

}
