package com.biz.crm.tpm.business.activity.plan.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.StrategyActivityPlanItemVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.annotations.Param;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/**
 * 活动方案表-大区方案关联总部方案(ActivityPlanStrategy)表mybatis访问层
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:57
 */
public interface ActivityPlanBudgetMapper extends BaseMapper<ActivityPlanBudget> {

    /**
     * 查询方案预算
     * @param planCode 方案编码
     */
    List<ActivityPlanBudgetDto> listDtoListByPlanCode(@Param("planCode") String planCode);

    List<ActivityPlanBudget> listByOperateCodeList(@Param("operateCodeList") List<String> operateCodeList);

    LinkedList<ActivityPlanBudget> listByOperateCodeListVertical(@Param("operateCodeList") List<String> operateCodeList);

    /**
     * 客户预算
     */
    List<ActivityPlanBudget> listCustomerBudgetByPlanItemCodeList(@Param("planItemCodeList") List<String> planItemCodeList);

    /**
     * 分页查询方案关联预算数据
     * @param page 分页参数
     * @param dto 查询参数
     * @return 方案关联预算数据
     */
    Page<ActivityPlanBudgetVo> findConditions(@Param("page") Page<MarketingStrategyBudgetVo> page, @Param("dto") ActivityPlanBudgetDto dto);

    /**
     * 查询关闭需要退回的预算
     */
    List<ActivityPlanBudget> findCarGiftCloseReturnBudgetList(@Param("planItemCodeList") List<String> planItemCodeList);

    /**
     * 查询未关闭的方案明细编码（无大区方案关联，或已关联的方案完全关闭）
     *
     * @param itemNos 方案明细编码
     * @param tenantCode 租户编码
     * @return List<String>
     **/
    List<String> getNoClosePlanItemNo(@Param("itemNos") List<String> itemNos,@Param("tenantCode") String tenantCode);

    List<ActivityPlanBudgetVo> findByPlanItemCode(@Param("codeSet") Set<String> codeSet,@Param("tenantCode") String tenantCode);

    List<ActivityPlanBudgetVo> findByPlanCode(@Param("planSet") Set<String> planSet,@Param("tenantCode") String tenantCode);

    List<String> strategyRelatePlanCodeList(@Param("planSet") Set<String> planCodeList,@Param("tenantCode") String tenantCode);


    List<ActivityPlanBudgetVo> findRegionIsRelateHead(@Param("planCodes") List<String> planCodes,@Param("tenantCode") String tenantCode);

    List<StrategyActivityPlanItemVo> findActivityPlanByStrategyItemCodeList(@Param("strategyItemCodeList") List<String> strategyItemCodeList, @Param("tenantCode") String tenantCode);

}

