package com.biz.crm.tpm.business.activity.plan.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.mapper.MnBaseMapper;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.RedPacketQueryScheme2Dto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.submitreportvo.ActivityPlanSubmitReportSubVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 活动方案明细表(ActivityPlanItem)表mybatis访问层
 *
 * @author wanghaojia
 * @since 2022-11-01 14:39:19
 */
public interface ActivityPlanItemMapper extends MnBaseMapper<ActivityPlanItem> {

    /**
     * 分页查询
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo>
     * @author huojia
     * @date 2022/12/9 16:54
     **/
    Page<ActivityPlanItemVo> findByConditions(Page<ActivityPlanItemVo> page, @Param("dto") ActivityPlanItemDto dto);

    /**
     * 会员红包查询细案
     * @param dto
     * @return
     */
    List<RedPacketQueryScheme2Vo> redPacketQueryScheme(@Param("dto") RedPacketQueryScheme2Dto dto);

    Page<ActivityPlanItemVo> findPlanItemNoActivityDetail(Page<ActivityPlanItemVo> page, @Param("beginDate") String beginDate, @Param("endDate") String endDate, @Param("salesOrgCodeList") List<String> legalSalesOrgCodeList);


    List<ActivityPlanItemBudgetVo> findItemBudgetListByConditions(@Param("dto") ActivityPlanItemBudgetDto dto);

    Page<ActivityPlanItemBudgetVo> findItemBudgetByConditions(@Param("page") Page<ActivityPlanItemBudgetVo> page, @Param("dto") ActivityPlanItemBudgetDto dto);

    List<ActivityPlanItemBudgetVo> findItemHeadBudgetListByConditions(@Param("dto") ActivityPlanItemBudgetDto dto);

    /**
     * 条件查询总条数
     *
     * @param dto
     * @return
     */
    Integer findTotalByConditions(@Param("dto") ActivityPlanItemDto dto);
    void updateHeadStatus(@Param("planItemCodeList") List<String> planItemCodeList);

    List<ActivityPlanItemVo> findRelatedPlanItemByCodes(@Param("codes") List<String> relatePlanItemCodes);
    /**
     * 根据关联方案明细编码 查询未关闭且审批通过的活动方案明细编码
     * @param relatePlanItemCodeList 关联方案编码
     * @return
     */
    List<String> findApprovedItemCodeListByRelatePlanItemCodeList(@Param("relatePlanItemCodeList") List<String> relatePlanItemCodeList);

    List<ActivityPlanItem> findByHeadquartersPlanItemCode(@Param("planItemCode") String planItemCode);
    List<ActivityPlanSubmitReportSubVo> submitPageReportDimension1(@Param("planCodeList") List<String> planCodeList, @Param("dateFormatStr") String dateFormatStr);

    List<ActivityPlanSubmitReportSubVo> submitPageReportDimension2(@Param("planCodeList") List<String> planCodeList, @Param("dateFormatStr") String dateFormatStr);

    List<ActivityPlanSubmitReportSubVo> submitPageReportDimension3(@Param("planCodeList") List<String> planCodeList, @Param("dateFormatStr") String dateFormatStr);

    List<String> findActivityPlanItemCodeByActivityNumber(@Param("activityNumberList") List<String> activityNumberList, @Param("planCode") String planCode);

    List<ActivityPlanItemVo> findCountForCarGift(@Param("list") List<String> planCodeList);
    List<ActivityPlanItemVo> findListForFR(@Param("dtos") List<ActivityPlanItemDto> activityPlanItemDtos,@Param("tenantCode") String tenantCode);

    List<ActivityPlanItemVo> findCostListForFR(@Param("dtos") List<ActivityPlanItemDto> itemDtos,@Param("code") String code,@Param("tenantCode") String tenantCode);
}

