package com.biz.crm.tpm.business.activity.plan.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanProcessBusinessForm;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.ActivityPlanItemPushSfaDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.display.ActivityPlanItemPushSfaDisplayDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * 活动方案表(ActivityPlan)表mybatis访问层
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:57
 */
public interface ActivityPlanMapper extends BaseMapper<ActivityPlan> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param dto  查询实体
     * @return 所有数据
     */
    Page<ActivityPlanVo> findByConditions(@Param("page") Page<ActivityPlanVo> page, @Param("dto") ActivityPlanDto dto);

    /**
     * 根据大区方案编码查询总部方案信息
     *
     * @param tenantCode
     * @param relatePlanCodes 大区方案编码
     * @return
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-11-12 23:27
     */
    List<ActivityPlanItemVo> findActivityPlanByRelatePlanCodes(@Param("tenantCode") String tenantCode, @Param("codes") List<String> relatePlanCodes);

    /**
     * 根据总部方案编码查询大区方案信息
     *
     * @param tenantCode
     * @param relatePlanItemCodes 总部方案编码
     * @return
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-11-12 23:27
     */
    List<ActivityPlanVo> findActivityPlanByRelatePlanItemCodes(@Param("tenantCode") String tenantCode, @Param("codes") List<String> relatePlanItemCodes);

    /**
     * 查询方案的剩余可用余额数据
     * @param planCodes 方案编码
     */
    List<ActivityPlanVo> findActivityPlanUsableBudgetList(@Param("planCodes") List<String> planCodes);


    /**
     * 通过方案编码查询推送sfa数据
     *
     * @param planCodes 方案编码
     * @return
     */
    List<ActivityPlanItemPushSfaDto> findSfaDataByPlanCodes(@Param("planCodes") List<String> planCodes);

    List<ActivityPlanItemPushSfaDisplayDto> findSfaDisplayDataByPlanCodes(@Param("planCodes") List<String> planCodes);

    List<ActivityPlanVo> findPlanActivityEndTime(@Param("activityDetailCodes") Set<String> activityDetailCodes);

    List<ActivityPlanVo> findByCodes(@Param("planCodes") Set<String> planCodes);

    /**
     * 获取活动方案提交审批业务数据
     * @param planCodeList 方案编码集合
     * @return 活动方案提交审批业务数据
     */
    ActivityPlanProcessBusinessForm getActivityPlanProcessBusinessForm(@Param("planCodeList") List<String> planCodeList);

    /**
     * 获取破价的活动方案
     *
     * @param planCodeList
     * @return
     */
    List<ActivityPlanRedLineVo> getActivityPlanBreakPrice(@Param("planCodeList") List<String> planCodeList);

    /**
     * 活动方案申请可以选择的总部方案
     * @param page      分页对象
     * @param dto      查询实体
     * @return 所有数据ø
     */
    Page<ActivityPlanVo> findRelateActivityPlanListByConditions(@Param("page") Page<ActivityPlanVo> page,@Param("dto") ActivityPlanDto dto);

    ActivityPlan findByPlanItemCode(@Param("planItemCode") String planItemCode);

    List<ActivityPlanVo> findByPlanItemCodes(@Param("planItemCodes") List<String> planItemCodes);

    void updateProcessStatus(@Param("codeList") List<String> codeList, @Param("processStatus") String processStatus, @Param("tenantCode") String tenantCode);



    List<ActivityPlanBudgetVo> findHeadquartersByRegionPlanCodes(@Param("planCodes") Set<String> planCodes);

    List<ActivityPlanVo>  findOrgCodeByPlanCode(@Param("codes") List<String> planCodes,@Param("tenantCode") String tenantCode);

    List<ActivityPlanVerticalSchemeForecastVo> findVerticalSchemeForecastByPlanItemCodes(@Param("codes") List<String> planItemCodeList, @Param("tenantCode") String tenantCode);

    List<ActivityPlanAuditVo> findAuditInfoByPlanItemCodes(@Param("codes")List<String> planItemCodeList, @Param("tenantCode") String tenantCode);
}

