package com.biz.crm.tpm.business.activity.plan.local.modify.consumer;

import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.thirld.PlanPushFreeGoods;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.OperationTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.constant.ActivityPlanModifyMqConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.service.ActivityPlanModifySdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.bizunited.nebula.common.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @Author : dengwei
 * @Date :2023/9/28  18:49
 * @Description: 活动更改通过通过sap
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityPlanModifyMqConstant.PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityPlanModifyMqConstant.PASS_PUSH_SAP,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityPlanModifyMqConstant.PASS_PUSH_SAP + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ActivityPlanModifyPassPushSAPPlanConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private ActivityPlanItemService activityPlanItemService;

    @Autowired(required = false)
    private PlanPushFreeGoods planPushFreeGoods;

    @Autowired(required = false)
    private ActivityPlanModifySdkService activityPlanModifySdkService;

    /**
     * redis服务
     */
    @Autowired(required = false)
    private RedisLockService redisLockService;
    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("活动方案审批通过推送sap order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }

        try {
            //方案推送sap
            //查询需要推送的方案明细数据
            String modifyBusinessCode = message.getMsgBody();
            ActivityPlanModifyVo planModifyVo = activityPlanModifySdkService.findByIdOrCode(null, modifyBusinessCode);
            Validate.notNull(planModifyVo,"方案变更后自动变更细案,更据活动方案变更编码【"+modifyBusinessCode+"】,未找到对应活动细案变更数据");
            List<ActivityPlanItemVo> activityPlanItemVos = activityPlanItemService.findListByPlanCodes(Collections.singletonList(planModifyVo.getPlanCode()));
            if(CollectionUtils.isNotEmpty(activityPlanItemVos)){
                activityPlanItemVos = activityPlanItemVos.stream().filter(o -> !InterfacePushStateEnum.SUCCESS.getCode().equals(o.getSapInterfaceState())).collect(Collectors.toList());
                //批量加锁
                boolean hasLock = false;
                List<String> planItemCodes = activityPlanItemVos.stream().map(ActivityPlanItemVo::getPlanItemCode).collect(Collectors.toList());
                try {
                    hasLock = redisLockService.batchLock(ActivityPlanConstant.FREE_GOODS_LOCK, planItemCodes, TimeUnit.MINUTES, 30);
                    if (!hasLock) {
                        log.error("免费货物正在推送SAP中，请勿重复推送，方案明细编码：{}", JsonUtils.obj2JsonString(planItemCodes));
                        throw new RuntimeException("免费货物正在推送SAP中,请勿重复推送");
                    }
                    planPushFreeGoods.pushActivityToFreeGoods(activityPlanItemVos, OperationTypeEnum.UPDATE);
                }finally {
                    if (hasLock) {
                        redisLockService.batchUnLock(ActivityPlanConstant.FREE_GOODS_LOCK, planItemCodes);
                    }
                }
            }
        }catch (Exception e){
            log.error(ActivityPlanPassMqTagEnum.PASS_PUSH_SAP.getName()+"处理失败"+e.getMessage(),e);
            return "消费失败."+e.getMessage();
        }
        return "消费成功.";
    }
}
