package com.biz.crm.tpm.business.activity.plan.local.modify.consumer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanModifyService;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.constant.ActivityPlanModifyMqConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.enums.ActivityPlanModifyMqTagEnum;
import com.biz.crm.tpm.business.marketing.strategy.sdk.enums.MarketingStrategyModifyMqTagEnum;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityPlanModifyMqConstant.PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityPlanModifyMqConstant.PASS_UPDATE_ORIGIN,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityPlanModifyMqConstant.PASS_UPDATE_ORIGIN + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ActivityPlanModifyPassUpdatePlanConsumer extends AbstractRocketMqConsumer {

    @Autowired
    private ActivityPlanModifyService activityPlanModifyService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info(ActivityPlanModifyMqTagEnum.PASS_UPDATE_ORIGIN.getName()+" order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }

        try {
            //更新原数据
            String businessNo = message.getMsgBody();
            ActivityPlanModifyDto activityPlanModifyDto = activityPlanModifyService.doUpdateOriginData(businessNo);
            //更新成功之后发送mq消息更新sd等信息
            passPushMq(businessNo);
            //更新主体方案预测表
            updateHeadSchemeForecast(activityPlanModifyDto);
        }catch (Exception e){
            log.error(ActivityPlanModifyMqTagEnum.PASS_UPDATE_ORIGIN.getName()+"处理失败"+e.getMessage(),e);
            return "消费失败."+e.getMessage();
        }

        return "消费成功.";
    }

    /**
     * 更新主体方案预测表
     */
    private void updateHeadSchemeForecast(ActivityPlanModifyDto activityPlanModifyDto) {
        String businessUnitCode = activityPlanModifyDto.getBusinessUnitCode();
        if (!BusinessUnitEnum.isDefaultBusinessUnit(businessUnitCode)){
            return;
        }
        MqMessageVo mqMessageVo = new MqMessageVo();
        mqMessageVo.setTopic(ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
        mqMessageVo.setTag(ActivityPlanPassMqTagConstant.PASS_TPM_HEAD_SCHEME_FORECAST);
        mqMessageVo.setMsgBody(JSONObject.toJSONString(Lists.newArrayList(activityPlanModifyDto.getPlanCode())));
        rocketMqProducer.sendMqMsg(mqMessageVo,10);
    }


    /**
     * 审批通过推送mq处理
     * @param businessNo 业务编码
     */
    private void passPushMq(String businessNo){
        if (StringUtils.isEmpty(businessNo)){
            return;
        }

        List<ActivityPlanModifyMqTagEnum> pushTagList = Lists.newArrayList();
        for (ActivityPlanModifyMqTagEnum mqTagEnum : ActivityPlanModifyMqTagEnum.values()) {
            if (ActivityPlanModifyMqTagEnum.PushType.after_update_origin.equals(mqTagEnum.getPushType())){
                pushTagList.add(mqTagEnum);
            }
        }

        if (CollectionUtils.isEmpty(pushTagList)){
            return;
        }

        for (ActivityPlanModifyMqTagEnum mqTagEnum : pushTagList) {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(businessNo);
            mqMessageVo.setTopic(ActivityPlanModifyMqConstant.PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(mqTagEnum.getCode());
            rocketMqProducer.sendMqMsg(mqMessageVo);
        }
    }

}
