package com.biz.crm.tpm.business.activity.plan.local.modify.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanItemModifyService;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanModifyFieldValue;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemModifyVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2022/11/28 16:33
 */
@RestController
@RequestMapping("/v1/activityPlanItemModify")
@Slf4j
@Api(tags = "活动方案变更表")
public class ActivityPlanItemModifyController extends MnPageCacheController<ActivityPlanItemModifyVo, ActivityPlanItemModifyDto> {

    @Autowired(required = false)
    private ActivityPlanItemModifyService activityPlanItemModifyService;

    /**
     * 获取预算汇总信息
     *
     * @param cacheKey 缓存key
     * @return
     */
    @ApiOperation(value = "获取预算汇总信息")
    @PostMapping("findBudgetCacheSumList")
    public Result<List<ActivityPlanBudgetSumVo>> findBudgetCacheSumList(@ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey) {
        try {
            List<ActivityPlanBudgetSumVo> list = this.activityPlanItemModifyService.findBudgetCacheSumList(cacheKey);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 策略调整前数据查询
     */
    @ApiOperation(value = "策略调整前数据查询")
    @PostMapping(value = "findItemModifyLFieldValueListByProcessNo")
    public Result<List<ActivityPlanModifyFieldValue>> findItemModifyLFieldValueListByProcessNo(@ApiParam(value = "流程编号")@RequestParam String processNo){
        try {
            List<ActivityPlanModifyFieldValue> list = this.activityPlanItemModifyService.findItemModifyLFieldValueListByProcessNo(processNo);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 策略调整前数据查询
     */
    @ApiOperation(value = "策略调整前数据查询")
    @PostMapping(value = "findItemModifyLFieldValueList")
    public Result<Page<ActivityPlanModifyFieldValue>> findItemModifyLFieldValueList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                                    @ApiParam(value = "变更编码")@RequestParam String modifyCode){
        try {
            Page<ActivityPlanModifyFieldValue> page = this.activityPlanItemModifyService.findItemModifyLFieldValueList(pageable,modifyCode);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
