package com.biz.crm.tpm.business.activity.plan.local.modify.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanItemTerminalModifyService;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemTerminalModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemTerminalModifyVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2022/11/28 16:33
 */
@RestController
@RequestMapping("/v1/activityPlanItemTerminalModify")
@Slf4j
@Api(tags = "活动方案变更表")
public class ActivityPlanItemTerminalModifyController {

    @Autowired(required = false)
    private ActivityPlanItemTerminalModifyService activityPlanItemTerminalService;

    /**
     * 1、获取明细列表缓存分页接口
     *
     * @param pageable 分页参数
     * @param cacheKey 缓存key
     * @return
     */
    @ApiOperation(value = "获取明细列表缓存分页接口")
    @GetMapping("findCachePageList")
    public Result<Page<ActivityPlanItemTerminalModifyVo>> findCachePageList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                            @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
                                                                            @ApiParam(name = "dto", value = "查询实体") ActivityPlanItemTerminalModifyDto dto) {
        try {
            Page<ActivityPlanItemTerminalModifyVo> page = this.activityPlanItemTerminalService.findCachePageList(pageable, dto, cacheKey);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    @ApiOperation("清理缓存接口")
    @PostMapping({"clearCache"})
    public Result clearCache(@ApiParam(name = "cacheKey",value = "缓存键") @RequestParam String cacheKey) {
        try {
            activityPlanItemTerminalService.clearCache(cacheKey);
            return Result.ok();
        } catch (Exception var3) {
            log.error(var3.getMessage(), var3);
            return Result.error(var3.getMessage());
        }
    }

    @ApiOperation(value = "新增一行接口，保存当前页数据后，在缓存中行首插入一条数据并返回第一页数据")
    @PostMapping("addItemCache")
    public Result<Page<ActivityPlanItemTerminalModifyVo>> addItemCache(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                 @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
                                                                 @ApiParam(name = "dto", value = "查询实体") ActivityPlanItemTerminalModifyDto dto,
                                                                 @ApiParam(value = "当前页数据") @RequestBody List<ActivityPlanItemTerminalModifyDto> itemList) {
        try {
            this.activityPlanItemTerminalService.addItemCache(cacheKey,itemList);
            Page<ActivityPlanItemTerminalModifyVo> page = this.activityPlanItemTerminalService.findCachePageList(pageable, null,cacheKey);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 3、复制行接口：保存当前页数据后，在缓存中行首复制选中数据并返回第一页数据
     *
     * @param pageable 分页参数
     * @param cacheKey 缓存key
     * @return
     */
    @ApiOperation(value = "复制行接口，保存当前页数据后，在缓存中行首复制选中数据并返回第一页数据")
    @PostMapping("copyItemListCache")
    public Result<Page<ActivityPlanItemTerminalModifyVo>> copyItemListCache(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                      @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
                                                                      @ApiParam(name = "dto", value = "查询实体") ActivityPlanItemTerminalModifyDto dto,
                                                                      @ApiParam(value = "当前页数据，包含要复制的行勾选信息") @RequestBody List<ActivityPlanItemTerminalModifyDto> itemList) {
        try {
            this.activityPlanItemTerminalService.copyItemListCache(cacheKey, itemList);
            Page<ActivityPlanItemTerminalModifyVo> page = this.activityPlanItemTerminalService.findCachePageList(pageable, null,cacheKey);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 4、保存当前页数据到缓存并返回指定页数据接口
     *
     * @param pageable 分页参数
     * @param cacheKey 缓存key
     * @return
     */
    @ApiOperation(value = "保存当前页数据到缓存并返回指定页数据接口")
    @PostMapping("saveCurrentPageCache")
    public Result<Page<ActivityPlanItemTerminalModifyVo>> saveCurrentPageCache(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                         @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
                                                                         @ApiParam(name = "dto", value = "查询实体") ActivityPlanItemTerminalModifyDto dto,
                                                                         @ApiParam(value = "当前页数据") @RequestBody List<ActivityPlanItemTerminalModifyDto> saveList) {
        try {
            this.activityPlanItemTerminalService.saveCurrentPageCache(cacheKey, saveList);
            Page<ActivityPlanItemTerminalModifyVo> page = this.activityPlanItemTerminalService.findCachePageList(pageable, null,cacheKey);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 7、删除行接口：删除有选中标记的行，更新未标记数据，并返回指定页数据接口
     *
     * @param pageable 分页参数
     * @param cacheKey 缓存key
     * @return
     */
    @ApiOperation(value = "多行删除并返回指定页数据接口")
    @PostMapping("deleteCacheList")
    public Result<Page<ActivityPlanItemTerminalModifyVo>> deleteCacheList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                    @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
                                                                    @ApiParam(name = "dto", value = "查询实体") ActivityPlanItemTerminalModifyDto dto,
                                                                    @ApiParam(value = "当前页数据，包含要删除的行勾选信息") @RequestBody List<ActivityPlanItemTerminalModifyDto> itemList) {
        try {
            this.activityPlanItemTerminalService.deleteCacheList(cacheKey, itemList);
            Page<ActivityPlanItemTerminalModifyVo> page = this.activityPlanItemTerminalService.findCachePageList(pageable, null,cacheKey);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
