package com.biz.crm.tpm.business.activity.plan.local.modify.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanItemModifyService;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanModifyService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanModifyApproveSubmitDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyApproveSubmitDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 活动方案变更处理
 * @author wanghaojia
 * @date 2022/11/28 16:33
 */
@RestController
@RequestMapping("/v1/activityPlanModify")
@Slf4j
@Api(tags = "活动方案变更表")
public class ActivityPlanModifyController {

    @Autowired(required = false)
    private ActivityPlanModifyService activityPlanModifyService;

    @Autowired(required = false)
    private ActivityPlanItemModifyService activityPlanItemModifyService;

    /**
     * 获取待调整的方案数据
     */
    @ApiOperation(value = "获取待调整的方案数据")
    @GetMapping(value = "findToModifyList")
    public Result<Page<ActivityPlanVo>> findToModifyList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "dto",value = "查询条件") ActivityPlanDto dto){
        try {
            Page<ActivityPlanVo> page = this.activityPlanModifyService.findToModifyList(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过id获取活动方案变更数据
     */
    @ApiOperation(value = "通过id获取活动方案变更数据")
    @GetMapping("findById")
    public Result<ActivityPlanModifyVo> findById(@ApiParam(value = "id")@RequestParam(required = false) String id,@ApiParam(value = "code")@RequestParam(required = false) String code){
        try {
            ActivityPlanModifyVo vo = this.activityPlanModifyService.findByIdOrCode(id,code);
            return Result.ok(vo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 新增数据
     * @param cacheKey 明细缓存键
     * @param dto 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping(value = "create")
    public Result<?> create(@ApiParam(name = "cacheKey", value = "缓存键")@RequestParam String cacheKey,
                            @ApiParam(name = "dto", value = "实体对象")@RequestBody ActivityPlanModifyDto dto) {
        try {
            this.activityPlanModifyService.create(cacheKey,dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     * @param cacheKey 明细缓存键
     * @param dto 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "更新数据")
    @PatchMapping(value = "update")
    public Result<?> update(@ApiParam(name = "cacheKey", value = "缓存键")@RequestParam String cacheKey,
                            @ApiParam(name = "dto", value = "分子公司细案变更表头")@RequestBody ActivityPlanModifyDto dto) {
        try {
            if (StringUtils.isEmpty(dto.getId())){
                throw new RuntimeException("编辑操作参数有误");
            }
            this.activityPlanModifyService.create(cacheKey,dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 提交审批流
     *
     * @param dto 查询对象
     * @return
     */
    @ApiOperation(value = "提交审批流")
    @PostMapping("/submit")
    public Result submit(@RequestBody ActivityPlanModifyApproveSubmitDto dto) {
        try {
            this.activityPlanModifyService.submit(dto);
            return Result.ok("提交成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除策略调整
     * @param ids 策略ids
     */
    @ApiOperation(value = "删除")
    @DeleteMapping(value = "delete")
    public Result delete(@ApiParam(value = "策略id集合")@RequestParam List<String> ids){
        try {
            this.activityPlanModifyService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 审批通过退预算
     */
    @ApiOperation(value = "审批通过退预算")
    @PostMapping(value = "passReturnMonthBudgetByModifyCode")
    public Result passReturnMonthBudgetByModifyCode(@ApiParam(value = "方案变更编码")@RequestParam String modifyBusinessCode){
        try {
            this.activityPlanModifyService.passReturnMonthBudgetByModifyCode(modifyBusinessCode);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
