package com.biz.crm.tpm.business.activity.plan.local.modify.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 活动方案明细表(ActivityPlanItem)
 *
 * @author wanghaojia
 * @since 2022-11-01 14:39:19
 */
@ApiModel(value = "ActivityPlanItem", description = "活动方案明细变更表")
@TableName("tpm_activity_plan_item_modify")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_item_modify")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_item_modify", comment = "活动方案明细变更表")
@Table(
        name = "tpm_activity_plan_item_modify",
        indexes = {
                @Index(name = "tpm_activity_plan_item_modify_inx3", columnList = "modify_business_code,", unique = false)
        }
)
public class ActivityPlanItemModify extends TenantFlagOpEntity {

    /**
     * 变更编码
     */
    @ApiModelProperty("变更编码")
    @Column(name = "modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '变更编码'")
    private String modifyBusinessCode;

    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    @Column(name = "plan_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动方案编码'")
    private String planCode;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    @Column(name = "plan_item_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动方案明细编码'")
    private String planItemCode;


    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_begin_date", columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndDate;

    /**
     * 订单开始时间
     */
    @ApiModelProperty("订单开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date orderBeginDate;
    /**
     * 订单结束时间
     */
    @ApiModelProperty("订单结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date orderEndDate;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    @Column(name = "quantity", length = 11, columnDefinition = "int(11) COMMENT '数量'")
    private Integer quantity;
    /**
     * 预估销售额
     */
    @ApiModelProperty("预估销售额")
    @Column(name = "sales_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '预估销售额'")
    private BigDecimal salesAmount;
    /**
     * 期间促销件数
     */
    @ApiModelProperty("期间促销件数")
    @Column(name = "period_promotional_number", length = 11, columnDefinition = "int(11) COMMENT '期间促销件数'")
    private Integer periodPromotionalNumber;
    /**
     * 期间促销金额
     */
    @ApiModelProperty("期间促销金额")
    @Column(name = "period_promotional_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间促销金额'")
    private BigDecimal periodPromotionalAmount;

    /**
     * 预估费用 -我方承担金额
     */
    @ApiModelProperty("预估费用 -我方承担金额")
    @Column(name = "fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '预估费用 -我方承担金额'")
    private BigDecimal feeAmount;
    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    @Column(name = "head_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '总部承担金额'")
    private BigDecimal headFeeAmount;
    /**
     * 已发生总部费用
     */
    @ApiModelProperty("已发生总部费用")
    @Column(name = "used_head_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '已发生总部费用'")
    private BigDecimal usedHeadFeeAmount;
    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    @Column(name = "department_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '大区承担金额'")
    private BigDecimal departmentFeeAmount;
    /**
     * 已发生大区费用
     */
    @ApiModelProperty("已发生大区费用")
    @Column(name = "used_department_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '已发生大区费用'")
    private BigDecimal usedDepartmentFeeAmount;
    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    @Column(name = "customer_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '客户承担金额'")
    private BigDecimal customerFeeAmount;
    /**
     * 已发生客户费用
     */
    @ApiModelProperty("已发生客户费用")
    @Column(name = "used_customer_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '已发生客户费用'")
    private BigDecimal usedCustomerFeeAmount;
    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    @Column(name = "total_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用合计'")
    private BigDecimal totalFeeAmount;

    /**
     * 大区公投预算金额
     */
    @ApiModelProperty("大区公投预算金额（元）")
    @Column(name = "region_referendum_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '大区公投预算金额（元）'")
    private BigDecimal regionReferendumFeeAmount;

    /**
     * 大区自投预算金额
     */
    @ApiModelProperty("大区自投预算金额（元）")
    @Column(name = "region_automatic_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '大区自投预算金额（元）'")
    private BigDecimal regionAutomaticFeeAmount;

    @ApiModelProperty("是否扣减费用池")
    @Column(name = "is_deduction_fee_pool", length = 255, columnDefinition = "varchar(16) COMMENT '是否扣减费用池'")
    private String isDeductionFeePool;
    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    @Column(name = "audit_type", length = 20, columnDefinition = "varchar(20) COMMENT '核销类型'")
    private String auditType;
    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    @Column(name = "audit_condition_code", length = 32, columnDefinition = "varchar(32) COMMENT '核销条件编码'")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    @Column(name = "audit_condition_name", length = 255, columnDefinition = "varchar(255) COMMENT '核销条件名称'")
    private String auditConditionName;

    /**
     * 一级管理渠道编码
     */
    @ApiModelProperty("一级管理渠道编码")
    @Column(name = "first_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '一级管理渠道编码'")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    @Column(name = "first_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '一级管理渠道名称'")
    private String firstChannelName;
    /**
     * 二级管理渠道编码
     */
    @ApiModelProperty("二级管理渠道编码")
    @Column(name = "second_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '二级管理渠道编码'")
    private String secondChannelCode;
    /**
     * 二级管理渠道名称
     */
    @ApiModelProperty("二级管理渠道名称")
    @Column(name = "second_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '二级管理渠道名称'")
    private String secondChannelName;
    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动类型编码'")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动类型名称'")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式编码'")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式名称'")
    private String activityFormName;

    /**
     * 调整前版本号
     */
    @ApiModelProperty("调整前变更编码")
    @Column(name = "curr_modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '调整前版本号'")
    private String currModifyBusinessCode;
}

