package com.biz.crm.tpm.business.activity.plan.local.modify.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2023/1/12 10:17
 * @description：方案明细门店
 */
@ApiModel(value = "ActivityPlanItemTerminalModify", description = "方案明细变更门店")
@TableName("tpm_activity_plan_item_terminal_modify")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_item_terminal_modify")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_item_terminal_modify", comment = "方案明细变更门店")
@Table(
        name = "tpm_activity_plan_item_terminal_modify",
        indexes = {
                @Index(name = "tpm_activity_plan_item_terminal_modify_inx3", columnList = "modify_business_code,", unique = false)
        }
)
public class ActivityPlanItemTerminalModify extends TenantFlagOpEntity {

    /**
     * 变更编码
     */
    @ApiModelProperty("变更编码")
    @Column(name = "modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '变更编码'")
    private String modifyBusinessCode;

    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    @Column(name = "plan_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动方案编码'")
    private String planCode;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    @Column(name = "plan_item_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动方案明细编码'")
    private String planItemCode;


    /**
     * 门店编码
     */
    @ApiModelProperty(name = "门店编码", notes = "门店编码")
    @Column(name = "terminal_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '门店编码'")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "门店名称", notes = "门店名称")
    @Column(name = "terminal_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '门店名称'")
    private String terminalName;

    @ApiModelProperty(name = "responsibleBusiness", notes = "责任业务")
    @Column(name = "responsible_business", columnDefinition = "varchar(32) COMMENT '责任业务'")
    private String responsibleBusiness;

    @ApiModelProperty(name = "responsibleSupervision", notes = "责任督导")
    @Column(name = "responsible_supervision", columnDefinition = "varchar(32) COMMENT '责任督导'")
    private String responsibleSupervision;

    @ApiModelProperty(name = "name", notes = "用户姓名")
    @Column(name = "name", columnDefinition = "varchar(256) COMMENT '用户姓名'")
    private String name;

    @ApiModelProperty(name = "empId", notes = "empId")
    @Column(name = "emp_id", columnDefinition = "varchar(64) COMMENT 'empId'")
    private String empId;

    @ApiModelProperty(name = "employeeCode", notes = "员工号")
    @Column(name = "employee_code", columnDefinition = "varchar(64) COMMENT '员工号'")
    private String employeeCode;

    /**
     * 活动开始时间
     */
    @ApiModelProperty("促销人员开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "begin_date", columnDefinition = "datetime COMMENT '促销人员开始时间'")
    private Date beginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("促销人员结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "end_date",  columnDefinition = "datetime COMMENT '促销人员结束时间'")
    private Date endDate;


    @ApiModelProperty(name = "phone", notes = "手机号")
    @Column(name = "phone", columnDefinition = "varchar(11) COMMENT '手机号'")
    private String phone;

    @ApiModelProperty(name = "identityCard", notes = "身份证号")
    @Column(name = "identity_card", columnDefinition = "varchar(20) COMMENT '身份证号'")
    private String identityCard;

    @ApiModelProperty("标准")
    @Column(name = "standard", columnDefinition = "DECIMAL(20,6) COMMENT '标准'")
    private BigDecimal standard;

    @ApiModelProperty("数量")
    @Column(name = "quantity", columnDefinition = "DECIMAL(20,6) COMMENT '数量'")
    private BigDecimal quantity;

    @ApiModelProperty("金额")
    @Column(name = "amount", columnDefinition = "DECIMAL(20,6) COMMENT '金额'")
    private BigDecimal amount;

    /**
     * 系统承担金额
     */
    @ApiModelProperty("我方承担金额")
    @Column(name = "fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '我方承担金额'")
    private BigDecimal feeAmount;

    /**
     * 系统承担金额
     */
    @ApiModelProperty("系统承担金额")
    @Column(name = "system_borne_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '系统承担金额'")
    private BigDecimal systemBorneAmount;

    @ApiModelProperty("浮动率")
    @Column(name = "floating_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '浮动率'")
    private BigDecimal floatingRate;

    /**
     * 原表id
     */
    @Column(name = "origin_id", columnDefinition = "varchar(32) COMMENT '原表id'")
    private String originId;

}
