package com.biz.crm.tpm.business.activity.plan.local.modify.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 活动方案表(ActivityPlan)
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:57
 */
@ApiModel(value = "ActivityPlanModify", description = "活动方案变更表")
@TableName("tpm_activity_plan_modify")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_modify")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_modify", comment = "活动方案变更表")
@Table(
        name = "tpm_activity_plan_modify",
        indexes = {
                @Index(name = "tpm_activity_plan_modify_inx1", columnList = "modify_business_code", unique = true),
                @Index(name = "tpm_activity_plan_modify_inx2", columnList = "plan_code", unique = false),
        }
)
public class ActivityPlanModify extends TenantFlagOpEntity {

    /**
     * 变更编码
     */
    @ApiModelProperty("变更编码")
    @Column(name = "modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '变更编码'")
    private String modifyBusinessCode;

    /**
     * 方案编码
     */
    @ApiModelProperty("方案编码")
    @Column(name = "plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案编码'")
    private String planCode;
    /**
     * 方案名称
     */
    @ApiModelProperty("方案名称")
    @Column(name = "plan_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '方案名称'")
    private String planName;
    /**
     * 方案类型，数据字典tpm_activity_type
     */
    @ApiModelProperty("方案类型，数据字典tpm_activity_type")
    @Column(name = "plan_type", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案类型，数据字典tpm_activity_type'")
    private String planType;

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty("业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业务单元'")
    private String businessUnitCode;
    /**
     * 方案开始时间
     */
    @ApiModelProperty("方案开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "begin_date", nullable = true, columnDefinition = "datetime COMMENT '方案开始时间'")
    private Date beginDate;
    /**
     * 方案结束时间
     */
    @ApiModelProperty("方案结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "end_date", nullable = true,  columnDefinition = "datetime COMMENT '方案结束时间'")
    private Date endDate;
    /**
     * 方案结束时间
     */
    @ApiModelProperty("部门编码")
    @Column(name = "department_code", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '部门编码'")
    private String departmentCode;

    /**
     * 方案结束时间
     */
    @ApiModelProperty("部门名称")
    @Column(name = "department_name", nullable = true, length = 255, columnDefinition = "varchar(1024) COMMENT '方案结束时间'")
    private String departmentName;

    /**
     * 方案范围编码
     */
    @ApiModelProperty("方案范围编码")
    @Column(name = "plan_org_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案范围编码'")
    private String planOrgCode;
    /**
     * 方案范围名称
     */
    @ApiModelProperty("方案范围名称")
    @Column(name = "plan_org_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '方案范围名称'")
    private String planOrgName;

    /**
     * 方案分类，数据字典tpm_activity_classify
     */
    @ApiModelProperty("方案分类，数据字典tpm_activity_classify")
    @Column(name = "plan_classify", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案分类，数据字典tpm_activity_classify'")
    private String planClassify;
    /**
     * 方案关联限制，数据字典tpm_activity_plan_relate_limit
     */
    @ApiModelProperty("方案关联限制，数据字典tpm_activity_plan_relate_limit")
    @Column(name = "plan_relate_limit_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案关联限制，数据字典tpm_activity_plan_relate_limit'")
    private String planRelateLimitCode;
    /**
     * 活动状态
     */
    @ApiModelProperty("活动状态")
    @Column(name = "plan_status", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动状态'")
    private String planStatus;
    /**
     * 预估费用 -我方承担金额
     */
    @ApiModelProperty("预估费用 -我方承担金额")
    @Column(name = "fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '预估费用 -我方承担金额'")
    private BigDecimal feeAmount;
    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    @Column(name = "head_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '总部承担金额'")
    private BigDecimal headFeeAmount;
    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    @Column(name = "department_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '大区承担金额'")
    private BigDecimal departmentFeeAmount;
    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    @Column(name = "customer_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '客户承担金额'")
    private BigDecimal customerFeeAmount;
    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    @Column(name = "total_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '费用合计'")
    private BigDecimal totalFeeAmount;
    /**
     * 已使用金额（元）
     */
    @ApiModelProperty("已使用金额（元）")
    @Column(name = "used_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '已使用金额（元）'")
    private BigDecimal usedAmount;
    /**
     * 预估销售额（万元）
     */
    @ApiModelProperty("预估销售额（万元）")
    @Column(name = "sales_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '预估销售额（万元）'")
    private BigDecimal salesAmount;

    /**
     * 方案投产比
     */
    @ApiModelProperty("方案投产比")
    @Column(name = "plan_io_rate", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '方案投产比'")
    private BigDecimal planIoRate;
    /**
     * 方案主题
     */
    @ApiModelProperty("方案主题")
    @Column(name = "plan_title", nullable = true, length = 1000, columnDefinition = "varchar(1000) COMMENT '方案主题'")
    private String planTitle;
    /**
     * 方案目的
     */
    @ApiModelProperty("方案目的")
    @Column(name = "plan_goal", nullable = true, length = 1000, columnDefinition = "varchar(1000) COMMENT '方案目的'")
    private String planGoal;
    /**
     * 活动背景
     */
    @ApiModelProperty("活动背景")
    @Column(name = "activity_background", nullable = true, length = 1000, columnDefinition = "varchar(1000) COMMENT '活动背景'")
    private String activityBackground;
    /**
     * 活动目标
     */
    @ApiModelProperty("活动目标")
    @Column(name = "activity_target", nullable = true, length = 1000, columnDefinition = "varchar(1000) COMMENT '活动目标'")
    private String activityTarget;
    /**
     * 明细说明
     */
    @ApiModelProperty("明细说明")
    @Column(name = "detail_explain", nullable = true, length = 1000, columnDefinition = "varchar(1000) COMMENT '明细说明'")
    private String detailExplain;

    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    @Column(name = "template_config_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '方案模板编码'")
    private String templateConfigCode;
    /**
     * 方案模板名称
     */
    @ApiModelProperty("方案模板名称")
    @Column(name = "template_config_name", nullable = true, length = 1024, columnDefinition = "varchar(1024) COMMENT '方案模板名称'")
    private String templateConfigName;

    /**
     * 流程编号
     */
    @ApiModelProperty("流程编号")
    @Column(name = "process_no", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '流程编号'")
    private String processNo;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    @Column(name = "process_status", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '审批状态'")
    private String processStatus;

    /**
     * 区域编码(字典MDM_CUSTOMIZE_ORG)
     */
    @ApiModelProperty(name = "区域编码", notes = "")
    @Column(name = "region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码 '")
    private String regionCode;

}

