package com.biz.crm.tpm.business.activity.plan.local.modify.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 活动方案表-大区关联总部方案(ActivityPlanRelatePlan)
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:57
 */
@ApiModel(value = "ActivityPlanRelatePlan", description = "活动方案表-大区关联总部方案变更")
@TableName("tpm_activity_plan_relate_plan_modify")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_relate_plan_modify")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_relate_plan_modify", comment = "活动方案表-大区关联总部方案变更")
@Table(
        name = "tpm_activity_plan_relate_plan_modify",
        indexes = {
                @Index(name = "tpm_aprpm_inx1", columnList = "plan_code"),
                @Index(name = "tpm_aprpm_inx2", columnList = "modify_business_code"),
        }
)
public class ActivityPlanRelatePlanModify extends TenantFlagOpEntity {

    /**
     * 变更编码
     */
    @ApiModelProperty("变更编码")
    @Column(name = "modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '变更编码'")
    private String modifyBusinessCode;

    /**
     * 方案编码
     */
    @ApiModelProperty("方案编码")
    @Column(name = "plan_code", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '方案编码'")
    private String planCode;

    /**
     * 关联方案编码
     */
    @ApiModelProperty("关联方案编码")
    @Column(name = "relate_plan_code", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '关联方案编码'")
    private String relatePlanCode;
    /**
     * 关联方案名称
     */
    @ApiModelProperty("关联方案名称")
    @Column(name = "relate_plan_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '关联方案名称'")
    private String relatePlanName;

    /**
     * 方案开始时间
     */
    @ApiModelProperty("关联方案开始时间")
    @Column(name = "relate_plan_begin_date", nullable = true, length = 255, columnDefinition = "varchar(19) COMMENT '关联方案开始时间'")
    private String relatePlanBeginDate;
    /**
     * 关联方案结束时间
     */
    @ApiModelProperty("关联方案结束时间")
    @Column(name = "relate_plan_end_date", nullable = true, length = 255, columnDefinition = "varchar(19) COMMENT '关联方案结束时间'")
    private String relatePlanEndDate;

    /**
     * 关联方案预估费用
     */
    @ApiModelProperty("关联方案预估费用（万元）")
    @Column(name = "relate_plan_total_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '关联方案预估费用（万元）'")
    private BigDecimal relatePlanTotalFeeAmount;

    /**
     * 方案已申请金额
     */
    @ApiModelProperty("方案已申请金额")
    @Column(name = "used_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '方案已申请金额'")
    private BigDecimal usedAmount;

    /**
     * 方案已申请金额
     */
    @ApiModelProperty("方案剩余可用方案金额")
    @Column(name = "usable_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '方案剩余可用方案金额'")
    private BigDecimal usableAmount;

    /**
     * 本次使用方案金额
     */
    @ApiModelProperty("本次使用方案金额")
    @Column(name = "use_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本次使用方案金额'")
    private BigDecimal useAmount;


}

