package com.biz.crm.tpm.business.activity.plan.local.modify.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.activity.plan.local.exports.vo.StoreDetailsExportVo;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanItemTerminalModifyService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemTerminalService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemTerminalModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemTerminalModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemTerminalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;


/**
 * @author: xiaoyoujun
 * @date:
 * @description: 活动方案门店明细导出
 */
@Slf4j
@Component
public class StoreDetailsModifyExportProcess implements ExportProcess<StoreDetailsExportVo>{

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private ActivityPlanItemTerminalModifyService activityPlanItemTerminalService;

    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        Integer total = this.getTotal((String) params.get("cacheKey"));
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    public Integer getTotal(String cacheKey) {
        return activityPlanItemTerminalService.findCacheList(cacheKey).size();
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        String cacheKey = (String) params.get("cacheKey");
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, this.getPageSize());
        ActivityPlanItemTerminalModifyDto dto = new ActivityPlanItemTerminalModifyDto();
        Page<ActivityPlanItemTerminalModifyVo> cachePage = activityPlanItemTerminalService.findCachePageList(pageable, dto, cacheKey);
        if (cachePage.getTotal() == 0) {
            return new JSONArray();
        }
        Collection<StoreDetailsExportVo> exportVos = nebulaToolkitService.copyCollectionByWhiteList(cachePage.getRecords(), ActivityPlanItemTerminalModifyVo.class, StoreDetailsExportVo.class, LinkedHashSet.class, ArrayList.class);
        return JSONArray.parseArray(JSON.toJSONString(exportVos));
    }

    @Override
    public String getBusinessCode() {
        return "TPM_STORE_DETAILS_MODIFY_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "活动方案变更门店明细导出";
    }

    @Override
    public Class<StoreDetailsExportVo> findCrmExcelVoClass() {
        return StoreDetailsExportVo.class;
    }

}
