package com.biz.crm.tpm.business.activity.plan.local.modify.listener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.rocketmq.event.RocketMqProducerEvent;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanModifyService;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.constant.ActivityPlanModifyMqConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.enums.ActivityPlanModifyMqTagEnum;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

/**
 * 分子公司活动细案审批通过
 */
@Slf4j
@Component
public class ActivityPlanModifyCompleteListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private ActivityPlanModifyService activityPlanModifyService;

    @Override
    public String getBusinessCode() {
        return ActivityPlanConstant.PROCESS_NAME_ACTIVITY_PLAN_MODIFY;
    }

    @Override
    public void onProcessComplete(ProcessStatusDto dto) {

        if (StringUtils.isEmpty(dto.getBusinessNo())) {
            return;
        }
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");

        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            activityPlanModifyService.processPass(dto);
        }
        //审批驳回|流程追回
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) ||
                ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            activityPlanModifyService.processRejectAndRecover(dto);
        }

    }

}
