package com.biz.crm.tpm.business.activity.plan.local.modify.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 活动方案(ActivityPlan)数据视图注册器
 *
 * @author wanghaojia
 * @since 2022-11-11 10:31:00
 */
@Component
public class ActivityPlanModifyDataViewRegister implements DataviewRegister {

  @Override
  public String code() {
    return "tpm_activity_plan_modify_data_view";
  }

  @Override
  public String desc() {
    return "TPM-活动方案调整";
  }

  @Override
  public String buildSql() {
    return "select\n" +
            "a.*\n" +
            " from tpm_activity_plan_modify a\n" +
            "where a.tenant_code = :tenantCode\n" +
            "and a.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode()+"'"+
            "and a.modify_business_code is not null";
  }

}
