package com.biz.crm.tpm.business.activity.plan.local.modify.repository;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanBudgetModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.mapper.ActivityPlanBudgetModifyMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 活动方案表(ActivityPlan)表数据库访问层
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:54
 */
@Component
public class ActivityPlanBudgetModifyRepository extends ServiceImpl<ActivityPlanBudgetModifyMapper, ActivityPlanBudgetModify> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 根据方案编码，查询方案对应预算
     * @param planCode 方案编码
     **/
    public List<ActivityPlanBudgetModify> listByPlanCode(String planCode) {
        if (StringUtils.isEmpty(planCode)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(ActivityPlanBudgetModify::getPlanCode, planCode)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    /**
     * 根据方案编码查询
     **/
    public List<ActivityPlanBudgetModifyDto> listDtoListByModifyCode(String modifyCode) {
        if (StringUtils.isEmpty(modifyCode)) {
            return null;
        }
        return baseMapper.listDtoListByModifyCode(modifyCode);
    }

    /**
     * 根据方案编码，查询方案对应预算
     * @param modifyCodeList 方案变更编码集合
     **/
    public List<ActivityPlanBudgetModifyDto> listDtoByModifyCodeList(List<String> modifyCodeList) {
        List<ActivityPlanBudgetModify> activityPlanBudgets = listByModifyCodeList(modifyCodeList);
        if (CollectionUtils.isNotEmpty(activityPlanBudgets)){
            List<ActivityPlanBudgetModifyDto> dtoList = (List<ActivityPlanBudgetModifyDto>) nebulaToolkitService.copyCollectionByBlankList(activityPlanBudgets,ActivityPlanBudgetModify.class,ActivityPlanBudgetModifyDto.class, HashSet.class, ArrayList.class);
            return dtoList;
        }
        return Lists.newArrayList();
    }

    /**
     * 根据方案编码，查询方案对应预算
     * @param modifyCodeList 方案编码集合
     **/
    public List<ActivityPlanBudgetModify> listByModifyCodeList(List<String> modifyCodeList) {
        if (org.springframework.util.CollectionUtils.isEmpty(modifyCodeList)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(ActivityPlanBudgetModify::getModifyBusinessCode, modifyCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    /**
     * 根据明细编码，批量查询方案明细对应预算
     *
     * @param itemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudgetModify>
     * @author huojia
     * @date 2022/11/28 16:56
     **/
    public List<ActivityPlanBudgetModify> listByDetailCodeList(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(ActivityPlanBudgetModify::getPlanItemCode, itemCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    public void deleteByIds(List<String> ids) {
        if (org.springframework.util.CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<ActivityPlanBudgetModify> updateWrapper = new UpdateWrapper<ActivityPlanBudgetModify>().lambda();
        updateWrapper.set(ActivityPlanBudgetModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanBudgetModify::getId, ids);
        this.update(updateWrapper);
    }

    public void deletePhysicalByModifyBusinessCode(String modifyBusinessCode) {
        if (StringUtils.isEmpty(modifyBusinessCode)){
            return;
        }
        LambdaQueryWrapper<ActivityPlanBudgetModify> updateWrapper = new LambdaQueryWrapper<ActivityPlanBudgetModify>();
//        updateWrapper.set(ActivityPlanBudgetModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.eq(ActivityPlanBudgetModify::getModifyBusinessCode, modifyBusinessCode);
        this.remove(updateWrapper);
    }

    public void deleteByModifyBusinessCodes(List<String> modifyBusinessCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(modifyBusinessCodes)){
            return;
        }
        LambdaUpdateWrapper<ActivityPlanBudgetModify> updateWrapper = new UpdateWrapper<ActivityPlanBudgetModify>().lambda();
        updateWrapper.set(ActivityPlanBudgetModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanBudgetModify::getModifyBusinessCode, modifyBusinessCodes);
        this.update(updateWrapper);
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoListProperties(List<ActivityPlanBudgetVo> voList) {
        if (org.springframework.util.CollectionUtils.isEmpty(voList)){
            return;
        }
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));
        for (ActivityPlanBudgetVo item : voList) {
            this.fillVoProperties(item,propertyMap);
        }
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoProperties(ActivityPlanBudgetVo item) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));
        this.fillVoProperties(item,propertyMap);
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoProperties(ActivityPlanBudgetVo item,Map<String, PropertyDescriptor> propertyMap) {
        if (null == item){
            return;
        }
        //统一做BigDecimal,integer,Date类型格式转换
        ObjectConvertStringUtil.fillObjectStrProperties(item, ActivityPlanBudgetVo.class,propertyMap);
        BigDecimal useAmount = Optional.ofNullable(item.getUseAmount()).orElse(BigDecimal.ZERO);
        BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
        item.setUsedAmount(usedAmount);
        item.setUsableAmount(useAmount.subtract(usedAmount));
    }


}

