package com.biz.crm.tpm.business.activity.plan.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanItemModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.mapper.ActivityPlanItemModifyMapper;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemTerminalModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.submitreportvo.ActivityPlanSubmitReportSubVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyItemModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyItemModifyVo;
import com.biz.crm.tpm.business.month.budget.sdk.constant.MonthBudgetConstant;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动方案变更
 * @author wanghaojia
 * @date 2022/12/6 14:24
 */
@Component
public class ActivityPlanItemModifyRepository extends ServiceImpl<ActivityPlanItemModifyMapper, ActivityPlanItemModify> {

    @Autowired(required = false)
    private ActivityPlanItemModifyMapper activityPlanItemModifyMapper;

    @Autowired(required = false)
    private ActivityPlanBudgetModifyRepository activityPlanBudgetModifyRepository;

    @Autowired(required = false)
    private ActivityPlanItemTerminalModifyRepository activityPlanItemTerminalModifyRepository;

    @Autowired(required = false)
    private ActivityPlanItemRepository activityPlanItemRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    private final static String DATE_FORMAT_STR = "%Y-%m";

    /**
     * 查询dto集合
     * @param modifyCode 变更编码
     * @return
     */
    public List<ActivityPlanItemModifyDto> findDtoListByModifyCode(String modifyCode) {
        if (StringUtils.isBlank(modifyCode)){
            return Lists.newArrayList();
        }
        ActivityPlanItemModifyDto dto = new ActivityPlanItemModifyDto();
        dto.setModifyBusinessCode(modifyCode);
        List<ActivityPlanItemModify> itemList = findList(dto);
        List<ActivityPlanItemModifyDto> dtoList = (List<ActivityPlanItemModifyDto>) nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanItemModify.class, ActivityPlanItemModifyDto.class, HashSet.class, ArrayList.class);
        fillDtoListProperties(dtoList);
        return dtoList;
    }


    /**
     * 查策略明细信息及其附加其他信息
     * @param modifyCode 方案编码
     * @return
     */
    public List<ActivityPlanItemModifyDto> findDtoAndAttachListByModifyCode(String modifyCode){
        List<ActivityPlanItemModifyDto> dtoList = findDtoListByModifyCode(modifyCode);

        List<String> planItemCodeList = dtoList.stream().map(ActivityPlanItemModifyDto::getPlanItemCode).collect(Collectors.toList());
        List<ActivityPlanItemDto> planItemDtos = activityPlanItemRepository.findDtoAndAttachListByPlanItemCodeList(planItemCodeList);
        Map<String, ActivityPlanItemDto> planItemDtoMap = planItemDtos.stream().collect(Collectors.toMap(ActivityPlanItemDto::getPlanItemCode, Function.identity()));
        for (ActivityPlanItemModifyDto activityPlanItemModifyDto : dtoList) {
            ActivityPlanItemModify modifyItem = nebulaToolkitService.copyObjectByWhiteList(activityPlanItemModifyDto, ActivityPlanItemModify.class, HashSet.class, ArrayList.class);
            ActivityPlanItemDto planItemDto = planItemDtoMap.get(activityPlanItemModifyDto.getPlanItemCode());
            BeanUtils.copyProperties(planItemDto,activityPlanItemModifyDto);
            BeanUtils.copyProperties(modifyItem,activityPlanItemModifyDto);
            if (planItemDto.getUsedHeadFeeAmount().compareTo(activityPlanItemModifyDto.getUsedHeadFeeAmount()) > 0){
                activityPlanItemModifyDto.setUsedHeadFeeAmount(planItemDto.getUsedHeadFeeAmount());
            }
            if (planItemDto.getUsedDepartmentFeeAmount().compareTo(activityPlanItemModifyDto.getUsedDepartmentFeeAmount()) > 0){
                activityPlanItemModifyDto.setUsedDepartmentFeeAmount(planItemDto.getUsedDepartmentFeeAmount());
            }
            if (planItemDto.getUsedCustomerFeeAmount().compareTo(activityPlanItemModifyDto.getUsedCustomerFeeAmount()) > 0){
                activityPlanItemModifyDto.setUsedCustomerFeeAmount(planItemDto.getUsedCustomerFeeAmount());
            }
        }
        this.fillDtoListProperties(dtoList);

        //营销策略就附带一个预算
        List<ActivityPlanBudgetModifyDto> budgetList = activityPlanBudgetModifyRepository.listDtoListByModifyCode(modifyCode);
        if (!CollectionUtils.isEmpty(budgetList)){
            convertMonthBudgetProperty(budgetList);
            for (ActivityPlanBudgetModifyDto budgetDto : budgetList) {
                NumberStringDealUtil.setStringIfNotNull(budgetDto.getUseAmount(), budgetDto::setUseAmountStr);
            }
            Map<String, List<ActivityPlanBudgetModifyDto>> budgetMap = budgetList.stream().filter(item -> StringUtils.isNotBlank(item.getPlanItemCode())).collect(Collectors.groupingBy(ActivityPlanBudgetModifyDto::getPlanItemCode));
            for (ActivityPlanItemModifyDto itemDto : dtoList) {
                if (!budgetMap.containsKey(itemDto.getPlanItemCode())){
                    continue;
                }
                List<ActivityPlanBudgetModifyDto> budgetShares = budgetMap.get(itemDto.getPlanItemCode());
                itemDto.setBudgetShares(budgetShares);
            }
        }
        List<ActivityPlanItemTerminalModifyDto> terminalModifyDtos = activityPlanItemTerminalModifyRepository.listDtoListByModifyCode(modifyCode);
        if (!CollectionUtils.isEmpty(terminalModifyDtos)){
            Map<String, List<ActivityPlanItemTerminalModifyDto>> terminalMap = terminalModifyDtos.stream().collect(Collectors.groupingBy(ActivityPlanItemTerminalDto::getPlanItemCode));
            for (ActivityPlanItemModifyDto itemDto : dtoList) {
                if (terminalMap.containsKey(itemDto.getPlanItemCode())){
                    itemDto.setActivityPlanItemTerminalList(terminalMap.get(itemDto.getPlanItemCode()));
                }
            }
        }
        return dtoList;
    }

    /**
     * 转换字段
     */
    public void convertMonthBudgetProperty(List<ActivityPlanBudgetModifyDto> list){
        if (CollectionUtils.isEmpty(list)){
            return;
        }
        Map<String,String> feeSourceMap = Maps.newHashMap();
        if (null != dictDataVoService){
            try {
                List<DictDataVo> feeSourceList = dictDataVoService.findByDictTypeCode(MonthBudgetConstant.DICT_TPM_FEE_BELONG_US);
                if (!CollectionUtils.isEmpty(feeSourceList)) {
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> o));
                }

            } catch (Exception e) {
                log.error("费用归口数据字典查询失败：" + e.getMessage());
            }
        }
        for (ActivityPlanBudgetModifyDto vo : list) {
            //费用来源转换
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(vo.getFeeBelongCode())){
                vo.setFeeSourceName(feeSourceMap.getOrDefault(vo.getFeeBelongCode(),vo.getFeeBelongCode()));
            }
        }
    }

    /**
     * 查询dto集合
     * @param planItem 查询参数
     * @return
     */
    public List<ActivityPlanItemModifyDto> findDtoList(ActivityPlanItemModifyDto planItem) {
        List<ActivityPlanItemModify> itemList = findList(planItem);
        List<ActivityPlanItemModifyDto> dtoList = (List<ActivityPlanItemModifyDto>) nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanItemModify.class, ActivityPlanItemModifyDto.class, HashSet.class, ArrayList.class);
        fillDtoListProperties(dtoList);
        return dtoList;
    }

    /**
     * 根据查询条件筛选集合
     * @param modifyBusinessCode 变更编码
     */
    public List<ActivityPlanItemModify> findListByModifyBusinessCode(String modifyBusinessCode) {
        if (StringUtils.isBlank(modifyBusinessCode)){
            return Lists.newArrayList();
        }
        ActivityPlanItemModifyDto dto = new ActivityPlanItemModifyDto();
        dto.setModifyBusinessCode(modifyBusinessCode);
        return findList(dto);
    }

    /**
     * 根据查询条件筛选集合
     * @param planItem 查询参数
     */
    public List<ActivityPlanItemModify> findList(ActivityPlanItemModifyDto planItem) {
        return this.list(Wrappers.lambdaQuery(ActivityPlanItemModify.class)
//                .eq(StringUtils.isNotBlank(planItem.getPlanCode()),ActivityPlanItemModify::getPlanCode, planItem.getPlanCode())
                .eq(StringUtils.isNotBlank(planItem.getModifyBusinessCode()),ActivityPlanItemModify::getModifyBusinessCode, planItem.getModifyBusinessCode())
//                .eq(StringUtils.isNotBlank(planItem.getTemplateConfigCode()),ActivityPlanItemModify::getTemplateConfigCode, planItem.getTemplateConfigCode())
                .eq(ActivityPlanItemModify::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        );
    }

    /**
     * 通过id删除
     * @param ids id集合
     */
    public void deleteByIds(List<String> ids){
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<ActivityPlanItemModify> updateWrapper = new UpdateWrapper<ActivityPlanItemModify>().lambda();
        updateWrapper.set(ActivityPlanItemModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanItemModify::getId, ids);
        this.update(updateWrapper);
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoListProperties(List<ActivityPlanItemModifyVo> voList) {
        if (CollectionUtils.isEmpty(voList)){
            return;
        }
        for (ActivityPlanItemModifyVo item : voList) {
            this.fillVoProperties(item);
        }
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoProperties(ActivityPlanItemModifyVo item) {
        if (null == item){
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties(item,ActivityPlanItemModifyVo.class);
        BigDecimal feeAmount = Optional.ofNullable(item.getTotalFeeAmount()).orElse(BigDecimal.ZERO);
        BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
        item.setUsedAmount(usedAmount);
        item.setUsableAmount(feeAmount.subtract(usedAmount));
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillDtoListProperties(List<ActivityPlanItemModifyDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)){
            return;
        }
        for (ActivityPlanItemModifyDto item : dtoList) {
            this.fillDtoProperties(item);
        }
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillDtoProperties(ActivityPlanItemModifyDto item) {
        if (null == item){
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties(item,ActivityPlanItemModifyDto.class);
        item.setActivityType(item.getActivityTypeCode());
        item.setActivityForm(item.getActivityFormCode());
    }

    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)){
            return;
        }
        LambdaUpdateWrapper<ActivityPlanItemModify> updateWrapper = new UpdateWrapper<ActivityPlanItemModify>().lambda();
        updateWrapper.set(ActivityPlanItemModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanItemModify::getModifyBusinessCode, modifyCodes);
        updateWrapper.eq(ActivityPlanItemModify::getTenantCode, TenantUtils.getTenantCode());
        this.update(updateWrapper);
    }

    public List<ActivityPlanSubmitReportSubVo> modifySubmitPageReportDimension1(List<String> planCodeList, List<String> modifyBusinessCodeList) {
        if (CollectionUtils.isEmpty(planCodeList) && CollectionUtils.isEmpty(modifyBusinessCodeList)) {
            return Collections.emptyList();
        }
        return activityPlanItemModifyMapper.modifySubmitPageReportDimension1(planCodeList, modifyBusinessCodeList, DATE_FORMAT_STR);
    }

    public List<ActivityPlanSubmitReportSubVo> modifySubmitPageReportDimension3(List<String> planCodeList, List<String> modifyBusinessCodeList) {
        if (CollectionUtils.isEmpty(planCodeList) && CollectionUtils.isEmpty(modifyBusinessCodeList)) {
            return Collections.emptyList();
        }
        return activityPlanItemModifyMapper.modifySubmitPageReportDimension3(planCodeList, modifyBusinessCodeList, DATE_FORMAT_STR);
    }


    public Page<ActivityPlanItemModifyVo> findByConditions(Pageable pageable, ActivityPlanItemModifyDto dto) {
        Page<ActivityPlanItemModifyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<ActivityPlanItemModifyVo> pageList = this.activityPlanItemModifyMapper.findByConditions(page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

    public Page<ActivityPlanItemModifyVo> findItemBeforeModifyList(Pageable pageable, ActivityPlanItemModifyDto dto) {
        Page<ActivityPlanItemModifyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<ActivityPlanItemModifyVo> pageList = this.activityPlanItemModifyMapper.findItemBeforeModifyList(page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }
}
