package com.biz.crm.tpm.business.activity.plan.local.modify.repository;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanItemTerminalModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.mapper.ActivityPlanItemTerminalModifyMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemTerminalModifyDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 活动方案变更
 * @author wanghaojia
 * @date 2022/12/6 14:24
 */
@Component
public class ActivityPlanItemTerminalModifyRepository extends ServiceImpl<ActivityPlanItemTerminalModifyMapper, ActivityPlanItemTerminalModify> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ActivityPlanItemTerminalModify> findByModifyBusinessCode(String modifyBusinessCode) {
        return this.list(Wrappers.<ActivityPlanItemTerminalModify>lambdaQuery()
                .eq(ActivityPlanItemTerminalModify::getModifyBusinessCode,modifyBusinessCode)
                .eq(ActivityPlanItemTerminalModify::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanItemTerminalModify::getTenantCode, TenantUtils.getTenantCode())
        );
    }

    public List<ActivityPlanItemTerminalModify> findByModifyBusinessAndPlanItemCode(String modifyBusinessCode, String planItemCode) {
        return this.list(Wrappers.<ActivityPlanItemTerminalModify>lambdaQuery()
                .eq(ActivityPlanItemTerminalModify::getModifyBusinessCode,modifyBusinessCode)
                .eq(ActivityPlanItemTerminalModify::getPlanItemCode,planItemCode)
                .eq(ActivityPlanItemTerminalModify::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanItemTerminalModify::getTenantCode, TenantUtils.getTenantCode())
        );
    }

    public void deleteByModifyBusinessCode(String modifyBusinessCode){
        this.remove(Wrappers.<ActivityPlanItemTerminalModify>lambdaQuery()
                .eq(ActivityPlanItemTerminalModify::getModifyBusinessCode,modifyBusinessCode)
                .eq(ActivityPlanItemTerminalModify::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanItemTerminalModify::getTenantCode, TenantUtils.getTenantCode())
        );
    }

    public void deleteByModifyBusinessCode(List<String> modifyBusinessCodeList){
        this.remove(Wrappers.<ActivityPlanItemTerminalModify>lambdaQuery()
                .in(ActivityPlanItemTerminalModify::getModifyBusinessCode,modifyBusinessCodeList)
                .eq(ActivityPlanItemTerminalModify::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanItemTerminalModify::getTenantCode, TenantUtils.getTenantCode())
        );
    }

    /**
     * 根据方案编码，查询方案对应预算
     **/
    public List<ActivityPlanItemTerminalModifyDto> listDtoListByModifyCode(String modifyBusinessCode) {
        List<ActivityPlanItemTerminalModify> entityList = listByModifyCode(modifyBusinessCode);
        if (CollectionUtils.isNotEmpty(entityList)){
            List<ActivityPlanItemTerminalModifyDto> dtoList = (List<ActivityPlanItemTerminalModifyDto>) nebulaToolkitService.copyCollectionByBlankList(entityList,ActivityPlanItemTerminalModify.class,ActivityPlanItemTerminalModifyDto.class, HashSet.class, ArrayList.class);
            ObjectConvertStringUtil.fillObjectListStrProperties(dtoList,ActivityPlanItemTerminalModifyDto.class);
            return dtoList;
        }
        return Lists.newArrayList();
    }

    public List<ActivityPlanItemTerminalModify> listByModifyCode(String modifyBusinessCode) {
        if (StringUtils.isBlank(modifyBusinessCode)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(ActivityPlanItemTerminalModify::getModifyBusinessCode, modifyBusinessCode)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

}
