package com.biz.crm.tpm.business.activity.plan.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.modify.mapper.ActivityPlanModifyMapper;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 活动方案变更
 * @author wanghaojia
 * @date 2022/12/6 14:24
 */
@Component
public class ActivityPlanModifyRepository extends ServiceImpl<ActivityPlanModifyMapper, ActivityPlanModify> {

    @Autowired(required = false)
    private ActivityPlanModifyMapper activityPlanModifyMapper;

    /**
     * 获取带调整的方案数据
     * @param pageable 分页参数
     * @param dto 查询参数
     * @return 分页数据
     */
    public Page<ActivityPlanVo> findToModifyList(Pageable pageable, ActivityPlanDto dto) {
        Page<ActivityPlanVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<ActivityPlanVo> pageList = this.activityPlanModifyMapper.findToModifyList(page, dto);
        return pageList;
    }

    public ActivityPlanModify getByCode(String modifyBusinessCode){
        if (StringUtils.isEmpty(modifyBusinessCode)){
            return null;
        }
        return getOne(Wrappers.<ActivityPlanModify>lambdaQuery()
                .eq(ActivityPlanModify::getModifyBusinessCode,modifyBusinessCode)
                .eq(ActivityPlanModify::getTenantCode,TenantUtils.getTenantCode())
        );
    }


    public void deleteIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper<ActivityPlanModify> updateWrapper = new UpdateWrapper<ActivityPlanModify>().lambda();
        updateWrapper.set(ActivityPlanModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanModify::getId, ids);
        this.update(updateWrapper);
    }

    public void updateProcessStatusAndProcessNo(String modifyBusinessCode, String processStatus, String processNo) {
        if (StringUtils.isEmpty(modifyBusinessCode)) {
            return;
        }
        this.update(Wrappers.lambdaUpdate(ActivityPlanModify.class)
                .set(ActivityPlanModify::getProcessStatus, processStatus)
                .set(ActivityPlanModify::getProcessNo, processNo)
                .in(ActivityPlanModify::getModifyBusinessCode, modifyBusinessCode)
                .eq(ActivityPlanModify::getTenantCode, TenantUtils.getTenantCode())
        );
    }


    /**
     * 更新流程状态
     * @param businessNo 业务数据编码
     * @param processStatus 流程状态
     */
    public void updateProcessStatus(String businessNo, String processStatus) {
        if (StringUtils.isEmpty(businessNo)) {
            return;
        }
        this.update(Wrappers.lambdaUpdate(ActivityPlanModify.class)
                .set(ActivityPlanModify::getProcessStatus, processStatus)
                .in(ActivityPlanModify::getModifyBusinessCode, businessNo)
                .eq(ActivityPlanModify::getTenantCode, TenantUtils.getTenantCode())

        );
    }

    public List<ActivityPlanModify> findByProcessNoList(List<String> processNoList) {
        if (CollectionUtils.isEmpty(processNoList)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .select(ActivityPlanModify::getPlanCode, ActivityPlanModify::getBusinessUnitCode, ActivityPlanModify::getModifyBusinessCode)
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(TenantFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(ActivityPlanModify::getProcessNo, processNoList)
                .list();
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoProperties(ActivityPlanModifyVo item) {
        fillVoProperties(item,null);
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoProperties(ActivityPlanModifyVo item, SimpleDateFormat dayFormat) {
        if (null == item){
            return;
        }
        if (null == dayFormat){
            dayFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        }
        if (null != item.getBeginDate()){
            item.setBeginDateStr(dayFormat.format(item.getBeginDate()));
        }
        if (null != item.getEndDate()){
            item.setEndDateStr(dayFormat.format(item.getEndDate()));
        }
//
//        BigDecimal feeAmount = Optional.ofNullable(item.getTotalFeeAmount()).orElse(BigDecimal.ZERO);
//        BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
//        item.setUsedAmount(usedAmount);
//        item.setUsableAmount(feeAmount.subtract(usedAmount));
    }

}
