package com.biz.crm.tpm.business.activity.plan.local.modify.repository;


import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanRelatePlanMapper;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanRelatePlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.mapper.ActivityPlanRelatePlanModifyMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanRelatePlanModifyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;


/**
 * 活动方案表(ActivityPlan)表数据库访问层
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:54
 */
@Component
public class ActivityPlanRelatePlanModifyRepository extends ServiceImpl<ActivityPlanRelatePlanModifyMapper, ActivityPlanRelatePlanModify> {

    @Autowired(required = false)
    private ActivityPlanRelatePlanMapper activityPlanRelatePlanMapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    /**
     * 根据方案编码查询方案关联策略数据
     * @param modifyCode 方案编码
     * @return 方案明细dtolist
     */
    public List<ActivityPlanRelatePlanModifyVo> findListVoByModifyCode(String modifyCode) {
        if (StringUtils.isBlank(modifyCode)){
            return null;
        }
        List<ActivityPlanRelatePlanModify> itemList = findListByModifyCode(modifyCode);
        return (List<ActivityPlanRelatePlanModifyVo>) nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanRelatePlanModify.class, ActivityPlanRelatePlanModifyVo.class, HashSet.class, ArrayList.class);
    }

    public List<ActivityPlanRelatePlanModify> findListByModifyCode(String modifyCode) {
        if (StringUtils.isBlank(modifyCode)){
            return null;
        }
        return this.list(Wrappers.lambdaQuery(ActivityPlanRelatePlanModify.class)
                .eq(ActivityPlanRelatePlanModify::getModifyBusinessCode, modifyCode)
                .eq(ActivityPlanRelatePlanModify::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        );
    }

    /**
     * 通过id删除
     * @param ids id集合
     */
    public void deleteByIds(List<String> ids){
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<ActivityPlanRelatePlanModify> updateWrapper = new UpdateWrapper<ActivityPlanRelatePlanModify>().lambda();
        updateWrapper.set(ActivityPlanRelatePlanModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanRelatePlanModify::getId, ids);
        this.update(updateWrapper);
    }

    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)){
            return;
        }
        LambdaUpdateWrapper<ActivityPlanRelatePlanModify> updateWrapper = new UpdateWrapper<ActivityPlanRelatePlanModify>().lambda();
        updateWrapper.set(ActivityPlanRelatePlanModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanRelatePlanModify::getModifyBusinessCode, modifyCodes);
        this.update(updateWrapper);
    }

}

